/*
	LMPageSetup.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMPageSetup.h"

LMPageSetup::LMPageSetup(BMessage * msg)
 : BWindow(BRect(0,0,SETUP_WIDTH, SETUP_HEIGHT), "Page Setup", B_TITLED_WINDOW_LOOK,
 			B_MODAL_APP_WINDOW_FEEL, B_NOT_RESIZABLE | B_NOT_MINIMIZABLE |
 			B_NOT_ZOOMABLE)
{
	print_msg = msg;
	sem = create_sem(0, "LMPageSetup");
	view = new LMPageSetupView(msg);
	Lock();
	AddChild(view);
	Unlock();
}

LMPageSetup::~LMPageSetup()
{
}

void
LMPageSetup::MessageReceived(BMessage * msg)
{
	switch (msg->what)
	{
		case M_OK:
			((LMPageSetupView *)ChildAt(0))->UpdatePageData(print_msg);
			result = B_OK;
			release_sem(sem);
			break;
		
		case M_CANCEL:
			result = B_ERROR;
			release_sem(sem);
			break;
			
		default:
			BWindow::MessageReceived(msg);
			break;
	}
}
			
bool LMPageSetup::QuitRequested()
{
	result = B_ERROR;
	release_sem(sem);
	return true;
}

status_t
LMPageSetup::Go()
{
	MoveTo(300,300);
	Show();
	acquire_sem(sem);
	delete_sem(sem);
	Lock();
	Quit();
	return result;
}
