/*
	LMPageSetupView.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMPageSetupView.h"
#include <stdlib.h>
#include <stdio.h>

#define M_TOP 10
#define M_LEFT 10
#define M_WIDTH 100
#define M_HEIGHT 110

#define ML_LEFT 10
#define ML_WIDTH 80
#define ML_TOP 15
#define ML_HEIGHT 12
#define ML_Y_PAD 10

#define P_TOP 10
#define P_LEFT 120
#define P_WIDTH 170
#define P_HEIGHT 60

#define PL_LEFT 10
#define PL_TOP 20
#define PL_WIDTH 150
#define PL_HEIGHT 12

#define Q_TOP 80
#define Q_LEFT 120
#define Q_WIDTH 170
#define Q_HEIGHT 60

#define QL_LEFT 10
#define QL_TOP 20
#define QL_WIDTH 150
#define QL_HEIGHT 12

#define O_LEFT 10
#define O_TOP 130
#define O_HEIGHT 60
#define O_WIDTH 100

#define OL_TOP 15
#define OL_LEFT 10
#define OL_WIDTH 80
#define OL_HEIGHT 12

#define B_TOP 150
#define B_WIDTH 80
#define B_LEFT 120
#define B_HEIGHT 40

LMPageSetupView::LMPageSetupView(BMessage * msg) 
: BView(BRect(0,0,SETUP_WIDTH, SETUP_HEIGHT), "Page Setup View", B_FOLLOW_ALL, B_WILL_DRAW)
{
	this->msg = msg;
}


void
LMPageSetupView::AttachedToWindow()
{
	int i;
	char text[100];
	BTextView * t;

	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	marginbox = new BBox(BRect(M_LEFT, M_TOP, M_LEFT + M_WIDTH, M_TOP + M_HEIGHT),
						"Margins");
	marginbox->SetLabel("Margins");
	AddChild(marginbox);
	
	t_top = new BTextControl(BRect(ML_LEFT, ML_TOP,
							ML_LEFT + ML_WIDTH, ML_TOP + ML_HEIGHT),
							"Top Margin", "Top:", "1.00", NULL);
	t = (BTextView *)t_top->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
	t->AllowChar(46);
	
	t_bottom = new BTextControl(BRect(ML_LEFT, ML_TOP + (ML_HEIGHT + ML_Y_PAD),
							ML_LEFT + ML_WIDTH,
							ML_TOP + (ML_HEIGHT + ML_Y_PAD) + ML_HEIGHT),
							"Bottom Margin", "Bottom:", "1.00", NULL);
	t = (BTextView *)t_bottom->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
	t->AllowChar(46);
							
	t_left = new BTextControl(BRect(ML_LEFT, ML_TOP + 2 * (ML_HEIGHT + ML_Y_PAD), 
							ML_LEFT + ML_WIDTH,
							ML_TOP + 2 * (ML_HEIGHT + ML_Y_PAD) + ML_HEIGHT),
							"Left Margin", "Left:", "1.00", NULL);
	t = (BTextView *)t_left->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
	t->AllowChar(46);
							
	t_right = new BTextControl(BRect(ML_LEFT, ML_TOP + 3 * (ML_HEIGHT + ML_Y_PAD), 
							ML_LEFT + ML_WIDTH,
							ML_TOP + 3 * (ML_HEIGHT + ML_Y_PAD) + ML_HEIGHT),
							"Left Margin", "Right:", "1.00", NULL);
	t = (BTextView *)t_right->ChildAt(0);
	for (i=0; i<256; i++)
		t->DisallowChar(i);
	for (i=48; i<58; i++)
		t->AllowChar(i);
	t->AllowChar(46);
	
	marginbox->AddChild(t_top);
	marginbox->AddChild(t_bottom);
	marginbox->AddChild(t_left);
	marginbox->AddChild(t_right);
	
	paperbox = new BBox(BRect(P_LEFT, P_TOP, P_LEFT + P_WIDTH, P_TOP + P_HEIGHT),
						"Paper");
	paperbox->SetLabel("Paper Size");
	AddChild(paperbox);
	
	l_paper = new BStringView(BRect(PL_LEFT, PL_TOP, PL_LEFT + PL_WIDTH,
				 PL_TOP + PL_HEIGHT), "Paper Size Label",
				 "Driver currently supports");
				 
	l_paper2 = new BStringView(BRect(PL_LEFT, PL_TOP + PL_HEIGHT, PL_LEFT + PL_WIDTH,
				 PL_TOP + PL_HEIGHT + PL_HEIGHT), "Paper Size Label2",
				 "Letter sized paper only.");
				 
	paperbox->AddChild(l_paper);
	paperbox->AddChild(l_paper2);
	
	qualitybox = new BBox(BRect(Q_LEFT, Q_TOP, Q_LEFT + Q_WIDTH, Q_TOP + Q_HEIGHT),
						"Quality");
	qualitybox->SetLabel("Print Quality");
	AddChild(qualitybox);
	
	l_quality = new BStringView(BRect(QL_LEFT, QL_TOP, QL_LEFT + QL_WIDTH,
				 QL_TOP + QL_HEIGHT), "Print Quality Label",
				 "Driver currently supports");
				 
	l_quality2 = new BStringView(BRect(QL_LEFT, QL_TOP + QL_HEIGHT, QL_LEFT + QL_WIDTH,
				 QL_TOP + QL_HEIGHT + QL_HEIGHT), "Print Qaulity Label2",
				 "600 DPI Black and White only.");
				 
	qualitybox->AddChild(l_quality);
	qualitybox->AddChild(l_quality2);
	
	orientbox = new BBox(BRect(O_LEFT, O_TOP, O_LEFT + O_WIDTH, O_TOP + O_HEIGHT),
						"Orientation");
	orientbox->SetLabel("Orientation");
	AddChild(orientbox);
	
	portrait = new BRadioButton(BRect(OL_LEFT, OL_TOP, OL_LEFT + OL_WIDTH,
								OL_TOP + OL_HEIGHT), "portrait",
								"Portrait", NULL);
	portrait->SetValue(1);
	
	landscape = new BRadioButton(BRect(OL_LEFT, OL_TOP + ML_Y_PAD + OL_HEIGHT,
								OL_LEFT + OL_WIDTH,
								OL_TOP + OL_HEIGHT + OL_HEIGHT + ML_Y_PAD),
								"landscape",
								"Landscape", NULL);
	
	orientbox->AddChild(portrait);
	orientbox->AddChild(landscape);
	
	cancel = new BButton(BRect(B_LEFT, B_TOP, B_LEFT + B_WIDTH, B_TOP + B_HEIGHT),
						"cancel", "Cancel", new BMessage(M_CANCEL));
						
	AddChild(cancel);
	
	ok = new BButton(BRect(B_LEFT + ML_Y_PAD + B_WIDTH, B_TOP,
					B_LEFT + B_WIDTH + B_WIDTH + ML_Y_PAD,
					B_TOP + B_HEIGHT),
					"ok", "OK", new BMessage(M_OK));
	ok->MakeDefault(true);
	
	AddChild(ok);
	
	if (msg)
	{
		if (msg->HasRect("paper_rect") && msg->HasRect("printable_rect"))
		{
			sprintf(text,"%.2f", msg->FindRect("printable_rect").left / SCREEN);
			t_left->SetText(text);
			
			sprintf(text,"%.2f", msg->FindRect("printable_rect").top / SCREEN);
			t_top->SetText(text);
			
			sprintf(text,"%.2f", (msg->FindRect("paper_rect").right - 
								msg->FindRect("printable_rect").right) / SCREEN);
			t_right->SetText(text);
			
			sprintf(text,"%.2f", (msg->FindRect("paper_rect").bottom - 
								msg->FindRect("printable_rect").bottom) / SCREEN);
			t_bottom->SetText(text);
		}
		
		if (msg->HasInt32("orientation"))
		{
			if (msg->FindInt32("orientation") == PORTRAIT)
				portrait->SetValue(1);
			else
				landscape->SetValue(1);
		}
	}
}

LMPageSetupView::~LMPageSetupView()
{
}

void
LMPageSetupView::UpdatePageData(BMessage * msg)
{	
	int32 orient;
	BRect paper_rect;
	BRect print_rect;
					  
	if (!msg)
		return;
	
	if (msg->HasInt64("xres"))
		msg->ReplaceInt64("xres", 600);
	else
		msg->AddInt64("xres", 600);
		
	if (msg->HasInt64("yres"))
		msg->ReplaceInt64("yres", 600);
	else
		msg->AddInt64("yres", 600);
				
	if (portrait->Value() == 0)
		orient = LANDSCAPE;
	else
		orient = PORTRAIT;
		
	if (msg->HasInt32("orientation"))
		msg->ReplaceInt32("orientation", orient);
	else
		msg->AddInt32("orientation", orient);
			
	if (orient == PORTRAIT)
		paper_rect = BRect(0, 0, LETTER_WIDTH * SCREEN, LETTER_HEIGHT * SCREEN);
	else
		paper_rect = BRect(0, 0, LETTER_HEIGHT * SCREEN, LETTER_WIDTH * SCREEN);

	print_rect = BRect(atof(t_left->Text()) * SCREEN,
			atof(t_top->Text()) * SCREEN,
			paper_rect.right - atof(t_right->Text()) * SCREEN,
			paper_rect.bottom - atof(t_bottom->Text()) * SCREEN);
 	
	if (msg->HasRect("paper_rect"))
		msg->ReplaceRect("paper_rect", paper_rect);
	else
		msg->AddRect("paper_rect", paper_rect);

	if (msg->HasRect("printable_rect"))
		msg->ReplaceRect("printable_rect", print_rect);
	else
		msg->AddRect("printable_rect", print_rect);
	 		
	if (msg->HasFloat("scaling"))
		msg->ReplaceFloat("scaling", SCREEN);
	else
		msg->AddFloat("scaling", SCREEN);
}
	

