/*
	LMPageSetupView.h
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#ifndef LM_PAGESETUP_VIEW_H
#define LM_PAGESETUP_VIEW_H

#include <InterfaceKit.h>
#include "LMDefs.h"

#define SETUP_HEIGHT 200
#define SETUP_WIDTH 300

#define M_OK 1
#define M_CANCEL 2

class LMPageSetupView : public BView
{
public:

	LMPageSetupView(BMessage * msg);
	~LMPageSetupView();

	virtual void AttachedToWindow();
	void UpdatePageData(BMessage * msg);
	
private:
	BBox * marginbox;
	BBox * paperbox;
	BBox * qualitybox;
	BBox * orientbox;
	BTextControl * t_top;
	BTextControl * t_bottom;
	BTextControl * t_left;
	BTextControl * t_right;
	BStringView * l_paper;
	BStringView * l_paper2;
	BStringView * l_quality;
	BStringView * l_quality2;
	BRadioButton * portrait;
	BRadioButton * landscape;
	BButton * ok;
	BButton * cancel;
	
	BMessage * msg;
	
};



#endif
