/*
	LMSwipe.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMSwipe.h"

// swipe escape sequence
#define ESC_LEN 3
const static byte escape[ESC_LEN] = {0x1b, 0x2a, 0x04};

// mode byte for black 600dpi
#define MODE_LEN 1
const static byte mode[MODE_LEN] = {0x02};

// pen select bytes, black
#define PENS_LEN 2
const static byte pens[PENS_LEN] = {0x01, 0x01};
 
// nozzle count, 208 here
#define NOZ_LEN 1
const static byte nozzles[NOZ_LEN] = {0x1a};

// mystery byte -- oooh scary!
#define MYS_LEN 1
const static byte mystery[MYS_LEN] = {0x11};

// driver id
#define ID_LEN 4
const static byte id[ID_LEN] = {0x22, 0x33, 0x44, 0x55};

// Here's the sequence:
// escape, length, 0, mode, pens, nozzles, mystery, count, start, end, 0, 0, id, 1

LMSwipe::LMSwipe()
{
	length = 0;
	count = 0;
	start = 0;
	end = 0;
}
	
LMSwipe::LMSwipe(int32 length, int16 count, int16 start, int16 end)
{
	this->length = length;
	this->count = count;
	this->start = start;
	this->end = end;
}

LMSwipe::~LMSwipe()
{
}

	
status_t 
LMSwipe::Write(BDataIO * file)
{
	byte zero = 0x00;
	byte one = 0x01;
	int32 result;
	int32 l;
	int16 c;
	int16 s;
	int16 e;
	
	l = htonl(length);
	c = htons(count);
	s = htons(start);
	e = htons(end);
	
	result = file->Write(escape, ESC_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(&l, 4);
	if (!result)
		return B_ERROR;
	result = file->Write(&zero, 1);
	if (!result)
		return B_ERROR;
	result = file->Write(mode, MODE_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(pens, PENS_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(nozzles, NOZ_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(mystery, MYS_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(&c, 2);
	if (!result)
		return B_ERROR;
	result = file->Write(&s, 2);
	if (!result)
		return B_ERROR;
	result = file->Write(&e, 2);
	if (!result)
		return B_ERROR;
	result = file->Write(&zero, 1);
	if (!result)
		return B_ERROR;
	result = file->Write(&zero, 1);
	if (!result)
		return B_ERROR;
	result = file->Write(id, ID_LEN);
	if (!result)
		return B_ERROR;
	result = file->Write(&one, 1);
	if (!result)
		return B_ERROR;
		
	return B_OK;
}


void
LMSwipe::SetComLength(int32 length)
{
	this->length = length;
}

void 
LMSwipe::SetColCount(int16 count)
{
	this->count = count;
}

void 
LMSwipe::SetStartCol(int16 start)
{
	this->start = start;
}

void 
LMSwipe::SetEndCol(int16 end)
{
	this->end = end;
}
