/*
	LMSwipe.h
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#ifndef _LM_SWIPE_H
#define _LM_SWIPE_H

#include "LMDefs.h"

#define SWIPE_LEN 26

class LMSwipe
{
public:

	LMSwipe();
	LMSwipe(int32 length, int16 count, int16 start, int16 end);
	virtual ~LMSwipe();
	
	status_t Write(BDataIO * file);
	void SetComLength(int32 length);
	void SetColCount(int16 count);
	void SetStartCol(int16 start);
	void SetEndCol(int16 end);
	
private:
	int32 length;
	int16 count;
	int16 start;
	int16 end;
};

#endif

	