/*
	lex5700.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "lex5700.h"
#include "LMPageSetup.h"
#include "LMJobSetup.h"
#include "LMDriver.h"
 
BMessage * take_job(BFile * spool_file, BNode * spool_dir, BMessage * msg)
{
	LMDriver * drv = new LMDriver();
	
	if (drv->Print(spool_file, spool_dir, msg) == B_OK)
		msg = new BMessage('okok');
	else
		msg = new BMessage('baad');
		
	delete drv;
	
	return msg;
}

BMessage * config_page(BNode * spool_dir, BMessage * msg)
{
	BMessage * mymsg = new BMessage(*msg);
	
	LMPageSetup * setup = new LMPageSetup(mymsg);
	if (setup->Go() == B_OK)
		mymsg->what = ('okok');
	else
	{
		delete mymsg;
		return NULL;
	}
	
	return mymsg;
}

BMessage * config_job(BNode * spool_dir, BMessage * msg)
{ 
	BMessage * mymsg = new BMessage(*msg);
	
	LMJobSetup * setup = new LMJobSetup(mymsg);
	if (setup->Go() == B_OK)
		mymsg->what = ('okok');
	else
	{
		delete mymsg;
		return NULL;
	}
	
	return mymsg;
}

char * add_printer(char * printer_name)
{
	return printer_name; 
}
