/*
 * mpg123 defines 
 * used source: musicout.h from mpegaudio package
 */

#if defined(__cplusplus)
	#define EXTERN extern "C"
#else
	#define EXTERN extern
#endif

#include        <stdio.h>
#include        <string.h>
#include        <signal.h>
#include        <math.h>

#include        <unistd.h>

#ifdef OS2
#include <float.h>
#endif

#define MPG123_REMOTE
#define SHUFFLESUPPORT
#ifdef HPUX
#define random rand
#define srandom srand
#endif

#define FRONTEND_SAJBER 1
#define FRONTEND_TK3PLAY 2


#ifdef SGI
#include <audio.h>
#endif

#include "xfermem.h"

#ifdef SUNOS
#define memmove(dst,src,size) bcopy(src,dst,size)
#endif

#ifdef REAL_IS_FLOAT
#  define real float
#elif defined(REAL_IS_LONG_DOUBLE)
#  define real long double
#else
#  define real double
#endif

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE
#endif

#if defined(LINUX) || defined(__FreeBSD__)
#define VOXWARE
#endif

#include "audio.h"

/* AUDIOBUFSIZE = n*64 with n=1,2,3 ...  */
#define		AUDIOBUFSIZE		16384

#define         FALSE                   0
#define         TRUE                    1

#define         MAX_NAME_SIZE           81
#define         SBLIMIT                 32
#define         SCALE_BLOCK             12
#define         SSLIMIT                 18

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

#define MAXOUTBURST 32768


struct al_table 
{
  short bits;
  short d;
};

struct frame {
    struct al_table *alloc;
    int (*synth)(real *,int,unsigned char *);
    int (*synth_mono)(real *,unsigned char *);
    int stereo;
    int jsbound;
    int single;
    int II_sblimit;
    int lsf;
    int mpeg25;
    int down_sample;
    int header_change;
    int block_size;
    int lay;
	int (*do_layer)(struct frame *fr, int, struct audio_info_struct *);
    int error_protection;
    int bitrate_index;
    int sampling_frequency;
    int padding;
    int extension;
    int mode;
    int mode_ext;
    int copyright;
    int original;
    int emphasis;
};

EXTERN int outmode;  
EXTERN int tryresync;
EXTERN int quiet;
EXTERN int halfspeed;
EXTERN int usebuffer;
EXTERN int buffer_fd[2];
EXTERN txfermem *buffermem;
EXTERN char *prgName, *prgVersion;
EXTERN int intflag;

#ifndef OS2
EXTERN void buffer_loop(struct audio_info_struct *ai, sigset_t *oldsigset);
#endif

/* ------ Declarations from "httpget.c" ------ */

EXTERN char *proxyurl;
EXTERN unsigned long proxyip;
EXTERN FILE *http_open (char *url);

/* ------ Declarations from "common.c" ------ */

EXTERN void audio_flush(int, struct audio_info_struct *);
EXTERN void (*catchsignal(int signum, void(*handler)()))();

EXTERN void print_header(struct frame *);
EXTERN void print_header_compact(struct frame *);

EXTERN char *strndup(const char *src, int num);
EXTERN int split_dir_file(const char *path, char **dname, char **fname);

EXTERN unsigned int   get1bit(void);
EXTERN unsigned int   getbits(int);
EXTERN unsigned int   getbits_fast(int);

EXTERN void set_pointer(long);

EXTERN unsigned char *pcm_sample;
EXTERN int pcm_point;
EXTERN int audiobufsize;

#ifdef VARMODESUPPORT
EXTERN int varmode;
EXTERN int playlimit;
#endif

struct III_sideinfo
{
  unsigned main_data_begin;
  unsigned private_bits;
  struct {
    struct gr_info_s {
      int scfsi;
      unsigned part2_3_length;
      unsigned big_values;
      unsigned scalefac_compress;
      unsigned block_type;
      unsigned mixed_block_flag;
      unsigned table_select[3];
      unsigned subblock_gain[3];
      unsigned maxband[3];
      unsigned maxbandl;
      unsigned maxb;
      unsigned region1start;
      unsigned region2start;
      unsigned preflag;
      unsigned scalefac_scale;
      unsigned count1table_select;
      real *full_gain[3];
      real *pow2gain;
    } gr[2];
  } ch[2];
};

EXTERN void open_stream(char *,int fd);
EXTERN void close_stream(void);
EXTERN long tell_stream(void);
EXTERN void read_frame_init (void);
EXTERN int read_frame(struct frame *fr);
EXTERN int back_frame(struct frame *fr,int num);
EXTERN void play_frame(int init,struct frame *fr);
EXTERN int do_layer3(struct frame *fr,int,struct audio_info_struct *);
EXTERN int do_layer2(struct frame *fr,int,struct audio_info_struct *);
EXTERN int do_layer1(struct frame *fr,int,struct audio_info_struct *);
EXTERN int synth_1to1 (real *,int,unsigned char *);
EXTERN int synth_1to1_float (real *,int,unsigned char *);
EXTERN int synth_1to1_8bit (real *,int,unsigned char *);
EXTERN int synth_2to1 (real *,int,unsigned char *);
EXTERN int synth_2to1_8bit (real *,int,unsigned char *);
EXTERN int synth_4to1 (real *,int,unsigned char *);
EXTERN int synth_4to1_8bit (real *,int,unsigned char *);
EXTERN int synth_1to1_mono (real *,unsigned char *);
EXTERN int synth_1to1_8bit_mono (real *,unsigned char *);
EXTERN int synth_2to1_mono (real *,unsigned char *);
EXTERN int synth_2to1_8bit_mono (real *,unsigned char *);
EXTERN int synth_4to1_mono (real *,unsigned char *);
EXTERN int synth_4to1_8bit_mono (real *,unsigned char *);
EXTERN void rewindNbits(int bits);
EXTERN int  hsstell(void);
EXTERN void set_pointer(long);
EXTERN void huffman_decoder(int ,int *);
EXTERN void huffman_count1(int,int *);

EXTERN void init_layer3(int);
EXTERN void init_layer2(void);
EXTERN void make_decode_tables(long scale);
EXTERN void make_conv16to8_table(int);
EXTERN void dct64(real *,real *,real *);

EXTERN void control_sajber(struct frame *fr);
EXTERN void control_tk3play(struct frame *fr);

EXTERN unsigned char *conv16to8;
EXTERN long freqs[7];
EXTERN real muls[27][64];
EXTERN real decwin[512+32];
EXTERN real *pnts[5];




