#include <SDL/SDL.h>

#include "winlnxdefs.h"
#include "Controller_#1.1.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#endif

static CONTROL_INFO control_info;
static BUTTONS b;
static int shift_state = 0;
static int ctrl_state = 0;
static int left_state = 0;
static int right_state = 0;
static int up_state = 0;
static int down_state = 0;

/******************************************************************
  Function: CloseDLL
  Purpose:  This function is called when the emulator is closing
            down allowing the dll to de-initialise.
  input:    none
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL CloseDLL (void)
#else
EXPORT void CALL CloseDLL_input (void)
#endif
{
}

/******************************************************************
  Function: ControllerCommand
  Purpose:  To process the raw data that has just been sent to a 
            specific controller.
  input:    - Controller Number (0 to 3) and -1 signalling end of 
              processing the pif ram.
			- Pointer of data to be processed.
  output:   none
  
  note:     This function is only needed if the DLL is allowing raw
            data, or the plugin is set to raw

            the data that is being processed looks like this:
            initilize controller: 01 03 00 FF FF FF 
            read controller:      01 04 01 FF FF FF FF
*******************************************************************/
EXPORT void CALL ControllerCommand ( int Control, BYTE * Command)
{
}

/******************************************************************
  Function: DllAbout
  Purpose:  This function is optional function that is provided
            to give further information about the DLL.
  input:    a handle to the window that calls this function
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL DllAbout ( HWND hParent )
#else
EXPORT void CALL DllAbout_input ( HWND hParent )
#endif
{
   char s[] = "Input plugin for Mupen64 emulator\nMade by Hacktarux\n";
#ifdef USE_GTK
   GtkWidget *dialog, *label, *okay_button;
   
   /* Create the widgets */
   
   dialog = gtk_dialog_new();
   label = gtk_label_new (s);
   okay_button = gtk_button_new_with_label("OK");
   
   /* Ensure that the dialog box is destroyed when the user clicks ok. */
   
   gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
			      GTK_SIGNAL_FUNC (gtk_widget_destroy),
			      GTK_OBJECT (dialog));
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		      okay_button);
   
   /* Add the label, and show everything we've added to the dialog. */
   
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		      label);
   gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
   gtk_widget_show_all (dialog);
#else
   printf(s);
#endif
}

/******************************************************************
  Function: DllConfig
  Purpose:  This function is optional function that is provided
            to allow the user to configure the dll
  input:    a handle to the window that calls this function
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL DllConfig ( HWND hParent )
#else
EXPORT void CALL DllConfig_input ( HWND hParent )
#endif
{
}

/******************************************************************
  Function: DllTest
  Purpose:  This function is optional function that is provided
            to allow the user to test the dll
  input:    a handle to the window that calls this function
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL DllTest ( HWND hParent )
#else
EXPORT void CALL DllTest_input ( HWND hParent )
#endif
{
}

/******************************************************************
  Function: GetDllInfo
  Purpose:  This function allows the emulator to gather information
            about the dll by filling in the PluginInfo structure.
  input:    a pointer to a PLUGIN_INFO stucture that needs to be
            filled by the function. (see def above)
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo )
#else
EXPORT void CALL GetDllInfo_input ( PLUGIN_INFO * PluginInfo )
#endif
{
   PluginInfo->Version = 0x0101;
   PluginInfo->Type = PLUGIN_TYPE_CONTROLLER;
   strcpy(PluginInfo->Name, "Mupen64 input plugin");
}

/******************************************************************
  Function: GetKeys
  Purpose:  To get the current state of the controllers buttons.
  input:    - Controller Number (0 to 3)
            - A pointer to a BUTTONS structure to be filled with 
			the controller state.
  output:   none
*******************************************************************/  	
EXPORT void CALL GetKeys(int Control, BUTTONS * Keys )
{
   if (Control == 0)
     Keys->Value = b.Value;
}

/******************************************************************
  Function: InitiateControllers
  Purpose:  This function initialises how each of the controllers 
            should be handled.
  input:    - The handle to the main window.
            - A controller structure that needs to be filled for 
			  the emulator to know how to handle each controller.
  output:   none
*******************************************************************/  
EXPORT void CALL InitiateControllers (CONTROL_INFO ControlInfo)
{
   control_info = ControlInfo;
   control_info.Controls[0].Present = TRUE;
    b.Value =   0x11110000;
}

/******************************************************************
  Function: ReadController
  Purpose:  To process the raw data in the pif ram that is about to
            be read.
  input:    - Controller Number (0 to 3) and -1 signalling end of 
              processing the pif ram.
			- Pointer of data to be processed.
  output:   none  
  note:     This function is only needed if the DLL is allowing raw
            data.
*******************************************************************/
EXPORT void CALL ReadController ( int Control, BYTE * Command )
{
}

/******************************************************************
  Function: RomClosed
  Purpose:  This function is called when a rom is closed.
  input:    none
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL RomClosed (void)
#else
EXPORT void CALL RomClosed_input (void)
#endif
{
}

/******************************************************************
  Function: RomOpen
  Purpose:  This function is called when a rom is open. (from the 
            emulation thread)
  input:    none
  output:   none
*******************************************************************/ 
#ifndef REF_HARD_LINKED
EXPORT void CALL RomOpen (void)
#else
EXPORT void CALL RomOpen_input (void)
#endif
{
}

void update_analogic_state()
{

   if (ctrl_state)
     {
	if (shift_state)
	  {
	     if (left_state) b.Value =  b.Value |    ( 0x00BF0000 );			//b.Y_AXIS = -64;
	     if (right_state) b.Value =  b.Value |  ( 0x00400000 );		// b.Y_AXIS = 64;
	     if (up_state) b.Value =  b.Value |     ( 0x40000000 );			// b.X_AXIS =	64;
	     if (down_state)  b.Value =  b.Value |     ( 0xBF000000 );		// b.X_AXIS = -64;
	  }
	else
	  {
	     if (left_state)  b.Value =  b.Value |    ( 0x00DF0000 );		//b.Y_AXIS = -32;
	     if (right_state) b.Value =  b.Value |    ( 0x00200000 );		//b.Y_AXIS = 32;
	     if (up_state)  b.Value =  b.Value |    ( 0x20000000 );		// b.X_AXIS = 32;
	     if (down_state) b.Value =  b.Value |    ( 0xDF000000 );	//b.X_AXIS = -32;
	  }
     }
   else
     {
	if (shift_state)
	  {
	     if (left_state)  b.Value =  b.Value |    ( 0x009F0000 ); 		//b.Y_AXIS = -96;
	     if (right_state) b.Value =  b.Value |    ( 0x00600000 );		// b.Y_AXIS = 96;
	     if (up_state) b.Value =  b.Value |    ( 0x60000000 )	;		//;b.X_AXIS = 96;
	     if (down_state) b.Value =  b.Value |    ( 0x9F000000 );	//b.X_AXIS = -96;
	  }
	else
	  {
	     if (left_state) b.Value =  b.Value |    ( 0x00800000 );		//b.Y_AXIS = -128;
	     if (right_state)  b.Value =  b.Value |    ( 0x007F0000 );		// b.Y_AXIS = 127;
	     if (up_state)  b.Value =  b.Value |    ( 0x7F000000 );			// b.X_AXIS = 127;
	     if (down_state)  b.Value =  b.Value |    ( 0x80000000 );		// b.X_AXIS = -128;
	  }
     }
   if (left_state == right_state) b.Value =  b.Value &    ( 0xFF00FFFF );	// b.Y_AXIS = 0;
   if (up_state == down_state)  b.Value =  b.Value &    ( 0x00FFFFFF );	//b.X_AXIS = 0;

}

/******************************************************************
  Function: WM_KeyDown
  Purpose:  To pass the WM_KeyDown message from the emulator to the 
            plugin.
  input:    wParam and lParam of the WM_KEYDOWN message.
  output:   none
*******************************************************************/ 
EXPORT void CALL WM_KeyDown( WPARAM wParam, LPARAM lParam )
{
/*
		unsigned R_DPAD       : 1;
		    //1 = 0001
		unsigned L_DPAD       : 1;
		    //2 = 0002
		unsigned D_DPAD       : 1;
		    //3 = 0004
		unsigned U_DPAD       : 1;
		    //4 = 0008
		unsigned START_BUTTON : 1;
	//5 = 0010
		unsigned Z_TRIG       : 1;
			//6 = 0020
		unsigned B_BUTTON     : 1;
		//7 = 0040
		unsigned A_BUTTON     : 1;
		//8 = 0080

		unsigned R_CBUTTON    : 1;
		//9 =   0100
		unsigned L_CBUTTON    : 1;
		//10 = 0200
		unsigned D_CBUTTON    : 1;
		//11 = 0400
		unsigned U_CBUTTON    : 1;
		//12 = 0800
		unsigned R_TRIG       : 1;
			//13 = 1000
		unsigned L_TRIG       : 1;
			//14 = 2000
		unsigned Reserved1    : 1;
		//15 = 4000
		unsigned Reserved2    : 1;
		//16 = 8000
*/	
	
	switch (lParam) // lParam = key symbol
	{
		case SDLK_KP6:
			b.Value =  b.Value | ( 0x00000001 ); 			//R_DPAD
		break;
      	case SDLK_KP4:
			b.Value =  b.Value | ( 0x00000002 );		   //L_DPAD
		break;
      	case SDLK_KP2:
      		b.Value = b.Value | ( 0x00000004 ) ;			//D_DPAD
		break;
     	case SDLK_KP8:
      		b.Value =  b.Value |  ( 0x00000008 );			//U_DPAD
		break;
      	case SDLK_RETURN:
			b.Value =  b.Value |  ( 0x00000010 );			//START_BUTTON
		break;
        case SDLK_SPACE:
             b.Value =  b.Value |  ( 0x00000020  );			//Z_TRIG
		break;
      	case SDLK_x:
			b.Value =  b.Value |  ( 0x00000040  );			//B_BUTTON
		break;
      	case SDLK_w:
      		b.Value =  b.Value |  ( 0x00000080 );			//A_BUTTON
		break;
      	case SDLK_PAGEDOWN:
      		b.Value =  b.Value |  ( 0x00000100  );			//R_CBUTTON
		break;
      	case SDLK_DELETE:
      		b.Value =  b.Value |  ( 0x00000200 );			//L_CBUTTON
		break;
      	case SDLK_END:
      		b.Value =  b.Value |  ( 0x00000400 );			//D_CBUTTON
		break;
      	case SDLK_HOME:
      		b.Value =  b.Value |  ( 0x00000800 );			//U_CBUTTON
		break;
      	case SDLK_s:
      		b.Value =  b.Value |  ( 0x00001000 );			//R_TRIG
		break;
      	case SDLK_q:
      		b.Value =  b.Value |  ( 0x00002000 );			//L_TRIG
		break;

      	case SDLK_LSHIFT:
			shift_state = 1;
			update_analogic_state();
		break;
      	case SDLK_LCTRL:
			ctrl_state = 1;
			update_analogic_state();
		break;
      	case SDLK_UP:
			up_state = 1;
			update_analogic_state();
		break;
      	case SDLK_DOWN:
			down_state = 1;
			update_analogic_state();
		break;
      	case SDLK_RIGHT:
			right_state = 1;
			update_analogic_state();
		break;
      	case SDLK_LEFT:
			left_state = 1;
			update_analogic_state();
		break;
  
      }
 
}

/******************************************************************
  Function: WM_KeyUp
  Purpose:  To pass the WM_KEYUP message from the emulator to the 
            plugin.
  input:    wParam and lParam of the WM_KEYDOWN message.
  output:   none
*******************************************************************/ 
EXPORT void CALL WM_KeyUp( WPARAM wParam, LPARAM lParam )
{
 
 /*
		unsigned R_DPAD       : 1;
		    //1 = 0001  FFFE
		unsigned L_DPAD       : 1;
		    //2 = 0002  FFFD
		unsigned D_DPAD       : 1;
		    //3 = 0004  FFFB
		unsigned U_DPAD       : 1;
		    //4 = 0008  FFF7
		unsigned START_BUTTON : 1;
	//5 = 0010  FFEF
		unsigned Z_TRIG       : 1;
			//6 = 0020  FFDF
		unsigned B_BUTTON     : 1;
		//7 = 0040  FFBF
		unsigned A_BUTTON     : 1;
		//8 = 0080  FF7F

*/

 
 
 
    switch (lParam) // lParam = key symbol
     {

		case SDLK_KP6:
			b.Value =  b.Value &  ( 0xFFFFFFFE );				//R_DPAD
		break;
      	case SDLK_KP4:
      		b.Value =  b.Value &  ( 0xFFFFFFFD );				//L_DPAD
		break;
      	case SDLK_KP2:
       		b.Value =  b.Value &  ( 0xFFFFFFFB );				//D_DPAD
		break;
      	case SDLK_KP8:
      		b.Value =  b.Value &  ( 0xFFFFFFF7 );				//U_DPAD
		break;
     	case SDLK_RETURN:
			b.Value =  b.Value &  ( 0xFFFFFFEF );				//START_BUTTON
		break;
        case SDLK_SPACE:
        		b.Value =  b.Value &  ( 0xFFFFFFDF );				//Z_TRIG
		break;
      	case SDLK_x:
      		b.Value =  b.Value &  ( 0xFFFFFFBF );				//B_BUTTON
		break;
      	case SDLK_w:
      		b.Value =  b.Value &  ( 0xFFFFFF7F );				//A_BUTTON
		break;
 /*
		unsigned R_CBUTTON    : 1;
		//9 =   0100 FEFF
		unsigned L_CBUTTON    : 1;
		//10 = 0200 FDFF 
		unsigned D_CBUTTON    : 1;
		//11 = 0400 FBFF
		unsigned U_CBUTTON    : 1;
		//12 = 0800 F7FF
		unsigned R_TRIG       : 1;
			//13 = 1000 EFFF
		unsigned L_TRIG       : 1;
			//14 = 2000 DFFF
		unsigned Reserved1    : 1;
		//15 = 4000 BFFF
		unsigned Reserved2    : 1;
		//16 = 8000 7FFF
*/	
   
      	
      	    	
      case SDLK_PAGEDOWN:
      		b.Value =  b.Value &  ( 0xFFFFFEFF );				//R_CBUTTON
		break;
      	case SDLK_DELETE:
     		b.Value =  b.Value &  ( 0xFFFFFDFF );				//L_CBUTTON
		break;
      	case SDLK_END:
     		b.Value =  b.Value &  ( 0xFFFFFBFF );				//D_CBUTTON
		break;
      	case SDLK_HOME:
      		b.Value =  b.Value &  ( 0xFFFFF7FF );				//U_CBUTTON
		break;
      	case SDLK_s:
      		b.Value =  b.Value &  ( 0xFFFFEFFF );				//R_TRIG
		break;
      	case SDLK_q:
      		b.Value =  b.Value &  ( 0xFFFFDFFF );				//L_TRIG
		break;
 
        case SDLK_LSHIFT:
     		shift_state = 0;
			update_analogic_state();
		break;
   
        case SDLK_LCTRL:
			ctrl_state = 0;
			update_analogic_state();
		break;
      	case SDLK_UP:
			up_state = 0;
			update_analogic_state();
		break;
      	case SDLK_DOWN:
			down_state = 0;
			update_analogic_state();
		break;
      	case SDLK_RIGHT:
			right_state = 0;
			update_analogic_state();
		break;
      	case SDLK_LEFT:
			left_state = 0;
			update_analogic_state();
		break;
     
     }

}
