#include <GL/gl.h>

//////////////////////////////////////////////////////////////////////////////
// Diddy Kong															//
// Jet Force Gemini														//
//////////////////////////////////////////////////////////////////////////////

void rsp_uc06_matrix();
void rsp_uc06_movemem();
void rsp_uc06_vertex();
void rsp_uc06_displaylist();
void rsp_uc06_sprite2d();

void rsp_uc06_tri4();
void rsp_uc06_rdphalf_cont();
void rsp_uc06_rdphalf_2();
void rsp_uc06_rdphalf_1();
void rsp_uc06_line3d();
void rsp_uc06_cleargeometrymode();
void rsp_uc06_setgeometrymode();
void rsp_uc06_enddl();
void rsp_uc06_setothermode_l();
void rsp_uc06_setothermode_h();
void rsp_uc06_texture();
void rsp_uc06_moveword();
void rsp_uc06_popmatrix();
void rsp_uc06_culldl();
void rsp_uc06_tri1();
void rsp_uc06_dlinmem();


//////////////////////////////////////////////////////////////////////////////
// LoadVertex																//
//////////////////////////////////////////////////////////////////////////////
#define SIZE_VERTEX_UC06 10

//  0-15 = ????
// 16-17 = Matrix Selection ?
// 19-23 = Num Vertices + 1
void rsp_uc06_vertex()
{
	_u32	a = segoffset2addr(rdp_reg.cmd1);
	_u32    v0, i, len;
	_u8		matrix, n;

	v0 = 0;
	n = (_u8)((CMD0 >> 19) & 0x1F) + 1;

	matrix = (_u8)((CMD0 >> 15) & 0x3);

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_LOADVTX  vertex %i..%i m:%i\n",
				 ADDR, CMD0, CMD1,  v0, n-1, matrix);

	switch(matrix)
	{
		case 0:			
//			Render_load_projection(UC6_Matrices[1]);
			load_matrix((GLfloat *)&UC6_Matrices[1][0][0]);
			break;
		case 1:
//			Render_load_projection(UC6_Matrices[0]);
			load_matrix((GLfloat *)&UC6_Matrices[0][0][0]);
			break;
		case 2:
//			Render_load_projection(UC6_Matrices[2]);
			load_matrix((GLfloat *)&UC6_Matrices[2][0][0]);
			break;
		default:
			DebugBox("vertex matrix");
			break;
	}

	for(i = 0; i < n; i++)
	{
		_u32 ad = a + (i * SIZE_VERTEX_UC06);

		rdp_reg.vtx[v0].x     = (float)(_s16)doReadMemHalfWord(ad+0);
		rdp_reg.vtx[v0].y     = (float)(_s16)doReadMemHalfWord(ad+2);
		rdp_reg.vtx[v0].z     = (float)(_s16)doReadMemHalfWord(ad+4);
		rdp_reg.vtx[v0].s     = 1.0f; 
		rdp_reg.vtx[v0].t     = 1.0f; 
		rdp_reg.vtx[v0].r     = doReadMemByte(ad+5);
		rdp_reg.vtx[v0].g     = doReadMemByte(ad+6);
		rdp_reg.vtx[v0].b     = doReadMemByte(ad+7);
		rdp_reg.vtx[v0].a     = doReadMemByte(ad+8);

		LOG_TO_FILE("   vtx[%02i]: [xyz %04X %04X %04X] -> %12.5f %12.5f %12.5f [%02X,%02X,%02X,%02X]\n",
		      v0, 
			  doReadMemHalfWord(ad+0),
			  doReadMemHalfWord(ad+2),
			  doReadMemHalfWord(ad+4),
			  rdp_reg.vtx[v0].x, rdp_reg.vtx[v0].y, rdp_reg.vtx[v0].z,
			  rdp_reg.vtx[v0].r, rdp_reg.vtx[v0].g, rdp_reg.vtx[v0].b, rdp_reg.vtx[v0].a);

		v0++;
	}
}

#define SIZE_DMA_TRI 16
//  0-15 = Tribuffer Size
// 16-19 = ???? everytime 1 ???
// 20-23 = Num Tris - 2
void rsp_uc06_tri4()
{
	int vn[3], i;
	_u32 a = segoffset2addr(rdp_reg.cmd1);
	_u32 num = (CMD0 & 0xFFF0) / SIZE_DMA_TRI;

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_DMATRI num:%i at:%08X\n", ADDR, CMD0, CMD1, num, a);
	
	for (i=0; i<num; i++)
	{
		_u32 ad = a + (i * SIZE_DMA_TRI); 
		_s16 temp;

		vn[0] = doReadMemByte(ad+1);
		vn[1] = doReadMemByte(ad+2);
		vn[2] = doReadMemByte(ad+3);

// testing
/*
*/		rdp_reg.vtx[vn[0]].s = (float)((_s16)doReadMemHalfWord(ad+4));
		rdp_reg.vtx[vn[0]].t = (float)((_s16)doReadMemHalfWord(ad+6));
		rdp_reg.vtx[vn[1]].s = (float)((_s16)doReadMemHalfWord(ad+8));
		rdp_reg.vtx[vn[1]].t = (float)((_s16)doReadMemHalfWord(ad+10));
		rdp_reg.vtx[vn[2]].s = (float)((_s16)doReadMemHalfWord(ad+12));
		rdp_reg.vtx[vn[2]].t = (float)((_s16)doReadMemHalfWord(ad+14));/**/


		DrawVisualTriangle(vn);
		//Render_triangle(vn);
		LOG_TO_FILE("	(%i,%i,%i)\n", vn[0], vn[1], vn[2]);
	}

	LOG_TO_FILE("\n");
} // void rsp_uc06_tri4()


//seems to be okay
void rsp_uc06_texture()
{
        int tile = (rdp_reg.cmd0 >> 8)  & 0x07;				//** tile
		_u32 mipmap_level = (rdp_reg.cmd0 >> 11) & 0x07;	//** mipmap_level   - not used yet
		_u32 on = (rdp_reg.cmd0 & 0xff);			//** 1: on - 0:off

		float s = (float)((rdp_reg.cmd1 >> 16) & 0xffff);
		float t = (float)((rdp_reg.cmd1      ) & 0xffff);

		t_tile *tmp_tile = &rdp_reg.td[tile];
		tmp_tile->Texture_on = (_u8)on;

		tmp_tile->SScale=(float)s/65535.f;
		tmp_tile->TScale=(float)t/65535.f;

		tmp_tile->TScale/=32.f;
		tmp_tile->SScale/=32.f;

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_TEXTURE NC\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_popmatrix()
{
	pop_matrix();
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_POPMATRIX \n", ADDR, CMD0, CMD1);
}

void rsp_uc06_matrix()
{

        _u32   a = segoffset2addr(rdp_reg.cmd1);
        _u8   command =(_u8)((CMD0 >> 22) & 0x3);
        float   m[4][4]; 
        int     i, j;

		//hleGetMatrix((float*)m, (DWORD*)&pRDRAM[a]);
           a = a >> 1;  
 for(i=0;i<16;i+=4)
  {
   for(j=0;j<4;j++)
    {
     m[i>>2][j] = (float)
      ((((long)((unsigned short *)pRDRAM)[(a + i + j)^1]) << 16) |
       ((unsigned short *)pRDRAM)[(a + i + j + 16)^1]) / 65536.0f;
    }
  }


		LOG_TO_FILE("%08X: %08X %08X CMD UC6_LOADMTX  at %08X matrix:%i\n", ADDR, CMD0, CMD1, a, command);

//Render_load_modelview(m);
		memcpy(UC6_Matrices[command], m, sizeof(m));

        //
        LOG_TO_FILE(
				"Load matrix\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "\n",
                m[0][0], m[0][1], m[0][2], m[0][3],
                m[1][0], m[1][1], m[1][2], m[1][3],
                m[2][0], m[2][1], m[2][2], m[2][3],
                m[3][0], m[3][1], m[3][2], m[3][3]
                );
}

void rsp_uc06_displaylist()
{
        _u32 addr = segoffset2addr(CMD1);
        _u8  push = (_u8)(CMD0 >> 16) & 0xff; 

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_DISPLAYLIST \n", ADDR, CMD0, CMD1);

        switch(push)
        {
            case 0:   // push: we do a call of the dl 
                rdp_reg.pc_i++;
                if(rdp_reg.pc_i > 9)
                {
					DebugBox("DList Stack overflow");
					return;
                }
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            case 1:   // branch 
                rdp_reg.pc[rdp_reg.pc_i] = addr;	
                break;

            default:
                DebugBox("Unknow DList command");
                break;

        } // switch(push) 

}

void rsp_uc06_dlinmem()
{
        _u32 addr = CMD1, ta;
        _u8  push = (_u8)((CMD0 & 0xf0) >> 4); 
		_s8 limit = (_s8)(CMD0 >> 16) & 0xff;

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_DL_INMEM \n", ADDR, CMD0, CMD1);


		do
		{
			ta = addr >> 2;
			rdp_reg.cmd0 = ((_u32 *)pRDRAM)[ta + 0];
			rdp_reg.cmd1 = ((_u32 *)pRDRAM)[ta + 1];
			rdp_reg.cmd2 = ((_u32 *)pRDRAM)[ta + 3];
			rdp_reg.cmd3 = ((_u32 *)pRDRAM)[ta + 5];

			LOG_TO_FILE("  ");
			exec_gfx();

			limit--;
			addr += 8;
		} while(limit > 0);

		LOG_TO_FILE("UC6_DL_INMEM-ends \n\n");
}


void rsp_uc06_enddl()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_ENDDISPLAYLIST \n\n", ADDR, CMD0, CMD1);
	if(rdp_reg.pc_i < 0)
	{
		DebugBox("EndDL - Display Stack underrun");
		rdp_reg.halt = 1;
		return;
	}

	if(rdp_reg.pc_i == 0)
	{
		rdp_reg.halt = 1;
	}
	rdp_reg.pc_i--;
}



//////////////////////////////////////////////////////////////////////////////
// UCode 1 functions
//////////////////////////////////////////////////////////////////////////////



void rsp_uc06_setgeometrymode()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_SETGEOMETRYMODE NC\n", ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETGEOMETRYMODE ");
        PRINT_RDP_MNEMONIC(
                "+$%08lx:\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1 & 0x00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1 & 0x00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1 & 0x00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1 & 0x00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1 & 0x00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1 & 0x00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1 & 0x00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1 & 0x00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1 & 0x00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1 & 0x00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1 & 0x00100000) ? "        lod\n" : ""
                );
#endif
        rdp_reg.geometrymode |= rdp_reg.cmd1;

        if(rdp_reg.cmd1 & 0x00000002)
                rdp_reg.geometrymode_textures = 1;

//		Render_geometry_zbuffer(1);
        if(rdp_reg.cmd1 & 0x00000001)
                Render_geometry_zbuffer(1);
//		else
//                Render_geometry_zbuffer(0);

//		if (rdp_reg.geometrymode & 0x00003000) Render_geometry_cullfrontback(0);
        switch(rdp_reg.geometrymode & 0x00003000)
        {
            case 0x1000:
                Render_geometry_cullfront(1);
                break;
            case 0x2000:
                Render_geometry_cullback(1);
                break;
            case 0x3000:
                Render_geometry_cullfrontback(1);
                break;
            default:
//                Render_geometry_cullfrontback(0);
				break;
        } //** switch(rdp_reg.geometrymode & 0x00003000) 


		if((rdp_reg.cmd1 & 0x00020000) != 0)
				rdp_reg.useLights = 1;

}

void rsp_uc06_moveword()
{
        int i;

		LOG_TO_FILE("%08X: %08X %08X CMD UC6_MOVEMEM ", 
				ADDR, CMD0, CMD1);

        switch(rdp_reg.cmd0 & 0xff)
        {
            case 0x00:
                break;

            case 0x02:
                rdp_reg.lights = (rdp_reg.cmd1 - 0x80000000) / 32 - 1;
				//calculate_light_vectors();
                break;

            case 0x04:
				switch((rdp_reg.cmd0 >> 8) & 0xffff)
                {
                    case 0x0004:
                        rdp_reg.clip.nx = rdp_reg.cmd1;
                        break;

                    case 0x000c:
                        rdp_reg.clip.ny = rdp_reg.cmd1;
                        break;

                    case 0x0014:
                        rdp_reg.clip.px = rdp_reg.cmd1;
                        break;

                    case 0x001c:
                        rdp_reg.clip.py = rdp_reg.cmd1;
                        break;

                    default:
						break;
                } /* switch((rdp_reg.cmd0 >> 8) & 0xffff) */               
                break;

            case 0x06:
				{
				_u8 offset = (_u8)((CMD0 >> 10) & 0xf);
				LOG_TO_FILE("Segment[%i]=%08X", offset, CMD1);
                rdp_reg.segment[offset] = CMD1;
				}
                break;

            case 0x08:
                break;

            case 0x0a:
                i = (rdp_reg.cmd0 & 0x0000e000) >> 13;

                if(rdp_reg.cmd0 & 0x00000400)
                {
                        rdp_reg.light[i].r         = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g         = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b         = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a         = 1.0f;

                }
                else
                {
                        rdp_reg.light[i].r_copy    = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g_copy    = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b_copy    = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a_copy    = 1.0f;
                }

				//calculate_light_vectors();
                break;

            case 0x0c:
                break;

            case 0x0e:
                break;

            default:
				break;
        } /* switch(rdp_reg.cmd0 & 0xff) */
	LOG_TO_FILE("\n");
} /* static void rsp_uc06_moveword() */



void rsp_uc06_setothermode_l()
{
        static char *ac[] = { "none", "threshold", "?", "diter" };
        static char *zs[] = { "pixel", "prim" };
        static char *a1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)"
                };
        static char *b1[] =
                {
                        "        bl_clr_in (1)",
                        "        bl_clr_mem (1)",
                        "        bl_clr_bl (1)",
                        "        bl_clr_fog (1)"
                };
        static char *c1[] =
                {
                        "        bl_a_in (1)",
                        "        bl_a_fog (1)",
                        "        bl_a_shade (1)",
                        "        bl_0 (1)"
                };
        static char *d1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)" 
                };
        static char *a2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)"
                };
        static char *b2[] =
                {
                        "        bl_clr_in (2)",
                        "        bl_clr_mem (2)",
                        "        bl_clr_bl (2)",
                        "        bl_clr_fog (2)"
                };
        static char *c2[] =
                {
                        "        bl_a_in (2)",
                        "        bl_a_fog (2)",
                        "        bl_a_shade (2)",
                        "        bl_0 (2)"
                };
        static char *d2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)" 
                };

        switch((rdp_reg.cmd0 >> 8) & 0xff)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_L ALPHACOMPARE: ");
                //PRINT_RDP("%s\n", ac[(rdp_reg.cmd1>>0x00) & 0x3]);

                rdp_reg.mode_l &= ~0x00000003;
                rdp_reg.cmd1   &=  0x00000003;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x02:
                //PRINT_RDP("SETOTHERMODE_L ZSRCSEL: ");
                //PRINT_RDP("%s\n", zs[(rdp_reg.cmd1>>0x02) & 0x1]);

                rdp_reg.mode_l &= ~0x00000004;
                rdp_reg.cmd1   &=  0x00000004;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x03:
                //PRINT_RDP("SETOTHERMODE_L RENDERMODE: ");
                /*PRINT_RDP("$%08lx:\n", rdp_reg.cmd1 & 0xfffffff8,
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n",
                        rdp_reg.cmd1 & 0xfffffff8,
                        (rdp_reg.cmd1 & 0x00000008) ? "        anti alias\n" : "",
                        (rdp_reg.cmd1 & 0x00000010) ? "        z_cmp\n" : "",
                        (rdp_reg.cmd1 & 0x00000020) ? "        z_upd\n" : "",
                        (rdp_reg.cmd1 & 0x00000040) ? "        im_rd\n" : "",
                        (rdp_reg.cmd1 & 0x00000080) ? "        clr_on_cvg\n" : "",
                        (rdp_reg.cmd1 & 0x00000100) ? "        cvg_dst_warp\n" : "",
                        (rdp_reg.cmd1 & 0x00000200) ? "        cvg_dst_full\n" : "",
                        (rdp_reg.cmd1 & 0x00000400) ? "        z_inter\n" : "",
                        (rdp_reg.cmd1 & 0x00000800) ? "        z_xlu\n" : "",
                        (rdp_reg.cmd1 & 0x00001000) ? "        cvg_x_alpha\n" : "",
                        (rdp_reg.cmd1 & 0x00002000) ? "        alpha_cvg_sel\n" : "",
                        (rdp_reg.cmd1 & 0x00004000) ? "        force_bl\n" : "",
                        (rdp_reg.cmd1 & 0x00008000) ? "        tex_edge?\n" : "",
                        a2[(rdp_reg.cmd1>>16) & 0x3],
                        a1[(rdp_reg.cmd1>>18) & 0x3],
                        b2[(rdp_reg.cmd1>>20) & 0x3],
                        b1[(rdp_reg.cmd1>>22) & 0x3],
                        c2[(rdp_reg.cmd1>>24) & 0x3],
                        c1[(rdp_reg.cmd1>>26) & 0x3],
                        d2[(rdp_reg.cmd1>>28) & 0x3],
                        d1[(rdp_reg.cmd1>>30) & 0x3]
                        );*/
                rdp_reg.mode_l &= ~0xfffffff8;
                rdp_reg.cmd1   &=  0xfffffff8;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_L BLENDER\n");
				break;

            default:
                //PRINT_RDP("SETOTHERMODE_L ?\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_SETOTHERMODE_L NC\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_setothermode_h()
{
        static char *ad[] = { "pattern", "notpattern", "noise", "disable" };
        static char *rd[] = { "magicsq", "bayer", "noise", "?" };
        static char *ck[] = { "none", "key" };
        static char *tc[] = { "conv", "?", "?", "?", "?", "filtconv", "filt", "?" };
        static char *tf[] = { "point", "?", "bilerp", "average" };
        static char *tt[] = { "none", "?", "rgba16", "ia16" };
        static char *tl[] = { "tile", "lod" };
        static char *td[] = { "clamp", "sharpen", "detail", "?" };
        static char *tp[] = { "none", "persp" };
        static char *ct[] = { "1cycle", "2cycle", "copy", "fill" };
        static char *cd[] = { "disable(hw>1)", "enable(hw>1)", "disable(hw1)", "enable(hw1)" };
        static char *pm[] = { "nprimitive", "1primitive" };

        switch((rdp_reg.cmd0 >> 8) & 0xff)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_H BLENDMASK - ignored\n");
                break;

            case 0x04:
                //PRINT_RDP("SETOTHERMODE_H ALPHADITHER: ");
                //PRINT_RDP("%s\n", ad[(rdp_reg.cmd1>>0x04) & 0x3]);
                rdp_reg.mode_h &= ~0x00000030;
                rdp_reg.cmd1   &=  0x00000030;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x06:
                //PRINT_RDP("SETOTHERMODE_H RGBDITHER: ");
                //PRINT_RDP("%s\n", rd[(rdp_reg.cmd1>>0x06) & 0x3]);
                rdp_reg.mode_h &= ~0x000000c0;
                rdp_reg.cmd1   &=  0x000000c0;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x08:
                //PRINT_RDP("SETOTHERMODE_H COMBINEKEY: ");
                //PRINT_RDP("%s\n", ck[(rdp_reg.cmd1>>0x08) & 0x1]);
                rdp_reg.mode_h &= ~0x00000100;
                rdp_reg.cmd1   &=  0x00000100;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x09:
                //PRINT_RDP("SETOTHERMODE_H TEXTURECONVERT: ");
                //PRINT_RDP("%s\n", tc[(rdp_reg.cmd1>>0x09) & 0x7]);
                rdp_reg.mode_h &= ~0x00000e00;
                rdp_reg.cmd1   &=  0x00000e00;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0c:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREFILTER: ");
                //PRINT_RDP("%s\n", tf[(rdp_reg.cmd1>>0x0c) & 0x3]);
                rdp_reg.mode_h &= ~0x00003000;
                rdp_reg.cmd1   &=  0x00003000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0e:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELUT: ");
                //PRINT_RDP("%s\n", tt[(rdp_reg.cmd1>>0x0e) & 0x3]);
                rdp_reg.mode_h &= ~0x0000c000;
                rdp_reg.cmd1   &=  0x0000c000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x10:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELOD: ");
                //PRINT_RDP("%s\n", tl[(rdp_reg.cmd1>>0x10) & 0x1]);
                rdp_reg.mode_h &= ~0x00010000;
                rdp_reg.cmd1   &=  0x00010000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x11:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREDETAIL: ");
                //PRINT_RDP("%s\n", td[(rdp_reg.cmd1>>0x11) & 0x3]);
                rdp_reg.mode_h &= ~0x00060000;
                rdp_reg.cmd1   &=  0x00060000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x13:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREPERSP: ");
                //PRINT_RDP("%s\n", tp[(rdp_reg.cmd1>>0x13) & 0x1]);
                rdp_reg.mode_h &= ~0x00080000;
                rdp_reg.cmd1   &=  0x00080000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x14:
                //PRINT_RDP("SETOTHERMODE_H CYCLETYPE: ");
                //PRINT_RDP("%s\n", ct[(rdp_reg.cmd1>>0x14) & 0x3]);
                rdp_reg.mode_h &= ~0x00300000;
                rdp_reg.cmd1   &=  0x00300000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_H COLORDITHER: ");
                //PRINT_RDP("%s\n", cd[(rdp_reg.cmd1>>0x16) & 0x1]);
                rdp_reg.mode_h &= ~0x00400000;
                rdp_reg.cmd1   &=  0x00400000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x17:
                //PRINT_RDP("SETOTHERMODE_H PIPELINEMODE: ");
                //PRINT_RDP("%s\n", pm[(rdp_reg.cmd1>>0x17) & 0x1]);
                rdp_reg.mode_h &= ~0x00800000;
                rdp_reg.cmd1   &=  0x00800000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            default:
                //PRINT_RDP("SETOTHERMODE_H\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_SETOTHERMODE_H NC\n", ADDR, CMD0, CMD1);

}












void rsp_uc06_movemem()
{

        _u32 a;
        int   i;

	LOG_TO_FILE("%08X: %08X %08X CMD UC6_MOVEMEM NC \n", ADDR, CMD0, CMD1);
        switch((rdp_reg.cmd0 >> 16) & 0xff)
        {
            case 0x80:
                a = segoffset2addr(rdp_reg.cmd1) >> 1;

                rdp_reg.vp[0] = ((float)((_s16 *)pRDRAM)[(a+0)^1]) / 4.0f;
                rdp_reg.vp[1] = ((float)((_s16 *)pRDRAM)[(a+1)^1]) / 4.0f;
                rdp_reg.vp[2] = ((float)((_s16 *)pRDRAM)[(a+2)^1]) / 4.0f;
                rdp_reg.vp[3] = ((float)((_s16 *)pRDRAM)[(a+3)^1]) / 4.0f;
                rdp_reg.vp[4] = ((float)((_s16 *)pRDRAM)[(a+4)^1]) / 4.0f;
                rdp_reg.vp[5] = ((float)((_s16 *)pRDRAM)[(a+5)^1]) / 4.0f;
                rdp_reg.vp[6] = ((float)((_s16 *)pRDRAM)[(a+6)^1]) / 4.0f;
                rdp_reg.vp[7] = ((float)((_s16 *)pRDRAM)[(a+7)^1]) / 4.0f;
                Render_viewport();
                break;

            case 0x82:
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.lookat_y.r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.lookat_y.g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.lookat_y.b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.lookat_y.a         = 1.0f;
                rdp_reg.lookat_y.r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.lookat_y.g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.lookat_y.b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.lookat_y.a_copy    = 1.0f;
                rdp_reg.lookat_y.x         = ((float)((_u8 *)pRDRAM)[(a+ 8)^3])/255.0f;
                rdp_reg.lookat_y.y         = ((float)((_u8 *)pRDRAM)[(a+ 9)^3])/255.0f;
                rdp_reg.lookat_y.z         = ((float)((_u8 *)pRDRAM)[(a+10)^3])/255.0f;
                rdp_reg.lookat_y.w         = 1.0f;

                Render_lookat_y();
                break;

            case 0x84:
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.lookat_x.r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.lookat_x.g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.lookat_x.b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.lookat_x.a         = 1.0f;
                rdp_reg.lookat_x.r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.lookat_x.g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.lookat_x.b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.lookat_x.a_copy    = 1.0f;
                rdp_reg.lookat_x.x         = ((float)((_s8 *)pRDRAM)[(a+ 8)^3])/128.0f;
                rdp_reg.lookat_x.y         = ((float)((_s8 *)pRDRAM)[(a+ 9)^3])/128.0f;
                rdp_reg.lookat_x.z         = ((float)((_s8 *)pRDRAM)[(a+10)^3])/128.0f;
                rdp_reg.lookat_x.w         = 1.0f;

                Render_lookat_x();
                break;

            case 0x86:
            case 0x88:
            case 0x8a:
            case 0x8c:
            case 0x8e:
            case 0x90:
            case 0x92:
            case 0x94:
                i = (((rdp_reg.cmd0 >> 16) & 0xff) - 0x86) >> 1;
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.light[i].r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.light[i].g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.light[i].b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.light[i].a         = 1.0f;
                rdp_reg.light[i].r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.light[i].g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.light[i].b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.light[i].a_copy    = 1.0f;
                rdp_reg.light[i].x         = ((float)((_s8 *)pRDRAM)[(a+ 8)^3])/127.0f;
                rdp_reg.light[i].y         = ((float)((_s8 *)pRDRAM)[(a+ 9)^3])/127.0f;
                rdp_reg.light[i].z         = ((float)((_s8 *)pRDRAM)[(a+10)^3])/127.0f;
                rdp_reg.light[i].w         = 1.0f;

                Render_light(i);
                break;

            case 0x98:
                break;

            case 0x9a:
                break;

            case 0x9c:
                break;

            case 0x9e:
                break;

            default:
				break;

        } // switch((rdp_reg.cmd0 >> 8) & 0xffff) 

} // static void rsp_uc06_movemem() 

void rsp_uc06_cleargeometrymode()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_CLEARGEOMETRYMODE\n", ADDR, CMD0, CMD1);

        rdp_reg.geometrymode &= ~rdp_reg.cmd1;

//        if(rdp_reg.cmd1 & 0x00000002)
//                rdp_reg.geometrymode_textures = 0;

		if ((rdp_reg.cmd1 & 0x00020000) != 0)
				rdp_reg.useLights = 0;

        if(rdp_reg.cmd1 & 0x00000001)
                Render_geometry_zbuffer(0);


//		if (rdp_reg.geometrymode & 0x00003000) Render_geometry_cullfrontback(0);
        switch(rdp_reg.geometrymode & 0x00003000)
        {
            case 0x1000:
                Render_geometry_cullfront(0);
                break;
            case 0x2000:
                Render_geometry_cullback(0);
                break;
            case 0x3000:
                Render_geometry_cullfrontback(0);
                break;
            default:
//                Render_geometry_cullfrontback(0);
				break;
        } //** switch(rdp_reg.geometrymode & 0x00003000) 
		
} /* static void rsp_uc00_cleargeometrymode() */




//////////////////////////////////////////////////////////////////////////////
// Unimplemented functions
//////////////////////////////////////////////////////////////////////////////


void rsp_uc06_rdphalf_cont()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_RDPHALF_CONT NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_rdphalf_2()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_RDPHALF_2 NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_line3d()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_LINE3d NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_sprite2d()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_SPRITE2D NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_culldl()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_CULLDL NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_tri1()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_TRI1 NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc06_rdphalf_1()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC6_RDPHALF_1 DATA\n", ADDR, CMD0, CMD1);
}


