#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include <GL/gl.h>
#include <GL/glu.h>

#include "rdp_registers.h"
#include "rdp_gl.h"
#include "Combine.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "3dmath.h"
#include "lighting.h"
#include "Texture.h"
//** Globals
extern char output[1024];
//#define OPENGL_LIGHTS

//** display list defines for 2d stuff 
#define kListEnd2D          1
#define kListEndLights      1
#define kListBeginLights	9
#define kListBegin2D160   160
#define kListBegin2D320   320
#define kListBegin2D640   640
#define kListBegin2D800   800
#define kListBegin2D960   960
#define kListBegin2D1024 1024
#define kListBegin2D1200 1200

//** for Lighting
extern BOOL refresh_lights;// = TRUE;
extern BOOL refresh_matrix;// = TRUE;
extern MATRIX4 view_matrix, invers;
extern VECTOR Light_Vector[8];




//** all Functions
extern void MathTextureScales();

int	Vtidx[256];
int Vtcnt = 0;

void MDrawVisualTriangle (int vn[3], int t1, int s1, int ss1);

/******************************************************************************\
*                                                                              *
*   3d RenderStuff for RDP (OPENGL - helper routines)  						   *
*                                                                              *
\******************************************************************************/
extern unsigned long FrameCounter ;
extern _u8 cycle_mode;

static GLint idx[3] = {0,1,2};

static float ClrArry[16*256];
static float VtxArry[16*256];
static float TexArry[16*256];
static float NrmArry[16*256];

int ArrayOk = 0;

void InitArrays(void)
{
	glVertexPointer(3,GL_FLOAT,0,VtxArry);
	glColorPointer(4,GL_FLOAT,0,ClrArry);
	glNormalPointer(GL_FLOAT,0,NrmArry);
	glTexCoordPointer(2,GL_FLOAT,0,TexArry);

	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_NORMAL_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	ArrayOk = 1;
}

void MDrawVisualTriangle(int vn[3], int t1, int s1, int s2)
{
	float color[4] = {1.0f,1.0f,1.0f,1.0f};

	int i;
//** Lighting		

	if (ArrayOk == 0) InitArrays();

	if ((rdp_reg.geometrymode & 0x00020000) != 0)
	{
#ifndef OPENGL_LIGHTS
		if (refresh_matrix)
		{
			MATRIX4 tmp_mtx;
			get_matrix(tmp_mtx);
			//glGetFloatv(GL_MODELVIEW_MATRIX, tmp_mtx);
			if (!compare_matrix4(view_matrix, tmp_mtx))
			{
				memcpy(view_matrix, tmp_mtx, sizeof(MATRIX4));
				m3_inverse( invers, view_matrix);				
				calculate_light_vectors();
			}
			refresh_matrix = FALSE;
		}
#endif
		if (refresh_lights) calculate_light_vectors();
	}

//** Lighting - end
#ifdef OPENGL_LIGHTS
	//(rdp_reg.useLights != 0)
	if (((s1 & UseShade) != 0) && ((rdp_reg.geometrymode & 0x00020000) != 0)) 
	{
		glEnable(GL_LIGHTING);
	}
	else
	{
		glDisable(GL_LIGHTING);
	}
#endif

	if ((t1 & 1) == 1)
	{
		SetActiveTexture();
		glEnable(GL_TEXTURE_2D);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	}
	else 
	{
		glDisable(GL_TEXTURE_2D);
//		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	}
	for(i=0; i<Vtcnt; i++)
	{
		t_vtx *vertex = &rdp_reg.vtx[vn[i]];

		color[0] = 1.0f;
		color[1] = 1.0f;
		color[2] = 1.0f;
		color[3] = 1.0f;

		if ((s1 & UsePrim) != 0)
		{
			color[0] *= (((rdp_reg.primcolor >> 24) & 0xff) / 255.0f);
			color[1] *= (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
			color[2] *= (((rdp_reg.primcolor >>  8) & 0xff) / 255.0f);
		}

		if ((s1 & UsePrimAsAlpha) != 0)
		{
			color[4] *= (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
		}

		if ((s1 & UseEnvAsAlpha) != 0)
		{
			color[4] *= (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
		}

		if ((s1 & UseEnv) != 0)
		{
			color[0] *= (((rdp_reg.envcolor >> 24) & 0xff) / 255.0f);
			color[1] *= (((rdp_reg.envcolor >> 16) & 0xff) / 255.0f);
			color[2] *= (((rdp_reg.envcolor >>  8) & 0xff) / 255.0f);
		}

		if ((s1 & UseShade) != 0)
		{
			if ((rdp_reg.geometrymode & 0x00020000) == 0) 
			{
				color[0] *= ((vertex->r) / 255.0f);
				color[1] *= ((vertex->g) / 255.0f);
				color[2] *= ((vertex->b) / 255.0f);
			}
			else
			{ 
				float lcolor[4] = {0,0,0,0};
#ifndef OPENGL_LIGHTS
				math_lighting((t_vtx_tn*)(char*)vertex, lcolor);
				color[0] *= lcolor[0];
				color[1] *= lcolor[1];
				color[2] *= lcolor[2];
				color[3] *= lcolor[3];
#else
				NrmArry[i*3+0] = (((sBYTE)vertex->r) / 127.0f);
				NrmArry[i*3+1] = (((sBYTE)vertex->g) / 127.0f);
				NrmArry[i*3+2] = (((sBYTE)vertex->b) / 127.0f);
//				NormalizeVector(NrmArry);
#endif
			}
		}

		if ((s1 & UseShadeEnvFade) != 0)
		{
			float fadeColor[3];

			fadeColor[0] = (((rdp_reg.envcolor >> 24) & 0xff) / 255.0f);
			fadeColor[1] = (((rdp_reg.envcolor >> 16) & 0xff) / 255.0f);
			fadeColor[2] = (((rdp_reg.envcolor >>  8) & 0xff) / 255.0f);

			fadeColor[0] -= ((vertex->r) / 255.0f);
			fadeColor[1] -= ((vertex->g) / 255.0f);
			fadeColor[2] -= ((vertex->b) / 255.0f);

			fadeColor[0] *= (((rdp_reg.envcolor >> 24) & 0xff) / 255.0f);
			fadeColor[1] *= (((rdp_reg.envcolor >> 16) & 0xff) / 255.0f);
			fadeColor[2] *= (((rdp_reg.envcolor >>  8) & 0xff) / 255.0f);

			fadeColor[0] += ((vertex->r) / 255.0f);
			fadeColor[1] += ((vertex->g) / 255.0f);
			fadeColor[2] += ((vertex->b) / 255.0f);

			color[0] *= fadeColor[0];
			color[1] *= fadeColor[1];
			color[2] *= fadeColor[2];
		}


		if ((s1 & UseShadePrimFade) != 0)
		{
			float fadeColor[3];

			fadeColor[0] = (((rdp_reg.primcolor >> 24) & 0xff) / 255.0f);
			fadeColor[1] = (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
			fadeColor[2] = (((rdp_reg.primcolor >>  8) & 0xff) / 255.0f);

			fadeColor[0] -= ((vertex->r) / 255.0f);
			fadeColor[1] -= ((vertex->g) / 255.0f);
			fadeColor[2] -= ((vertex->b) / 255.0f);

			fadeColor[0] *= (((rdp_reg.primcolor >> 24) & 0xff) / 255.0f);
			fadeColor[1] *= (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
			fadeColor[2] *= (((rdp_reg.primcolor >>  8) & 0xff) / 255.0f);

			fadeColor[0] += ((vertex->r) / 255.0f);
			fadeColor[1] += ((vertex->g) / 255.0f);
			fadeColor[2] += ((vertex->b) / 255.0f);

			color[0] *= fadeColor[0];
			color[1] *= fadeColor[1];
			color[2] *= fadeColor[2];
		}

		if ((s1 & UsePrimAlpha) != 0)
		{
			color[3] *= ((rdp_reg.primcolor & 0xff) / 255.0f);
		}

		if ((s1 & UseEnvAlpha) != 0)
		{
			color[3] *= ((rdp_reg.envcolor & 0xff) / 255.0f);
		}

		if (((s1 & UseShadeAlpha) != 0) && (rdp_reg.useLights == 0))
		{
			color[3] *= ((vertex->a) / 255.0f);
		}

		ClrArry[i*4+0] = color[0];
		ClrArry[i*4+1] = color[1];
		ClrArry[i*4+2] = color[2];
		ClrArry[i*4+3] = color[3];

		transform_vector(&VtxArry[i*3],vertex->x,vertex->y,vertex->z);
/*		VtxArry[i*3+0] = vertex->x;
		VtxArry[i*3+1] = vertex->y;
		VtxArry[i*3+2] = vertex->z;
*/
		TexArry[i*2+0] = vertex->s * rdp_reg.texture[rdp_reg.tile].scale_s;
		TexArry[i*2+1] = vertex->t * rdp_reg.texture[rdp_reg.tile].scale_t;

	}

	glDrawArrays(GL_TRIANGLES,0,Vtcnt);
	if ((t1 & 2) == 2)
	{
		color[0] = 1.0f;
		color[1] = 1.0f;
		color[2] = 1.0f;
		color[3] = 1.0f;

#ifdef OPENGL_LIGHTS
		if (((s1 & UseShade) != 0) && ((rdp_reg.geometrymode & 0x00020000) != 0)) //(rdp_reg.useLights != 0)
		{
//			glEnableClientState(GL_NORMAL_ARRAY);
			glEnable(GL_LIGHTING);
		}
		else
		{
//			glDisableClientState(GL_NORMAL_ARRAY);
			glDisable(GL_LIGHTING);
		}
#endif

		SetActiveTexture();
		glEnable(GL_TEXTURE_2D);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);
		for(i=0; i<Vtcnt; i++)
		{
			t_vtx *vertex = &rdp_reg.vtx[vn[i]];

			if ((s2 & UsePrim) != 0)
			{
				color[0] *= (((rdp_reg.primcolor >> 24) & 0xff) / 255.0f);
				color[1] *= (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
				color[2] *= (((rdp_reg.primcolor >>  8) & 0xff) / 255.0f);
			}

			if ((s2 & UseEnv) != 0)
			{
				color[0] *= (((rdp_reg.envcolor >> 24) & 0xff) / 255.0f);
				color[1] *= (((rdp_reg.envcolor >> 16) & 0xff) / 255.0f);
				color[2] *= (((rdp_reg.envcolor >>  8) & 0xff) / 255.0f);
			}

			if ((s2 & UseShade) != 0)
			{
				if ((rdp_reg.geometrymode & 0x00020000) == 0) 
				{
					color[0] *= ((vertex->r) / 255.0f);
					color[1] *= ((vertex->g) / 255.0f);
					color[2] *= ((vertex->b) / 255.0f);
				}
				else
				{ 
					float lcolor[4] = {0,0,0,0};
#ifndef OPENGL_LIGHTS
					math_lighting((t_vtx_tn*)(char*)vertex, lcolor);
					color[0] *= lcolor[0];
					color[1] *= lcolor[1];
					color[2] *= lcolor[2];
					color[3] *= lcolor[3];
#else
					NrmArry[i*3+0] = (((sBYTE)vertex->r) / 127.0f);
					NrmArry[i*3+1] = (((sBYTE)vertex->g) / 127.0f);
					NrmArry[i*3+2] = (((sBYTE)vertex->b) / 127.0f);
#endif
				}
			}

			if ((s2 & UsePrimAlpha) != 0)
			{
				color[3] *= ((rdp_reg.primcolor & 0xff) / 255.0f);
			}

			if ((s2 & UseEnvAlpha) != 0)
			{
				color[3] *= ((rdp_reg.envcolor & 0xff) / 255.0f);
			}

			if (((s2 & UseShadeAlpha) != 0) && (rdp_reg.useLights == 0))
			{
				color[3] *= ((vertex->a) / 255.0f);
			}

//			if ((rdp_reg.mode_l & 0x00000003) == 0) color[3] = 1.0f;

			ClrArry[i*4+0] = color[0];
			ClrArry[i*4+1] = color[1];
			ClrArry[i*4+2] = color[2];
			ClrArry[i*4+3] = color[3];

/*			VtxArry[i*3+0] = vertex->x;
			VtxArry[i*3+1] = vertex->y;
			VtxArry[i*3+2] = vertex->z;
*/
			TexArry[i*2+0] = vertex->s * rdp_reg.texture[rdp_reg.tile].scale_s;
			TexArry[i*2+1] = vertex->t * rdp_reg.texture[rdp_reg.tile].scale_t;

		}
		glDrawArrays(GL_TRIANGLES,0,Vtcnt);

	}
}
// new june 16, will clean up code later.
extern void MathTextureScales();
extern HWND hGraphics;
extern int triUseprim; // new june 14
void DrawTexRectangleT(float u1, float u2, float v1, float v2, int tile,
					   int xh, int xl, int yh, int yl)
{
	glCallList(rdp_reg.colorimg_width);

	SetActiveTexture();
	glColor3f(1,1,1);		//are in modulate-mode...
	glEnable(GL_TEXTURE_2D);

	glBegin(GL_QUADS);
		glTexCoord2f(u2,  v1); glVertex2f((float)xl, (float)yl);
		glTexCoord2f(u1,  v1); glVertex2f((float)xh, (float)yl);
		glTexCoord2f(u1,  v2); glVertex2f((float)xh, (float)yh);
		glTexCoord2f(u2,  v2); glVertex2f((float)xl, (float)yh);
	glEnd();

	glCallList(kListEnd2D);
}

void DrawTexRectangle(float xh, float yh, 
					  float xl, float yl,
					  int tile,
					  float s, float t, 
					  float dsdx, float dtdy)
{
/*	int depth_test, w, h;
	float sw,sh;
	t_tile *tmpTile = &rdp_reg.td[tile];

//	sw = tmpTile->Width;
//	sh = tmpTile->Height;
	s *= rdp_reg.texture[tile].scale_s;
	t *= rdp_reg.texture[tile].scale_t;

//** Set to 2d ...
	glCallList(rdp_reg.colorimg_width);

	SetActiveTexture();
	glColor3f(1,1,1);		//are in modulate-mode...
	glEnable(GL_TEXTURE_2D);

	glBegin(GL_QUADS);

		glTexCoord2f(1, 1); glVertex2f(xl, yl);
		glTexCoord2f(s, 1); glVertex2f(xh, yl);
		glTexCoord2f(s, t); glVertex2f(xh, yh);
		glTexCoord2f(1, t); glVertex2f(xl, yh);

/*		glTexCoord2f(dsdx*(s/w + sw/w), dtdy*(t/h + sh/h)); glVertex2f(xl, yl);
		glTexCoord2f(dsdx*(s/w +    0), dtdy*(t/h + sh/h)); glVertex2f(xh, yl);
		glTexCoord2f(dsdx*(s/w +    0), dtdy*(t/h +    0)); glVertex2f(xh, yh);
		glTexCoord2f(dsdx*(s/w + sw/w), dtdy*(t/h +    0)); glVertex2f(xl, yh);

	glEnd();
//**
	glCallList(kListEnd2D);
*/
	t_tile *tmpTile = &rdp_reg.td[tile];
	float s0, t0, s1, t1;

//	MathSize(tile_num);
	s0 = s / tmpTile->Width;
	t0 = t / tmpTile->Height;
	s1 = (s + tmpTile->Width  * dsdx) / tmpTile->Width;
	t1 = (t + tmpTile->Height * dtdy) / tmpTile->Height;

//** Set to 2d ...
	SetActiveTexture();

	glEnable(GL_TEXTURE_2D);

	glCallList(rdp_reg.colorimg_width);
	glColor3f(1,1,1);		//are in modulate-mode...

	glBegin(GL_QUADS);
		glTexCoord2f(s1, t1); glVertex2f(xl, yl);
		glTexCoord2f(s0, t1); glVertex2f(xh, yl);
		glTexCoord2f(s0, t0); glVertex2f(xh, yh);
		glTexCoord2f(s1, t0); glVertex2f(xl, yh);
	glEnd();
//**
//	glCallList(kListEnd2D);


}

void SetVisualClipRectangle(_u32 ulx, _u32 uly, _u32 lrx, _u32 lry)
{
   _u32 width = lrx - ulx;
   _u32 height = lry - uly;
   _u32 tuly = 240 - lry;

   glScissor(ulx * 2,tuly * 2 ,width * 2,height * 2);
   glEnable(GL_SCISSOR_TEST);

}

void SetVisualRenderBuffer(void)
{

}
static _u32 CurVisualColor;

void SetVisualColor(_u32 Color)
{
	CurVisualColor = Color;
}

