/**
 * Mupen64 - cop1_s.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "ops.h"
#include "macros.h"
#include <math.h>

void DIV_S()
{  
   if (!*reg_cop1_simple[cfft])
     printf("div_s\n");
   *reg_cop1_simple[cffd] = *reg_cop1_simple[cffs] /
     *reg_cop1_simple[cfft];
   PC++;
}

void MUL_S()
{
   *reg_cop1_simple[cffd] = *reg_cop1_simple[cffs] *
     *reg_cop1_simple[cfft];
   PC++;
}

void ADD_S()
{
   *reg_cop1_simple[cffd] = *reg_cop1_simple[cffs] +
     *reg_cop1_simple[cfft];
   PC++;
}

void SUB_S()
{
   *reg_cop1_simple[cffd] = *reg_cop1_simple[cffs] -
     *reg_cop1_simple[cfft];
   PC++;
}

void NEG_S()
{
   *reg_cop1_simple[cffd] = -(*reg_cop1_simple[cffs]);
   PC++;
}

void SQRT_S()
{
   *reg_cop1_simple[cffd] = sqrt(*reg_cop1_simple[cffs]);
   PC++;
}

void CVT_D_S()
{
   double d;
   d = *reg_cop1_simple[cffs];
   *reg_cop1_double[cffd] = d;
   PC++;
}

void MOV_S()
{
   *reg_cop1_simple[cffd] = *reg_cop1_simple[cffs];
   PC++;
}

void ABS_S()
{
   *reg_cop1_simple[cffd] = fabs(*reg_cop1_simple[cffs]);
   PC++;
}

void TRUNC_W_S()
{
   if (Status & 0x04000000)
     {
	printf("TRUNC_W_S 64 bits\n");
	stop=1;
     }
   else
     reg_cop1_fgr_32[cffd] = *reg_cop1_simple[cffs];
   PC++;
}

void CVT_W_S()
{
   if (Status & 0x04000000)
     {
	printf("CVT_W_S 64 bits\n");
	stop=1;
     }
   else
     reg_cop1_fgr_32[cffd] = *reg_cop1_simple[cffs];
   PC++;
}

void C_LE_S()
{
   if (*reg_cop1_simple[cffs] <= *reg_cop1_simple[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}

void C_LT_S()
{
   if (*reg_cop1_simple[cffs] < *reg_cop1_simple[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}

void C_EQ_S()
{
   if (*reg_cop1_simple[cffs] == *reg_cop1_simple[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}
