/**
 * Mupen64 - interupt.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include <SDL/SDL.h>

#include "interupt.h"
#include "../memory/memory.h"
#include "r4300.h"
#include "macros.h"
#include "exception.h"
#include "../main/winlnxdefs.h"
#include "../main/plugin.h"


int pending;

void sp_interupt()
{
   if(!(MI_register.mi_intr_mask_reg & 0x01))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;
   
   exception_general();
}

void pi_interupt()
{  
   if(!(MI_register.mi_intr_mask_reg & 0x10))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;

   exception_general();
}

void ai_interupt()
{
   if(!(MI_register.mi_intr_mask_reg & 0x04))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;
   
   exception_general();
}

void si_interupt()
{
   si_register.si_status = 0x1000;
   
   if(!(MI_register.mi_intr_mask_reg & 0x02))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;

   exception_general();
}

void dp_interupt()
{
   if(!(MI_register.mi_intr_mask_reg & 0x20))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;

   exception_general();
}

void vi_interupt()
{
   //flush_display();
   updateScreen();
   SDL_PumpEvents();
   
   if(!(MI_register.mi_intr_mask_reg & 0x08))
     return;
   
   Cause |= 0x400;
   
   if ((Status & 0x401) != 0x401) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;

   exception_general();
   return;
}

void mi_interupt()
{
   if(MI_register.mi_intr_reg & 0x01)
     {
	sp_interupt();
	return;
     }
   if(MI_register.mi_intr_reg & 0x02)
     {
	si_interupt();
	return;
     }
   if(MI_register.mi_intr_reg & 0x04)
     {
	ai_interupt();
	return;
     }
   if(MI_register.mi_intr_reg & 0x08)
     {
	vi_interupt();
	return;
     }
   if(MI_register.mi_intr_reg & 0x10)
     {
	pi_interupt();
	return;
     }
   if(MI_register.mi_intr_reg & 0x20)
     {
	dp_interupt();
	return;
     }
   if(!MI_register.mi_intr_reg) return;
   printf("interuption MI inconnue\n");
   printf("%x\n", (unsigned int)MI_register.mi_intr_reg & (~0x10));
   stop=1;
}

void interupt()
{
   if(Status & Cause & 0xFF00)
     {
	if(Status & 1)
	  {
	     if (!(Status & 6))
	       {
		  pending=1;
		  
		  exception_general();
	       }
	  }
     }
}

int interupt_type, save_interupt_type;
unsigned long save_next_interupt, save_next_interupt2;

void gen_vi()
{
   if (!interupt_type)
     {
	//flush_display();
	updateScreen();
	SDL_PumpEvents();
	MI_register.mi_intr_reg |= 0x08;
	mi_interupt();
	next_interupt += 625000;
	if ((unsigned long)Compare > (unsigned long)Count)
	  {
	     if ((unsigned long)Compare < next_interupt)
	       {
		  interupt_type=1;
		  save_next_interupt = next_interupt;
		  next_interupt = (unsigned long)Compare-1;
	       }
	  }
     }
   else
     {
	if (interupt_type == 1)
	  {
	     compare_interupt();
	     if (save_next_interupt < (unsigned long)(Count))
	       printf("next interupt 1 already happenened\n");
	     next_interupt = save_next_interupt;
	     interupt_type=0;
	  }
	else
	  {
	     mi_interupt();
	     next_interupt = save_next_interupt2;
	     interupt_type= save_interupt_type;
	  }
     }
}

void gen_mi()
{
   if (interupt_type == 2) return;
   save_interupt_type = interupt_type;
   save_next_interupt2 = next_interupt;
   interupt_type = 2;
   next_interupt = Count;
}

void gen_dp()
{
   if ((Count + 0x200) > next_interupt) printf("aie\n");
   save_interupt_type = interupt_type;
   save_next_interupt2 = next_interupt;
   interupt_type = 2;
   next_interupt = Count + 0x1000;
}

void compare_interupt()
{
   Cause |= 0x8000;
   
   if ((Status & 0x8001) != 0x8001) return;
   if (Status & 0x6) return;
   
   Cause &= 0xFFFFFF83;
   
   exception_general();
}
