//#define DEBUGCC
#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include <GL/gl.h>
#include <GL/glu.h>

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Combine.h"
#include "rdp_registers.h"
#include "Texture.h"
#include "rdp.h"
#include "debug.h"

//* externals
extern void MDrawVisualTriangle(int vn[3], int t1, int s1, int ss1);
HWND hGraphics;

//** globals
_u8 uc0_a0,  uc0_b0,  uc0_c0,  uc0_d0, 
	  uc0_Aa0, uc0_Ab0, uc0_Ac0, uc0_Ad0,
      uc0_a1,  uc0_b1,  uc0_c1,  uc0_d1, 
	  uc0_Aa1, uc0_Ab1, uc0_Ac1, uc0_Ad1;

_u8 cycle_mode;
_u32 cycle1;
_u32 cycle2;

t_Combine CombineArray[4];
int CombinePasses;

extern int TexMode;
extern _u32 TexColor;

extern int	Vtidx[256];
extern int Vtcnt;
void FlushVisualTriangle(int vn[]);

  static char *Mode[] = { "CC_COMBINED" ,   	      "CC_TEXEL0" ,
						  "CC_TEXEL1" ,		  "CC_PRIMITIVE" ,
						  "CC_SHADE" ,			  "CC_ENVIRONMENT" ,
						  "CC_CENTER" ,		  "CC_COMBINED_ALPHA" ,
						  "CC_TEXEL0_ALPHA" ,    "CC_TEXEL1_ALPHA" ,
						  "CC_PRIMITIVE_ALPHA" , "CC_SHADE_ALPHA" ,
						  "CC_ENV_ALPHA" ,		  "CC_LOD_FRACTION" ,
						  "CC_PRIM_LOD_FRAC" ,   "CC_K5" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_0" };

 static char *Alpha[] = { "AC_COMBINED" ,      "AC_TEXEL0" ,
						  "AC_TEXEL1" ,        "AC_PRIMITIVE" , 
						  "AC_SHADE" ,		    "AC_ENVIRONMENT" , 
						  "AC_PRIM_LOD_FRAC" , "AC_0"};

void rdp_setcombine()
{
	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETCOMBINE \n", ADDR, CMD0, CMD1);

	cycle1 = 0;
	cycle2 = 0;

	uc0_a0  = (_u8)((rdp_reg.cmd0 >> 20) & 0xF); 
	uc0_b0  = (_u8)((rdp_reg.cmd1 >> 28) & 0xF);
	uc0_c0  = (_u8)((rdp_reg.cmd0 >> 15) & 0x1F);
	uc0_d0  = (_u8)((rdp_reg.cmd1 >> 15) & 0x7);
	uc0_Aa0 = (_u8)((rdp_reg.cmd0 >> 12) & 0x7); 
	uc0_Ab0 = (_u8)((rdp_reg.cmd1 >> 12) & 0x7);
	uc0_Ac0 = (_u8)((rdp_reg.cmd0 >> 9)  & 0x7); 
	uc0_Ad0 = (_u8)((rdp_reg.cmd1 >> 9)  & 0x7);

	cycle1 = (uc0_a0<<0)  | (uc0_b0<<4)  | (uc0_c0<<8)  | (uc0_d0<<13)| 
					(uc0_Aa0<<16)| (uc0_Ab0<<19)| (uc0_Ac0<<22)| (uc0_Ad0<<25);

	uc0_a1  = (_u8)((rdp_reg.cmd0 >> 5)  & 0xF);
	uc0_b1  = (_u8)((rdp_reg.cmd1 >> 24) & 0xF);
	uc0_c1  = (_u8)((rdp_reg.cmd0 >> 0)  & 0x1F);
	uc0_d1  = (_u8)((rdp_reg.cmd1 >> 6)  & 0x7);
	uc0_Aa1 = (_u8)((rdp_reg.cmd1 >> 21) & 0x7);
	uc0_Ab1 = (_u8)((rdp_reg.cmd1 >> 3)  & 0x7);
	uc0_Ac1 = (_u8)((rdp_reg.cmd1 >> 18) & 0x7);
	uc0_Ad1 = (_u8)((rdp_reg.cmd1 >> 0)  & 0x7);

	cycle2 = (uc0_a1<<0)  | (uc0_b1<<4)  | (uc0_c1<<8)  | (uc0_d1<<13)| 
					(uc0_Aa1<<16)| (uc0_Ab1<<19)| (uc0_Ac1<<22)| (uc0_Ad1<<25);

//	BuildCombine();

#ifdef WRITE_LOG

/*	    PRINT_RDP_INFO("SETCOMBINE - ignored")
        PRINT_RDP_MNEMONIC("	mode0=$%06lx; mode1=$%08lx\n",
               uc0_cycle1,
               uc0_cycle2);
        PRINT_RDP_WARNING("ignored")
        PRINT_RDP_MNEMONIC("a0  = %s, b0  = %s, c0  = %s, d0  = %s\n",
			   Mode[uc0_a0],Mode[uc0_b0],Mode[uc0_c0],Mode[uc0_d0]);
        PRINT_RDP_MNEMONIC("Aa0 = %s, Ab0 = %s, Ac0 = %s, Ad0 = %s\n",
               Alpha[uc0_Aa0],Alpha[uc0_Ab0],Alpha[uc0_Ac0],Alpha[uc0_Ad0]);
        PRINT_RDP_MNEMONIC("a1  = %s, b1  = %s, c1  = %s, d1  = %s\n",
               Mode[uc0_a1],Mode[uc0_b1],Mode[uc0_c1],Mode[uc0_d1]);
        PRINT_RDP_MNEMONIC("Aa1 = %s, Ab1 = %s, Ac1 = %s, Ad1 = %s\n",
               Alpha[uc0_Aa1],Alpha[uc0_Ab1],Alpha[uc0_Ac1],Alpha[uc0_Ad1]);
*/
#endif
} /* static void rdp_setcombine() */


void NewDrawVisualTriangle(int vn[3])
//void DrawVisualTriangle(int vn[3])
{
	int pass;

	for (pass = 0; pass < CombinePasses; pass++)
	{
		TexColor = CombineArray[pass].TexColor;// this is wrong, fix it!
		TexMode = CombineArray[pass].TexMode;
		MDrawVisualTriangle(vn,CombineArray[pass].t1,CombineArray[pass].s1,CombineArray[pass].s2);
	}

}

//void OldDrawVisualTriangle(int vn[3])
void DrawVisualTriangle(int vn[3])
{
	Vtidx[Vtcnt] = vn[0]; Vtcnt++;
	Vtidx[Vtcnt] = vn[1]; Vtcnt++;
	Vtidx[Vtcnt] = vn[2]; Vtcnt++;
}

void FlushVisualTriangle(int vn[256])
{
	_u8 checkup = 0;
	TexColor = 0;
	TexMode = 0;
	//MDrawVisualTriangle(vn,0,0,0);
	//return;
	if ((cycle_mode == CYCLE_MODE1) || (cycle_mode == CYCLE_MODE2))
	{
		switch(cycle1)
		{
		// Ultra1
		// ????? t1,t1,lodfrac,t0,t1,t0,comb,t0
		case 0x020a2d12: if (cycle_mode == CYCLE_MODE2)  
						 {
							TexMode = Tex;
							switch(cycle2)
							{
							case 0x9ffe4f0:
								 MDrawVisualTriangle(vn,1,UseShade,0);
								 break;
							default:
								 checkup = 1;
								 break;
							}
						 }
						 TexMode = Tex;
						 MDrawVisualTriangle(vn,1,UseShade,0);
						 break;
		//????? not right should be
		// t1,t0,prim,t0,t1,t0,prim,t0
		// env,comb,enva,comb,0,0,0,comb
		case 0x02ca2312: if (cycle_mode == CYCLE_MODE2)  
						 {
							//TexMode = Tex;
							switch(cycle2)
							{
							case 0x01ff0c05:
								TexMode = Env_Sub_Tex_Mult_EnvAlpha_Add_Tex;
								MDrawVisualTriangle(vn,1,0,0);
//								TexMode = 0;
//								MDrawVisualTriangle(vn,1,0,0);
//								TexMode = AlphaT0;
//								MDrawVisualTriangle(vn,1,UseEnv,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 //TexMode = Tex;
						 MDrawVisualTriangle(vn,1,0,0);
						 break;
		// t1,t0,prima,t0,t1,t0,prim,t0
		case 0x02ca2a12: if (cycle_mode == CYCLE_MODE2)  
						 {
							//TexMode = Tex;
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 //TexMode = Tex;
						 MDrawVisualTriangle(vn,1,0,0);
						 break;
		case 0x034a2c12: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? t1,prim,plf,t0,t1,plf,plf,t0
		case 0x03b22e32: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		case 0x03ff2c15: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Env_Sub_Tex_Mult_EnvAlpha_Add_Tex;
							 TexColor = rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,t0,0,0,0,t0
		case 0x03ff3fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,1,0,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,0,0);
						 break;
		//????? k5,k5,0,prim,0,0,0,t0
		case 0x03ff7fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		//????? prim,shade,t0,shade,0,0,0,t0
		case 0x03ff8143: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade,0);
							 TexMode = 0;
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		// not right.
		//????? t0,shade,prim,shade,0,0,0,to
		case 0x03ff8341: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade,0);
							 TexMode = Alpha_Mult_Prim;
							 //TexMode = 0;
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		//????? k5,k5,0,shade,0,0,0,t0
		case 0x03ff9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x03ff9fff:
								TexMode = AlphaT0;
								MDrawVisualTriangle(vn,1,UseShade,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 break;
		//????? k5,k5,0,env,0,0,0,t0
		case 0x03ffBfff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseEnv,0);
						 break;
		//????? x t1,k5,t0,ca,0,0,0,t0 not done right doesn't use t1
		case 0x03ffe1f2: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? x prim,k5,t0,ca,0,0,0,t0 not done right doesn't use t1
		case 0x03ffe1f3: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x03ffe1f3:
								MDrawVisualTriangle(vn,1,UsePrim,0);
								break;
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		//????? shade,k5,t0,ca,0,0,0,t0
		case 0x03ffe1f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 }
						 break;
		//????? t0,k5,prim,ca
		//		0,0,0,t0
		//		comb,k5,shade,ca
		//      0,0,0,ca
		case 0x03ffe3f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							case 0x01ffe4f0:
								MDrawVisualTriangle(vn,1,UsePrimShade,0);
								break;
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		//????? t0,k5,shade,ca,0,0,0,t0
		case 0x03ffe4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{		
								// ???? cent,k5,env,comb,0,0,0,comb
							case 0x01ff05f6:
								MDrawVisualTriangle(vn,1,UseEnv | UseShade,0);
								break;
								// ???? comb,k5,prim,env,0,0,0,comb
							case 0x01ffa3f0:
								MDrawVisualTriangle(vn,1,UsePrim | UseEnv | UseShade,0);
								break;
							case 0x03ffe4f1:
								MDrawVisualTriangle(vn,1,UseShade,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 }
						 break;
		//????? cent,k5,shade,ca,0,0,0,t0
		case 0x03ffe4f6: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 }
						 break;
		//????? x t0,k5,env,ca,0,0,0,t0
		case 0x03ffe5f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{		
							default:
								checkup = 1;
								break;

							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UseEnv,0);
						 }
						 break;
		//????? k5,k5,0,ca,0,0,0,t0
		case 0x03ffffff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,shade,0,0,0,prim
		case 0x07ff9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
								 MDrawVisualTriangle(vn,0,UseShade | UsePrimAlpha,0);
						 }
						 break;
		//????? t0,k5,prim,ca,0,0,0,t0
		case 0x07ffe3f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,1,UsePrim,0);
								break;
							default:
								checkup = 1;
								break;

							}
						 }
						 else
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 break;
		//????? shade,k5,prim,ca,0,0,0,t0
		case 0x07ff7fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,0,UsePrim | UsePrimAlpha ,0);
								break;
							default:
								checkup = 1;
								break;

							}
						 }
						 else
							 MDrawVisualTriangle(vn,0,UsePrim | UsePrimAlpha ,0);
						 break;
		//????? shade,k5,prim,ca,0,0,0,t0
		case 0x07ffe3f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,0,UsePrimShade | UsePrimAlpha ,0);
								break;
							default:
								checkup = 1;
								break;

							}
						 }
						 else
							 MDrawVisualTriangle(vn,0,UsePrimShade | UsePrimAlpha ,0);
						 break;
		//????? Mario's face
		// not right should be pri,shade,t0,shade,pri,shade,t0,shade
		case 0x08638143: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,0,UseShade,0);
//							 TexMode = Alpha_Mult_Prim;
							 TexMode = AlphaT0Red;
//							 MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
						 }
						 break;
		// cent,lf,undef,env,t1,t0,0,shade
		case 0x09cab1d6: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		//????? super mario background in intro.
		// k5,k5,0,t0,0,0,0,shade
		case 0x09ff3fff: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		// cent,prim,env,prim,0,0,0,Shade
		case 0x09ff6536: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Tex_Sub_Prim_Mult_Env_Add_Prim;
							 TexColor = rdp_reg.primcolor ^ rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		// das rote 64-teil oben rechts x
		// k5,k5,0,shade,0,0,0,shade
		case 0x09ff9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,0,0,2);
						 {
								 MDrawVisualTriangle(vn,0,UseShade | UseShadeAlpha,0);
						 }
						 break;
		// ????? shade,k5,prim,comba,0,0,0,shade
		case 0x09ffe3f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,0,UsePrimShade | UseShadeAlpha,0);
						 }
						 break;
		//ie: Mario64 - logo rand... :) 
		// t0,k5,shade,comba,0,0,0,shade
		case 0x09ffe4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							 TexMode = Tex;
							 switch(cycle2)
							 {
							 case 0x1ff1fff:
									 MDrawVisualTriangle(vn,1,UseShade | UseShadeAlpha,0);
								 break;
							 default:
								 checkup = 1;
								 break;
							 }
						 }
						 else 
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseShade | UseShadeAlpha,0);
						 }
						 break;
		// ????? prim,k5,shade,comba
		//		 0,0,0,shade
		//		 k5,k5,0,comb
		//		 0,0,0,comb
		case 0x09ffe4f3: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,0,UsePrimShade | UseShadeAlpha,0);
						 }
						 break;
		// ????? t1,t0,env,t0,0,0,0,env,k5,k5,0,comb,0,0,0,comb
		case 0x0bff2512:if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x1ff1fff:
								MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,13);
						 {
							 MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
						 }
						 break;
		// Mario-Schrift (beim Logo): alphablending fehlt irgendwie ... x
		// k5,k5,0,t0,0,0,0,env
		case 0x0bff3fff:if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,8);
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
						 }
						 break;
		// k5,k5,0,prim,0,0,0,env
		case 0x0bff7fff:if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							// ???? cent,k5,env,comb,0,0,0,comb
							case 0x01ff05f6:
								TexMode = Tex;
								MDrawVisualTriangle(vn,1,UseEnv | UsePrim | UseEnvAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,8);
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
						 }
						 break;
		//????? env,shade,env,shade,0,0,0,env
		case 0x0bff8545: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,9);
						 {
							 MDrawVisualTriangle(vn,2,UseShadeEnvFade | UseEnvAlpha,0);
						 }
						 break;
		//????? t0,shade,t0,shade,0,0,0,env
		case 0x0bff8841: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,9);
						 {
							 MDrawVisualTriangle(vn,2,UseShade | UseEnvAlpha,UseEnvAlpha);
						 }
						 break;
		//????? k5,k5,0,shade,0,0,0,env
		case 0x0bff9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,0,UseShade | UseEnvAlpha,0);
						 }
						 break;
		//????? t0,k5,shade,comba,0,0,0,env
		case 0x0bffe4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else //MDrawVisualTriangle(vn,1,0,9);
						 {
							 TexMode = Tex;
							 MDrawVisualTriangle(vn,1,UseShade | UseEnvAlpha,0);
						 }
						 break;
		//????? prim,k5,shade,ca,0,0,0.env
		case 0x0bffe4f3: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff05f6:
								TexMode = AlphaT0;
								MDrawVisualTriangle(vn,1,UseEnv | UsePrim | UsePrimShade | UseEnvAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,0,UsePrim | UsePrimShade | UseEnvAlpha,0);
						 }
						 break;
		//????? t1,t0,enva,t0,0,0,0,primlodfrac
		case 0x0dff2c12: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,t0,0,0,0,primlodfrac
		case 0x0dff3fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,prim,0,0,0,primlodfrac
		case 0x0dff7fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,shade,0,0,0,primlodfrac
		case 0x0dff9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 }
						 break;
		// not done right should be 
		// t0,env,prim,env,0,0,0,prim_lod_frac
		case 0x0dffa351: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {

							 TexMode = Tex_Sub_Env_Mult_Prim_Add_Env;
							 MDrawVisualTriangle(vn,1,0,0);

//							 TexMode = AlphaT0;
//							 MDrawVisualTriangle(vn,1,UseEnv,0);
//							 TexMode = 0;
//							 MDrawVisualTriangle(vn,1,UsePrimAsAlpha,0);
						 }
						 break;
		//????? k5,k5,0,center,0,0,0,primlodfrac
		case 0x0dffdfff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? t0,k5,prim,comba,0,0,0,primlodfrac
		case 0x0dffe3f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 //TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UsePrim,0);
						 }
						 break;
		//????? shade,k5,prim,comba,0,0,0,primlodfrac
		case 0x0dffe3f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade | UsePrim,0);
						 }
						 break;
		//????? t0,k5,shade,comba,0,0,0,primlodfrac
		case 0x0dffe4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 //TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade,0);
						 }
						 break;
		//????? t0,k5,env,comba,0,0,0,primlodfrac
		case 0x0dffe5f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 //TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseEnv,0);
						 }
						 break;
		//????? center,env,t0,prim,prim,0,t0,0
		case 0x0e7b6156: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x0e7b6156:
								//TexMode = Prim_Sub_Tex | Tex;
								TexMode = Tex_Sub_Env_Mult_Tex_Add_Prim;
								TexColor = rdp_reg.primcolor;
								//MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
								MDrawVisualTriangle(vn,1,0,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Prim_Sub_Tex | Tex;
							 TexColor = rdp_reg.primcolor;
							 //MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? prim,env,t0,env,prim,0,t0,0
		case 0x0e7ba153: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Prim_Sub_Env_Mult_Tex_Add_Env;
							 TexColor = rdp_reg.primcolor ^ rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,0,0);
						 }
						 break;
		//????? k5,k5,0,prim,prim,0,t0,0
		case 0x0e7b7fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
						 }
						 break;
		//????? t0,k5,prim,comba,shade,0,t0,0
		case 0x0e7ce3f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,UsePrim | UseShadeAlpha,0);
						 break;
		//????? t0,k5,shade,comba,env,0,t0,0
		case 0x0e7de4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,UseShade | UseEnvAlpha,0);
						 break;
		//????? t0,prim,plf,t0,t0,0,prim,0
		case 0x0ef92e31: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
							 MDrawVisualTriangle(vn,1,UsePrimAlpha,0);
						 break;
		//????? k5,k5,0,prim,t0,0,prim,0
		case 0x0ef97fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
						 break;
		//????? k5,k5,0,shade,t0,0,prim,0
		case 0x0ef99fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							 switch(cycle2)
							 {
							 default:
								 checkup = 1;
								 break;
							 }
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade | UsePrimAlpha,0);
						 }
						 break;
		//????? prim,env,t0,env,t0,0,prim,0
		case 0x0ef9a153: if (cycle_mode == CYCLE_MODE2)  
						 {
							 switch(cycle2)
							 {
							 default:
								 checkup = 1;
								 break;
							 }
						 }
						 else 
						 {
							 TexMode = Prim_Sub_Env_Mult_Tex_Add_Env;
							 TexColor = rdp_reg.primcolor - rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,UsePrimAlpha,0);
						 }
						 break;
		//????? t0,env,prim,env,to,0,prim,0
		case 0x0ef9a351: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Tex_Sub_Env_Mult_Prim_Add_Env;
							 TexColor = rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,UsePrimAlpha,0);
//							 TexMode = AlphaT0;
//							 MDrawVisualTriangle(vn,1,UseEnv | UsePrimAlpha,0);
//							 TexMode = 0;
//							 MDrawVisualTriangle(vn,1,UsePrimAsAlpha | UsePrimAlpha,0);
						 }
						 break;
		//????? shade,k5,t0,ca,to,0,prim,0
		case 0x0ef9e1f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,UseShade | UsePrimAlpha,0);
						 break;
		//????? t0,k5,prim,ca,to,0,prim,0
		case 0x0ef9e3f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,UsePrim | UsePrimAlpha,0);
						 break;
		//????? t0,k5,shade,ca,to,0,prim,0
		case 0x0ef9e4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,1,UseShade | UsePrimAlpha,0);
						 break;
		//????? shade,k5,prim,ca,shade,0,prim,0
		case 0x0efce3f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else MDrawVisualTriangle(vn,0,UsePrim | UsePrimAlpha | UseShade | UseShadeAlpha,0);
						 break;
		// t1,t0,lf,t0,t0,0,Shade,0
		case 0x0f392d12: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		// k5,k5,0,t0,t0,0,Shade,0
		case 0x0f393fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		// cent,prim,env,prim,0,0,0,Shade
		case 0x0f396531: if (cycle_mode == CYCLE_MODE2)  
						 {						
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = Tex_Sub_Prim_Mult_Env_Add_Prim;
							 TexColor = rdp_reg.primcolor ^ rdp_reg.envcolor;
							 MDrawVisualTriangle(vn,1,UseShadeAlpha,0);
						 }
						 break;
		//????? t0,shade,prim,shade,to,0,shade,0
		case 0x0f398341: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }	
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade | UseShadeAlpha,0);
//							 TexMode = Alpha_Mult_Prim;
							 TexMode = 0;
							 MDrawVisualTriangle(vn,1,UsePrimAsAlpha | UseShadeAlpha,0);
						 }
						 break;
		//????? k5,k5,0,shade,t0,0,shade,0
		case 0x0f399fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseShade | UseShadeAlpha,0);
						 }
						 break;
		//????? prim,k5,shade,ca,prim,0,shade,0
		case 0x0f3be4f3: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x0850205:
								MDrawVisualTriangle(vn,1,UsePrimShade | UsePrimShadeAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 //TexMode=Tex;
							 MDrawVisualTriangle(vn,1,UsePrimShade | UsePrimShadeAlpha,0);
						 }
						 break;
		//????? t0,k5,shade,ca,t0,0,shade,0
		case 0x0f39e4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							 MDrawVisualTriangle(vn,1,UseShade | UseShadeAlpha,0);
						 }
						 break;
		//????? t0,k5,env,comba,t0,0,shade,0
		case 0x0f39e5f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 MDrawVisualTriangle(vn,1,UseEnv | UseShadeAlpha,0);
						 }
						 break;
		// not right
		//????? t0,k5,env,comba,t0,0,shade,0
		case 0x0f39ffff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff1fff:
								TexMode = AlphaT0;
								MDrawVisualTriangle(vn,1, UseShade | UseShadeAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
//							 MDrawVisualTriangle(vn,1,UseEnv | UseShadeAlpha,0);
						 }
						 break;
		//????? k5,k5,0,t0,t0,0,env,0
		case 0x0f793fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
							default:
								checkup = 1;
								break;
							}
						 }
						 else
							 MDrawVisualTriangle(vn,1,UseEnvAlpha,0);
						 break;
		//????? k5,k5,0,shade,prim,0,env,0
		case 0x0f7b9fff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff1fff:
								MDrawVisualTriangle(vn,0,UseShade | UsePrimEnvAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							MDrawVisualTriangle(vn,0,UseShade | UsePrimEnvAlpha,0);
						 }
						 break;
		//????? k5,k5,0,env,t0,0,env,0
		case 0x0f79bfff: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x01ff1fff:
								TexMode = AlphaT0;
								MDrawVisualTriangle(vn,1,UseEnvAlpha | UseEnv,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
						 {
							 TexMode = AlphaT0;
							 MDrawVisualTriangle(vn,1,UseEnvAlpha | UseEnv,0);
						 }
						 break;
		//????? t0,k5,shade,ca,t0,0,env,0,k5,k5,0,comb
		case 0x0f79e4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							case 0x1ff1fff:
								MDrawVisualTriangle(vn,1,UseShade | UseEnvAlpha,0);
								break;
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							MDrawVisualTriangle(vn,1,UseShade | UseEnvAlpha,0);
						 }
						 break;
		//????? t0,k5,env,ca,t0,0,env,0
		case 0x0f79e5f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{							
							default:
								checkup = 1;
								break;
							}
						 }
						 else 
							MDrawVisualTriangle(vn,1,UseEnv | UseEnvAlpha,0);
						 break;
		//????? t0,k5,shade,ca,t1,0,env,0
		case 0x0f7ae4f1: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
							MDrawVisualTriangle(vn,1,UseShade | UseEnvAlpha,0);
						 }
						 break;
		//????? shade,k5,env,comba,shade,0,env,0
		case 0x0f7ce5f4: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
								MDrawVisualTriangle(vn,0,UseEnvShade | UseEnvShadeAlpha,0);
						 }
						 break;
						 //????? t0,prim,env,t0,0,0,0,0
		case 0x0fff2c31: if (cycle_mode == CYCLE_MODE2)  
						 {
							switch(cycle2)
							{
							default:
								checkup = 1;
								break;
							}
						 }
						 else
						 {
								TexMode = Tex;
								MDrawVisualTriangle(vn,1,0,0);
								MDrawVisualTriangle(vn,0,UsePrim | UseEnvAlpha,0);
						 }
						 break;

		default:
			{
				checkup = 4;
			}
		}
	}
	else if(cycle_mode == CYCLE_COPY)
	{
		checkup = 2;
	}
	else if(cycle_mode == CYCLE_FILL)
	{
		checkup = 3;
		MDrawVisualTriangle(vn,1,0,0);
	}

	if (checkup != 0)
	{		
#ifdef DEBUGCC
		char *output[1024];
		sprintf(output,"Mode1 = %8x Mode2 = %8x CycleMode = %i\na0  = %s, b0  = %s, c0  = %s, d0  = %s\nAa0 = %s, Ab0 = %s, Ac0 = %s, Ad0 = %s\na1  = %s, b1  = %s, c1  = %s, d1  = %s\nAa1 = %s, Ab1 = %s, Ac1 = %s, Ad1 = %s\n",
				cycle1,cycle2,cycle_mode,
				Mode[uc0_a0],   Mode[uc0_b0],   Mode[uc0_c0],   Mode[uc0_d0],
				Alpha[uc0_Aa0], Alpha[uc0_Ab0], Alpha[uc0_Ac0], Alpha[uc0_Ad0],
				Mode[uc0_a1],   Mode[uc0_b1],   Mode[uc0_c1],   Mode[uc0_d1],
				Alpha[uc0_Aa1], Alpha[uc0_Ab1], Alpha[uc0_Ac1], Alpha[uc0_Ad1]);
			MessageBox(hGraphics, output, "DisplayCC", MB_OK);
		exit(1);
#else
		MDrawVisualTriangle(vn,1,0,0);
#endif
	}
#ifdef WRITE_LOG
		PRINT_RDP_MNEMONIC("%i 0x%x\n",checkup, cycle1);
#endif

}


//#undef DEBUGCC
