#include <GL/gl.h>

void rsp_uc04_vertex();
void rsp_uc04_modifyvertex();
void rsp_uc04_culldl();
void rsp_uc04_branchz();
void rsp_uc04_tri1();
void rsp_uc04_tri2();
void rsp_uc04_quad();
void rsp_uc04_fastcombine();
void rsp_uc04_rdphalf_cont();
void rsp_uc04_rdphalf_2();
void rsp_uc04_line3d();
void rsp_uc04_texture();
void rsp_uc04_popmatrix();
void rsp_uc04_setgeometrymode();
void rsp_uc04_matrix();
void rsp_uc04_moveword();
void rsp_uc04_movemem();
void rsp_uc04_displaylist();
void rsp_uc04_enddl();
void rsp_uc04_rdphalf_1();
void rsp_uc04_setothermode_l();
void rsp_uc04_setothermode_h();

void rsp_uc04_special_1()
{
	DebugBox("special_1");
}

void rsp_uc04_special_2()
{
	DebugBox("special_2");
}

void rsp_uc04_special_3()
{
	DebugBox("special_3");
}

void rsp_uc04_dma_io()
{
	DebugBox("dma_io");
}

void rsp_uc04_load_ucode()
{
	DebugBox("load_ucode");
}

void rsp_uc04_noop()
{
	DebugBox("noop");
}



//////////////////////////////////////////////////////////////////////////////
// structure is tricky for changing the endians								//
//////////////////////////////////////////////////////////////////////////////
typedef struct 
{
	_s16 y;
	_s16 x;
	_u16 flags;
	_s16 z;

	_s16 t;
	_s16 s;

	_u8  a;
	_u8  b;
	_u8  g;
	_u8  r;
} t_vtx_uc4;



//////////////////////////////////////////////////////////////////////////////
// LoadVertex																//
//////////////////////////////////////////////////////////////////////////////
void rsp_uc04_vertex()
{
	_u32	a = segoffset2addr(rdp_reg.cmd1);
	int     v0, i, n;
	_u32	Num2, Num, Index0;

//	if (rdp_reg.cmd1 & 0x08) a ^= 2;

	//a += 2;

	n = (rdp_reg.cmd0 >> 12) & 0x7f;
	v0 = ((rdp_reg.cmd0 >> 1) & 0x7f) - n;

	LOG_TO_FILE("%08X: %08X %08X CMD UC4_LOADVTX  vertex %i..%i\n",
				 ADDR, CMD0, CMD1,  v0, n-1);

	for(i = 0; i < n; i++)
	{
//		t_vtx_uc4 *vtx = (t_vtx_uc4 *)&pRDRAM[a+(i*sizeof(t_vtx_uc4))];
		_u32 ad = a + (i * sizeof(t_vtx_uc4));

		rdp_reg.vtx[v0].x     = (float)(_s16)doReadMemHalfWord(ad+0);
		rdp_reg.vtx[v0].y     = (float)(_s16)doReadMemHalfWord(ad+2);
		rdp_reg.vtx[v0].z     = (float)(_s16)doReadMemHalfWord(ad+4);
		rdp_reg.vtx[v0].flags = (_u16)doReadMemHalfWord(ad+6);
		rdp_reg.vtx[v0].s     = (float)(_s16)doReadMemHalfWord(ad+8);
		rdp_reg.vtx[v0].t     = (float)(_s16)doReadMemHalfWord(ad+10);
		rdp_reg.vtx[v0].r     = (_u8)(_u8)doReadMemHalfWord(ad+12);
		rdp_reg.vtx[v0].g     = (_u8)(_u8)doReadMemHalfWord(ad+13);
		rdp_reg.vtx[v0].b     = (_u8)(_u8)doReadMemHalfWord(ad+14);
		rdp_reg.vtx[v0].a     = (_u8)(_u8)doReadMemHalfWord(ad+15);

//		LOG_TO_FILE("   vtx[%02i]: [xyz %04X %04X %04X] -> %12.5f %12.5f %12.5f\n",
//		      v0, vtx->x, vtx->y, vtx->z, 
//			  rdp_reg.vtx[v0].x, rdp_reg.vtx[v0].y, rdp_reg.vtx[v0].z );

		v0++;
	}
}

void rsp_uc04_modifyvertex()
{
	DebugBox("ModifyVertex\n");
	LOG_TO_FILE("%08X: %08X %08X CMD UC4_MODIFYVTX \n", ADDR, CMD0, CMD1);

}

void rsp_uc04_culldl()
{
	DebugBox("CullDisplaylist\n");
	PRINT_RDP_NOT_IMPLEMENTED("NI: CULLDL");
}

void rsp_uc04_branchz()
{
	DebugBox("BranchZ\n");
	PRINT_RDP_INFO("NI: BRANCHZ ");
}


void rsp_uc04_tri1()
{
	int     vn[3];

	vn[0] = ((CMD0 >> 16) & 0xff) / 2;
	vn[1] = ((CMD0 >>  8) & 0xff) / 2;
	vn[2] = ( CMD0        & 0xff) / 2;

	DrawVisualTriangle(vn);
//	Render_tr(vn);

	LOG_TO_FILE("%08X: %08X %08X CMD UC4_TRI1 (%i,%i,%i)\n", 
				 ADDR, CMD0, CMD1, vn[0], vn[1], vn[2]);
} // void rsp_uc04_tri1()


void rsp_uc04_tri2()
{
	int     vn[6];
	
	vn[0] = ((CMD0 >> 16) & 0xff) / 2;
	vn[1] = ((CMD0 >>  8) & 0xff) / 2;
	vn[2] = ( CMD0        & 0xff) / 2;

	vn[3] = ((CMD1 >> 16) & 0xff) / 2;
	vn[4] = ((CMD1 >>  8) & 0xff) / 2;
	vn[5] = ( CMD1        & 0xff) / 2;

	DrawVisualTriangle(vn);
	DrawVisualTriangle(vn+3);
//	Render_tr(vn);
//	Render_tr(vn+3);

	LOG_TO_FILE("%08X: %08X %08X CMD UC4_TRI2 (%i,%i,%i) (%i,%i,%i)\n", 
				 ADDR, CMD0, CMD1, vn[0], vn[1], vn[2], vn[3], vn[4], vn[5]);
} // void rsp_uc04_tri2()

void rsp_uc04_quad()
{
	int     vn[6], i;


	DebugBox("12");

	vn[0] = ((rdp_reg.cmd0 >> 16) & 0xff) / 2;
	vn[1] = ((rdp_reg.cmd0 >>  8) & 0xff) / 2;
	vn[2] = ( rdp_reg.cmd0        & 0xff) / 2;

	vn[3] = ((rdp_reg.cmd1 >> 16) & 0xff) / 2;
	vn[4] = ((rdp_reg.cmd1 >>  8) & 0xff) / 2;
	vn[5] = ( rdp_reg.cmd1        & 0xff) / 2;

	DrawVisualTriangle(vn);
	DrawVisualTriangle(vn+3);

	LOG_TO_FILE("%08X: %08X %08X CMD UC4_QUAD (%i,%i,%i) (%i,%i,%i)\n", 
				 ADDR, CMD0, CMD1, vn[0], vn[1], vn[2], vn[3], vn[4], vn[5]);
} // static void rsp_uc04_quad()


void rsp_uc04_fastcombine()
{
#ifdef WRITE_LOG
        PRINT_RDP_INFO("NI: FAST COMBINE ");
#endif

}

void rsp_uc04_rdphalf_cont()
{
#ifdef WRITE_LOG
        PRINT_RDP_INFO("NI: RDP HALF CONT ");
#endif

}

void rsp_uc04_rdphalf_2()
{
#ifdef WRITE_LOG
        PRINT_RDP_INFO("NI: RDP HALF 2 ");
#endif

}

void rsp_uc04_line3d()
{
#ifdef WRITE_LOG
        PRINT_RDP_INFO("NI: LINE 3d ");
#endif

}

void rsp_uc04_texture()
{
        int tile = (rdp_reg.cmd0 >> 8)  & 0x07;				//** tile
		_u32 mipmap_level = (rdp_reg.cmd0 >> 11) & 0x07;	//** mipmap_level   - not used yet
		_u32 on = (rdp_reg.cmd0 & 0xff);			//** 1: on - 0:off

		float s = (float)((rdp_reg.cmd1 >> 16) & 0xffff);
		float t = (float)((rdp_reg.cmd1      ) & 0xffff);

		t_tile *tmp_tile = &rdp_reg.td[tile];
		tmp_tile->Texture_on = (_u8)on;

		tmp_tile->SScale=(float)s/65535.f;
		tmp_tile->TScale=(float)t/65535.f;

		tmp_tile->TScale/=32.f;
		tmp_tile->SScale/=32.f;
}

void rsp_uc04_popmatrix()
{
//	_u32 param = (CMD1 / 64);
	_u32 param = (((((CMD0 >> 19) & 0x1f) + 1) * 8)/ 64);


	switch(CMD1)
	{
	case 0x40:
		pop_matrix();
		break;
	}

	PRINT_RDP_INFO("POPMATRIX ");
}

void rsp_uc04_setgeometrymode()
{

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETGEOMETRYMODE ");
        PRINT_RDP_MNEMONIC(
                "+$%08lx:\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1 & 0x00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1 & 0x00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1 & 0x00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1 & 0x00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1 & 0x00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1 & 0x00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1 & 0x00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1 & 0x00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1 & 0x00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1 & 0x00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1 & 0x00100000) ? "        lod\n" : ""
                );
#endif
        rdp_reg.geometrymode &= ~(rdp_reg.cmd0 &0xffffff);
        rdp_reg.geometrymode |= rdp_reg.cmd1;

        if(rdp_reg.cmd1 & 0x00000002)
                rdp_reg.geometrymode_textures = 1;

//		Render_geometry_zbuffer(1);
        if(~(rdp_reg.cmd0) & 0x0000001)
                Render_geometry_zbuffer(0);
        if(rdp_reg.cmd1 & 0x0000001)
                Render_geometry_zbuffer(1);

//		if (rdp_reg.geometrymode & 0x00003000) Render_geometry_cullfrontback(0);
        switch(rdp_reg.geometrymode & 0x00003000)
        {
            case 0x1000:
                Render_geometry_cullfront(1);
                break;
            case 0x2000:
                Render_geometry_cullback(1);
                break;
            case 0x3000:
                Render_geometry_cullfrontback(1);
                break;
            default:
//                Render_geometry_cullfrontback(0);
				break;
        } //** switch(rdp_reg.geometrymode & 0x00003000) 


		if((~(rdp_reg.cmd0) & 0x00020000) != 0)
				rdp_reg.useLights = 0;
		if((rdp_reg.cmd1 & 0x00020000) != 0)
				rdp_reg.useLights = 1;

}

void rsp_uc04_matrix()
{

        _u32   a = segoffset2addr(rdp_reg.cmd1);
        _u8   command =(_u8)(CMD0 & 0xff);
        float   m[4][4];
        int     i, j;


#ifdef WRITE_LOG
        PRINT_RDP_INFO("MATRIX ");
#endif


//		hleGetMatrix((float*)m, (DWORD*)&pRDRAM[a]);

        a = a >> 1;  
 for(i=0;i<16;i+=4)
  {
   for(j=0;j<4;j++)
    {
     m[i>>2][j] = (float)
      ((((long)((unsigned short *)pRDRAM)[(a + i + j)^1]) << 16) |
       ((unsigned short *)pRDRAM)[(a + i + j + 16)^1]) / 65536.0f;
    }
  }

/*
        for(i = 0; i < 16; i+=4)
        {
                for(j = 0; j < 4; j++)
                {
                        m[i>>2][j] = (float)
                                (
                                        (((_s32)((_u16 *)pRDRAM)[(a + i + j)^1]) << 16)
                                        |
                                        ((_u16 *)pRDRAM)[(a + i + j + 16)^1]
                                ) / 65536.0f;
                }
        }

*/
		LOG_TO_FILE("%08X: %08X %08X CMD UC4_LOADMTX  at %08X\n", ADDR, CMD0, CMD1, a);
        LOG_TO_FILE(
				"Load matrix\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "\n",
                m[0][0], m[0][1], m[0][2], m[0][3],
                m[1][0], m[1][1], m[1][2], m[1][3],
                m[2][0], m[2][1], m[2][2], m[2][3],
                m[3][0], m[3][1], m[3][2], m[3][3]
                );

        switch(command)
        {

            case 0: // modelview  mul  push   
                push_mult_matrix((GLfloat *)m);
                break;

            case 1: // modelview  mul  nopush 
                mult_matrix((GLfloat *)m);
                break;

            case 2: // modelview  load push   
                push_load_matrix((GLfloat *)m);
                break;

            case 3: // modelview  load nopush 
                load_matrix((GLfloat *)m);
                break;

            case 4: // projection mul  push   
				DebugBox("strange Matrix-CMD");
                glMultMatrixf((GLfloat *)m);
                break;

            case 5: // projection mul  nopush 
                glMultMatrixf((GLfloat *)m);
                break;

            case 6: // projection load push   
				DebugBox("strange Matrix-CMD");
                glLoadMatrixf((GLfloat *)m);
                break;

            case 7: // projection load nopush 
                glLoadMatrixf((GLfloat *)m);
                break;

            default:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MATRIX: UNKNOWN COMMAND")
#endif
				;

        } /* switch(command) */

        //


#ifdef WRITE_LOG
        PRINT_RDP_NOT_IMPLEMENTED("MATRIX")
#endif        


}

void rsp_uc04_moveword()
{
        int i;
		_u16 offset= (_u16)(CMD0 & 0xffff);
		_u8 index=   (_u8)(CMD0>>16)&0xff;
		_u64 data=rdp_reg.cmd1;

        switch(index)
        {
            case G_MW_MATRIX:
                DebugBox("NI: MOVEWORD MATRIX\n");
                break;

            case G_MW_NUMLIGHT:
                rdp_reg.lights = (_u32)((data & 0xff) / 24);
				if (rdp_reg.lights > 7) rdp_reg.lights = 7;
                break;

            case G_MW_CLIP:
                //PRINT_RDP("MOVEWORD CLIP: ");
                //PRINT_RDP("ignored\n");
                break;

            case G_MW_SEGMENT:
                //PRINT_RDP("MOVEWORD SEGMENT: ");
                //PRINT_RDP("$%08lx -> seg#%d\n", CMD1, offset / 4);
                rdp_reg.segment[offset >> 2] = CMD1 & 0xffffff;
                break;

            case G_MW_FOG:
                //PRINT_RDP("MOVEWORD FOG\n");
                break;

            case G_MW_LIGHTCOL:
                i = (rdp_reg.cmd0 & 0x0000e000) >> 13;

                if(rdp_reg.cmd0 & 0x00000400)
                {
                        //PRINT_RDP("MOVEWORD LIGHTCOL ");
                        rdp_reg.light[i].r         = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g         = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b         = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a         = 1.0f;

                }
                else
                {
                        //PRINT_RDP("MOVEWORD LIGHTCOL (copy) ");
                        rdp_reg.light[i].r_copy    = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g_copy    = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b_copy    = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a_copy    = 1.0f;
                }

                //PRINT_RDP("%d: rgb?=$%08lx\n", i, rdp_reg.cmd1);
                //PRINT_RDP(
                //        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f\n",
                //        ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f,
                //        ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f,
                //        ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f,
                //        1.0f
                //        );
				//calculate_light_vectors();
                break;

            case G_MW_FORCEMTX:
                DebugBox("G_MW_FORCEMTX\n");
                break;

            case G_MW_PERSPNORM:
                break;

            default: 
                //PRINT_RDP("MOVEWORD %x\n", index);
				;

        } /* switch(rdp_reg.cmd0 & 0xff) */
}

void rsp_uc04_movemem()
{
		_u32 a, param;
        int   i;

		param = (CMD0 & 0xff);
        switch(param)
        {
			case G_MV_MMTX:
				DebugBox("MV_MMTX");
				break;

			case G_MV_PMTX:
				//DebugBox("MV_PMTX");
				break;

			case G_MV_VIEWPORT:
				break;

			case G_MV_LIGHT:
				{
					int a = segoffset2addr(rdp_reg.cmd1) & 0x007fffff;
					int i = ((CMD0 >> 8) & 0xff)*8;
					if (i < G_MVO_L0) break;
					i = (i - G_MVO_L0) / 24;
					rdp_reg.light[i].r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
					rdp_reg.light[i].g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
					rdp_reg.light[i].b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
					rdp_reg.light[i].a         = 1.0f;
					rdp_reg.light[i].r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
					rdp_reg.light[i].g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
					rdp_reg.light[i].b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
					rdp_reg.light[i].a_copy    = 1.0f;
					rdp_reg.light[i].x         = ((float)((_s8 *)pRDRAM)[(a+ 8)^3])/127.0f;
					rdp_reg.light[i].y         = ((float)((_s8 *)pRDRAM)[(a+ 9)^3])/127.0f;
					rdp_reg.light[i].z         = ((float)((_s8 *)pRDRAM)[(a+10)^3])/127.0f;
					rdp_reg.light[i].w         = 1.0f;
				}
				break;

			case G_MV_POINT:
				break;

			case G_MV_MATRIX: 
				DebugBox("MV_MATRIX");
				break;

			case G_MVO_LOOKATX:
				break;

			case G_MVO_LOOKATY:
				break;

			case G_MVO_L0:
			case G_MVO_L1:
			case G_MVO_L2:
			case G_MVO_L3:
			case G_MVO_L4:
			case G_MVO_L5:
			case G_MVO_L6:
			case G_MVO_L7:
				break;


            default:
				//DebugBox("unknow MoveMem %04x", param);
				break;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xffff) */

#ifdef WRITE_LOG
        PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM")
#endif        


}

void rsp_uc04_displaylist()
{
        _u32 addr = segoffset2addr(CMD1);
        _u8  push = (_u8)(CMD0 >> 16) & 0xff; 

        switch(push)
        {
            case 0:   // push: we do a call of the dl 
                rdp_reg.pc_i++;
                if(rdp_reg.pc_i > 9)
                {
					DebugBox("DList Stack overflow");
					return;
                }
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            case 1:   // branch 
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            default:
                DebugBox("Unknow DList command");
                break;

        } // switch(push) 

}

void rsp_uc04_enddl()
{
        if(rdp_reg.pc_i < 0)
        {
			DebugBox("EndDL - Display Stack underrun");
			rdp_reg.halt = 1;
			return;
        }

        if(rdp_reg.pc_i == 0)
        {
			rdp_reg.halt = 1;
        }

        rdp_reg.pc_i--;
}


void rsp_uc04_enddisplaylist()
{
	rdp_reg.halt = 1;
	return;
}


void rsp_uc04_rdphalf_1()
{
}

void rsp_uc04_setothermode_l()
{
        static char *ac[] = { "none", "threshold", "?", "diter" };
        static char *zs[] = { "pixel", "prim" };
        static char *a1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)"
                };
        static char *b1[] =
                {
                        "        bl_clr_in (1)",
                        "        bl_clr_mem (1)",
                        "        bl_clr_bl (1)",
                        "        bl_clr_fog (1)"
                };
        static char *c1[] =
                {
                        "        bl_a_in (1)",
                        "        bl_a_fog (1)",
                        "        bl_a_shade (1)",
                        "        bl_0 (1)"
                };
        static char *d1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)" 
                };
        static char *a2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)"
                };
        static char *b2[] =
                {
                        "        bl_clr_in (2)",
                        "        bl_clr_mem (2)",
                        "        bl_clr_bl (2)",
                        "        bl_clr_fog (2)"
                };
        static char *c2[] =
                {
                        "        bl_a_in (2)",
                        "        bl_a_fog (2)",
                        "        bl_a_shade (2)",
                        "        bl_0 (2)"
                };
        static char *d2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)" 
                };
	_u32 Len  = (rdp_reg.cmd0 & 0x0ff) + 1;
	_u32 Mode = 0x20 - (rdp_reg.cmd0>>8)&0xff - Len;
	_u32 Data = ((rdp_reg.cmd1 >> Mode) & ((1 << Len) - 1));

        switch(Mode)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_L ALPHACOMPARE: ");
                //PRINT_RDP("%s\n", ac[(rdp_reg.cmd1>>0x00) & 0x3]);

                rdp_reg.mode_l &= ~0x00000003;
                rdp_reg.cmd1   &=  0x00000003;
                rdp_reg.mode_l |=  rdp_reg.cmd1;

				if (rdp_reg.mode_l & 3)
				{
					glEnable(GL_ALPHA_TEST);
					glEnable(GL_BLEND);
				}
				else
				{
					glDisable(GL_ALPHA_TEST);
					glDisable(GL_BLEND);
				}
                break;

            case 0x02:
                //PRINT_RDP("SETOTHERMODE_L ZSRCSEL: ");
                //PRINT_RDP("%s\n", zs[(rdp_reg.cmd1>>0x02) & 0x1]);

                rdp_reg.mode_l &= ~0x00000004;
                rdp_reg.cmd1   &=  0x00000004;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x03:
                //PRINT_RDP("SETOTHERMODE_L RENDERMODE: ");
                /*PRINT_RDP("$%08lx:\n", rdp_reg.cmd1 & 0xfffffff8,
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n",
                        rdp_reg.cmd1 & 0xfffffff8,
                        (rdp_reg.cmd1 & 0x00000008) ? "        anti alias\n" : "",
                        (rdp_reg.cmd1 & 0x00000010) ? "        z_cmp\n" : "",
                        (rdp_reg.cmd1 & 0x00000020) ? "        z_upd\n" : "",
                        (rdp_reg.cmd1 & 0x00000040) ? "        im_rd\n" : "",
                        (rdp_reg.cmd1 & 0x00000080) ? "        clr_on_cvg\n" : "",
                        (rdp_reg.cmd1 & 0x00000100) ? "        cvg_dst_warp\n" : "",
                        (rdp_reg.cmd1 & 0x00000200) ? "        cvg_dst_full\n" : "",
                        (rdp_reg.cmd1 & 0x00000400) ? "        z_inter\n" : "",
                        (rdp_reg.cmd1 & 0x00000800) ? "        z_xlu\n" : "",
                        (rdp_reg.cmd1 & 0x00001000) ? "        cvg_x_alpha\n" : "",
                        (rdp_reg.cmd1 & 0x00002000) ? "        alpha_cvg_sel\n" : "",
                        (rdp_reg.cmd1 & 0x00004000) ? "        force_bl\n" : "",
                        (rdp_reg.cmd1 & 0x00008000) ? "        tex_edge?\n" : "",
                        a2[(rdp_reg.cmd1>>16) & 0x3],
                        a1[(rdp_reg.cmd1>>18) & 0x3],
                        b2[(rdp_reg.cmd1>>20) & 0x3],
                        b1[(rdp_reg.cmd1>>22) & 0x3],
                        c2[(rdp_reg.cmd1>>24) & 0x3],
                        c1[(rdp_reg.cmd1>>26) & 0x3],
                        d2[(rdp_reg.cmd1>>28) & 0x3],
                        d1[(rdp_reg.cmd1>>30) & 0x3]
                        );*/
                rdp_reg.mode_l &= ~0xfffffff8;
                rdp_reg.cmd1   &=  0xfffffff8;
                rdp_reg.mode_l |=  rdp_reg.cmd1;

//				if(rdp_reg.cmd1 & 0x00000008)
//					glEnable(GL_ALPHA_TEST);
//				else
//					glDisable(GL_ALPHA_TEST);
//				break;

				if(rdp_reg.cmd1 & 0x00000020)
					glDepthMask(GL_TRUE);
				else
					glDepthMask(GL_FALSE);
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_L BLENDER\n");
				break;

            default:
                //PRINT_RDP("SETOTHERMODE_L ?\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */


}

void rsp_uc04_setothermode_h()
{
        static char *ad[] = { "pattern", "notpattern", "noise", "disable" };
        static char *rd[] = { "magicsq", "bayer", "noise", "?" };
        static char *ck[] = { "none", "key" };
        static char *tc[] = { "conv", "?", "?", "?", "?", "filtconv", "filt", "?" };
        static char *tf[] = { "point", "?", "bilerp", "average" };
        static char *tt[] = { "none", "?", "rgba16", "ia16" };
        static char *tl[] = { "tile", "lod" };
        static char *td[] = { "clamp", "sharpen", "detail", "?" };
        static char *tp[] = { "none", "persp" };
        static char *ct[] = { "1cycle", "2cycle", "copy", "fill" };
        static char *cd[] = { "disable(hw>1)", "enable(hw>1)", "disable(hw1)", "enable(hw1)" };
        static char *pm[] = { "nprimitive", "1primitive" };

		_u32 Len  = (rdp_reg.cmd0 & 0x0ff) + 1;
		_u32 Mode = 0x20 - (rdp_reg.cmd0>>8)&0xff - Len;
		_u32 Data = ((rdp_reg.cmd1 >> Mode) & ((1 << Len) - 1));

        switch(Mode)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_H BLENDMASK - ignored\n");
                break;

            case 0x04:
                //PRINT_RDP("SETOTHERMODE_H ALPHADITHER: ");
                //PRINT_RDP("%s\n", ad[(rdp_reg.cmd1>>0x04) & 0x3]);
                rdp_reg.mode_h &= ~0x00000030;
                rdp_reg.cmd1   &=  0x00000030;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x06:
                //PRINT_RDP("SETOTHERMODE_H RGBDITHER: ");
                //PRINT_RDP("%s\n", rd[(rdp_reg.cmd1>>0x06) & 0x3]);
                rdp_reg.mode_h &= ~0x000000c0;
                rdp_reg.cmd1   &=  0x000000c0;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x08:
                //PRINT_RDP("SETOTHERMODE_H COMBINEKEY: ");
                //PRINT_RDP("%s\n", ck[(rdp_reg.cmd1>>0x08) & 0x1]);
                rdp_reg.mode_h &= ~0x00000100;
                rdp_reg.cmd1   &=  0x00000100;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x09:
                //PRINT_RDP("SETOTHERMODE_H TEXTURECONVERT: ");
                //PRINT_RDP("%s\n", tc[(rdp_reg.cmd1>>0x09) & 0x7]);
                rdp_reg.mode_h &= ~0x00000e00;
                rdp_reg.cmd1   &=  0x00000e00;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0c:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREFILTER: ");
                //PRINT_RDP("%s\n", tf[(rdp_reg.cmd1>>0x0c) & 0x3]);
                rdp_reg.mode_h &= ~0x00003000;
                rdp_reg.cmd1   &=  0x00003000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0e:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELUT: ");
                //PRINT_RDP("%s\n", tt[(rdp_reg.cmd1>>0x0e) & 0x3]);
                rdp_reg.mode_h &= ~0x0000c000;
                rdp_reg.cmd1   &=  0x0000c000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x10:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELOD: ");
                //PRINT_RDP("%s\n", tl[(rdp_reg.cmd1>>0x10) & 0x1]);
                rdp_reg.mode_h &= ~0x00010000;
                rdp_reg.cmd1   &=  0x00010000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x11:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREDETAIL: ");
                //PRINT_RDP("%s\n", td[(rdp_reg.cmd1>>0x11) & 0x3]);
                rdp_reg.mode_h &= ~0x00060000;
                rdp_reg.cmd1   &=  0x00060000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x13:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREPERSP: ");
                //PRINT_RDP("%s\n", tp[(rdp_reg.cmd1>>0x13) & 0x1]);
                rdp_reg.mode_h &= ~0x00080000;
                rdp_reg.cmd1   &=  0x00080000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x14:
                //PRINT_RDP("SETOTHERMODE_H CYCLETYPE: ");
                //PRINT_RDP("%s\n", ct[(rdp_reg.cmd1>>0x14) & 0x3]);
                rdp_reg.mode_h &= ~0x00300000;
                rdp_reg.cmd1   &=  0x00300000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_H COLORDITHER: ");
                //PRINT_RDP("%s\n", cd[(rdp_reg.cmd1>>0x16) & 0x1]);
                rdp_reg.mode_h &= ~0x00400000;
                rdp_reg.cmd1   &=  0x00400000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x17:
                //PRINT_RDP("SETOTHERMODE_H PIPELINEMODE: ");
                //PRINT_RDP("%s\n", pm[(rdp_reg.cmd1>>0x17) & 0x1]);
                rdp_reg.mode_h &= ~0x00800000;
                rdp_reg.cmd1   &=  0x00800000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            default:
                //PRINT_RDP("SETOTHERMODE_H\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */


}


