
#include "AudioOutput.h"
#include <stdio.h>
#include <string.h>

#include "MediaView.h"
#include "main.h"

#ifdef AUDIO_DEBUG
#undef DEBUG
#define DEBUG printf
#else
#undef DEBUG
#define DEBUG if (0) printf
#endif


#ifdef THREADED_AUDIO
#include <alloc.h>

status_t AudioReader(void *arg)
{
//	bool			update_trackTime;
	int64			frame_count;
	uint32			i, filled;
	status_t		err;
	register AudioOutput		*ao;
	media_header    mh;
	media_decode_info dec_info;
	dec_info.time_to_decode = 10;
	void *buffer;

//	update_trackTime = true;

	ao = (AudioOutput*)arg;

DEBUG("start AudioReader\n");

	while((err=acquire_sem(ao->decode_sem)) == B_NO_ERROR) {
//DEBUG("AudioReader got decode_sem\n");
		// FIXME
		buffer = ao->buff[ao->buff_next_decode];

		if (ao->isPlaying) {
			frame_count = 1;
			err = ao->track->ReadFrames((char*)buffer, &frame_count, &mh, &dec_info);
			if ((err != B_OK) || (frame_count < 0)) {
				memset((char*)buffer, ao->default_data, ao->buffer_size);
//				ao->update_trackTime = false;
/*
					if(settings->enable_divx_sync_hack) {
						puts("correcting audio");
						bigtime_t time;
						time = ao->view->CurrentTime();
						ao->track->SeekToTime(&time);
					}	
*/
			}
			else {
				filled = ao->frame_size * frame_count;
				if (filled < ao->buffer_size) {
					memset((char*)buffer+filled, ao->default_data, ao->buffer_size-filled);
/*					
					if(settings->enable_divx_sync_hack) {
						puts("correcting audio");
						bigtime_t time;
						time = ao->view->CurrentTime();
						ao->track->SeekToTime(&time);
					}	
*/
				}
				if (err != B_OK) {
//					ao->update_trackTime = false;
//					ao->endOfTrack = true;
				}
			}
			ao->bcount += filled;
//			printf("AU: err=%08X, filled=%ld buff=%ld frame=%lld\n", err, filled, ao->buffer_size, ao->track->CurrentFrame());
			ao->dbgTrackTime = mh.start_time;
			if (err != B_OK)
				ao->endOfTrack = true;
			ao->dbgAuStartTime = mh.start_time;
			ao->buff_next_decode = (ao->buff_next_decode+1) % NUM_AUDIO_BUFFERS;
		}
		
//		release_sem_etc(ao->read_sem, 1, B_DO_NOT_RESCHEDULE); // maybe it'll help
		release_sem(ao->read_sem);

	}
	
	DEBUG("stop AudioReader (err=%08lX)\n", err);
	return B_OK;
}
#endif

void AudioPlay(void *cookie, void *buffer, size_t bufferSize, const media_raw_audio_format &format)
{
//	bool			update_trackTime;
	int64			frame_count;
	uint32			i, filled;
	status_t		err;
	register AudioOutput		*ao;
	media_header    mh;
	media_decode_info dec_info;
	dec_info.time_to_decode = 0;

	ao = (AudioOutput*)cookie;
	ao->Lock();
	DEBUG("audio lock\n");
	ao->update_trackTime = true;

	if (ao->isPlaying) {
#ifndef THREADED_AUDIO
		err = ao->track->ReadFrames((char*)buffer, &frame_count, &mh, &dec_info);
		if ((err != B_OK) || (frame_count < 0)) {
//			ao->endOfTrack = true;
			memset((char*)buffer, ao->default_data, ao->buffer_size);
			ao->update_trackTime = false;
		}
		else {
			filled = ao->frame_size * frame_count;
			if (filled < ao->buffer_size)
				memset((char*)buffer+filled, ao->default_data, ao->buffer_size-filled);
			if (err != B_OK) {
//				ao->endOfTrack = true;
				ao->update_trackTime = false;
			}
		}
		if (err != B_OK)
			ao->endOfTrack = true;
#else //THREAD_AUDIO
		if(acquire_sem(ao->read_sem) != B_NO_ERROR) {
//			printf("AU:  __________SEM_ERROR frame=%lld\n", ao->track->CurrentFrame());
			return;
		}
//		DEBUG("AudioPlay got read_sem\n");

		memcpy((char *)buffer, ao->buff[ao->buff_next_read], ao->buffer_size);
		ao->buff_next_read = (ao->buff_next_read+1) % NUM_AUDIO_BUFFERS;
//		release_sem_etc(ao->decode_sem, 1, B_DO_NOT_RESCHEDULE);
		release_sem(ao->decode_sem);
//		printf("AU:  ___________________ frame=%lld\n", ao->track->CurrentFrame());
//		ao->update_trackTime = ao->update_trackTime;
#endif
		ao->scount++;
	}
	else {
		memset((char*)buffer, ao->default_data, ao->buffer_size);
		snooze(5000);
//		printf("AU:  ________NOT_PLAYING\n");
	}

	ao->perfTime = ao->player->PerformanceTime();
	if (ao->update_trackTime)
		ao->trackTime = ao->track->CurrentTime();
	else
		ao->trackTime +=
			(bigtime_t)(1e6*(float)bufferSize/((float)ao->frame_size*ao->frame_rate));


	ao->Unlock();

	if(ao->endOfTrack)
		ao->view->NotifyEndOfTrack(ao);
}

AudioOutput::AudioOutput(MediaView *view, MediaTrack *new_track, const char *name) : TrackPlayer(new_track) {
	media_format	format;
	this->view = view;
	
	lock_count = 0;
	if(new_track == NULL) {
		delete this;
		return;
	}
	lock_sem = create_sem(0, "audio_output ben");
#ifdef THREADED_AUDIO
	decode_sem = create_sem(0, "audio_output bD");
	read_sem = create_sem(0, "audio_output bR");
//	lock_sem = create_sem(0, "audio_output ben");
#endif

	
	track = new_track;
	isPlaying = false;
	perfTime = -1;
	perfTime = -1;
	trackTime = 0;
	scount=0;
	bcount=0;
	buff_next_decode = 0;
	buff_next_read = 0;
	endOfTrack=false;
	
	track->DecodedFormat(&format);
	switch (format.u.raw_audio.format) {
	case media_raw_audio_format::B_AUDIO_UCHAR :
		default_data = 0x80;
		frame_size = 1;
		break;
	case media_raw_audio_format::B_AUDIO_CHAR : // mmu
		default_data = 0x0;
		frame_size = 1;
		break;
	case media_raw_audio_format::B_AUDIO_SHORT :
		default_data = 0;
		frame_size = 2;
		break;
	case media_raw_audio_format::B_AUDIO_INT :
		default_data = 0;
		frame_size = 4;
		break;
	case media_raw_audio_format::B_AUDIO_FLOAT :
		default_data = 0;
		frame_size = 4;
		break;
	default :
		puts("unknown audio format !!!");
		player = NULL;
		return;
	}
	channelCount = format.u.raw_audio.channel_count;
	frame_size *= channelCount;
	buffer_size = format.u.raw_audio.buffer_size;
	frame_rate = format.u.raw_audio.frame_rate;


//buffer_size *=2;

	printf("AUDIO FORMAT: channelCount=%ld, frame_size=%ld, buffer_size=%ld, frame_rate=%f\n", channelCount, frame_size, buffer_size, frame_rate);
	printf("AUDIO FORMAT: flags=%d, %d \n", format.require_flags, format.deny_flags);

	player = new BSoundPlayer(&format.u.raw_audio, name, AudioPlay);
	if (player->InitCheck() != B_OK) {
		delete player;
		player = NULL;
	} else {
#ifdef THREADED_AUDIO
		int buff_cnt;
#ifdef USE_RTALLOC
		p_rtpool=NULL;
		if(B_OK!=rtm_create_pool(&p_rtpool, buffer_size * NUM_AUDIO_BUFFERS, "nplay au pool"))
			DEBUG("unable to get RT pool\n");
#endif
		for(buff_cnt=0; buff_cnt<NUM_AUDIO_BUFFERS; buff_cnt++) {
#ifdef USE_RTALLOC
			if(p_rtpool)
				buff[buff_cnt] = rtm_alloc(p_rtpool, buffer_size);
			else
				buff[buff_cnt] = malloc(buffer_size);
#else
			buff[buff_cnt] = malloc(buffer_size);
#endif
			if(buff[buff_cnt]==NULL)
				DEBUG("unable to malloc() audio buffer\n");
			memset((char*)buff[buff_cnt], default_data, buffer_size);
		}
		decode_thread = spawn_thread(AudioReader, "audio reader", PRIO_AUDIO_DECODE, this);
		// put a token so we can play :)
		resume_thread(decode_thread);
		DEBUG("decode thread setup\n");
		release_sem_etc(decode_sem, NUM_AUDIO_BUFFERS, 0);
#endif
		player->SetCookie(this);
		player->Start();
		player->SetHasData(true);
		
		//
//		player->Stop();
	}
}

AudioOutput::~AudioOutput() {
	if (player) {
		player->Stop();
#ifdef THREADED_AUDIO
		delete_sem(read_sem);
		delete_sem(decode_sem);
		status_t ret;
		wait_for_thread(decode_thread, &ret);
		int buff_cnt;
	
		for(buff_cnt=0; buff_cnt<NUM_AUDIO_BUFFERS; buff_cnt++) {
#ifdef USE_RTALLOC
			if(p_rtpool)
				rtm_free(buff[buff_cnt]); // crashed here during file switch
			else
				free(buff[buff_cnt]);
#else
			free(buff[buff_cnt]);
#endif
		}
#ifdef USE_RTALLOC
		rtm_delete_pool(p_rtpool);
#endif

#endif

	}
	delete player;
	delete_sem(lock_sem);

}

void AudioOutput::Lock() {
#ifdef THREADED_AUDIO
	int32 c;
#endif
	if (atomic_add(&lock_count, 1) > 0)
		acquire_sem(lock_sem);
#ifdef THREADED_AUDIO
//	while(B_OK==get_sem_count(decode_sem, &c) && c>0) snooze(5000);
#endif
}

void AudioOutput::Unlock() {
	if (atomic_add(&lock_count, -1) > 1)
		release_sem(lock_sem);
}

status_t AudioOutput::SeekToTime(bigtime_t *inout_time) {
	status_t	err;
	int64 dummy=1;
	int64 i,read_count; // number of frames to read
	media_header mh;

	bigtime_t the_time = *inout_time;
	Lock();
	endOfTrack = false;
	printf("au_time> = %ld\n", *inout_time);
	err = track->SeekToTime(inout_time);
	printf("au_time< = %ld\n", *inout_time);
	trackTime = *inout_time;
	if (track->ReadFrames((char *)buff[0], &dummy, &mh) != B_OK)
		return B_ERROR;
	printf("au_time< = %ld\n", *inout_time);

	if(trackTime == 0x8000000000000000LL && settings->enable_divx_seek_hack) {
	// Shitty DivX ;-) audio decoder...
		
		// hack
		// FIXME
//		bigtime_t	
//	track, 
		puts("divx audio seek... may take time");

		printf("frame_rate = %f\n", frame_rate);
		printf("the_time = %ld\n", the_time);
		printf("frame_size = %ld\n", frame_size);
		printf("buffer_size = %ld\n", buffer_size);
		read_count = (int64)(((frame_rate*the_time)/(float)(1000000LL)) * (float)(((float)frame_size) / (float)buffer_size));
		
		printf("read_count = %lld\n", read_count);
		for(i=0; i<read_count ;i++) {

			if (track->ReadFrames((char *)buff[0], &dummy, &mh) != B_OK)
				break;


//			aStartTime = mh.start_time;
//			if (dummy == 0)
//				break;
//			lastTime = aStartTime;
		}
		

		memset((char*)buff[buff_next_read], default_data, buffer_size);
		scount = i;
		
		*inout_time = i * (bigtime_t)((1000000LL)/frame_rate);
	}
	Unlock();
	return err;
}

status_t AudioOutput::Play() {
//	player->Start();
//	player->SetHasData(true);

	puts("START AUDIO");

	Lock();
	isPlaying = true;
	Unlock();
	return B_NO_ERROR;
}

status_t AudioOutput::Stop() {

// doesn't do what I expected
//	player->SetHasData(false);
//	player->Stop();
	puts("STOP AUDIO");
	isPlaying = false;
	return B_NO_ERROR;
}

bigtime_t AudioOutput::TrackTimebase() {
	printf("Au:TrackTimebase = %lld\n", perfTime - trackTime);
	return perfTime - trackTime;
}


bigtime_t AudioOutput::CurrentTime() const
{
	bigtime_t t;
	if(!track)
		return 0;
	t = track->CurrentTime();
/*	if(t != 0x8000000000000000LL)
		puts("normal time");
	else
		puts("divx time");
	printf("frame_rate = %f\n", frame_rate);
	printf("the_time = %lld\n", t);
	printf("trackTime = %lld\n", trackTime);
	printf("dbgTrackTime = %lld\n", dbgTrackTime);
	printf("frame_size = %ld\n", frame_size);
	printf("buffer_size = %ld\n", buffer_size);
*/
//	return trackTime;
	if(settings->enable_divx_sync_hack)
		return (bigtime_t)(((float)(bcount * 1000000LL)) / (frame_rate * frame_size));

#ifdef FORCE_DIVX_HACK_CURRTIME
	if(t != 0x8000000000000000LL)
#else
	if(t != 0x8000000000000000LL || !settings->enable_divx_seek_hack)
#endif
		return t;
	else
		return (bigtime_t)(((float)(scount * 1000000LL * buffer_size)) / (frame_rate * frame_size));
	
}

bool AudioOutput::EndOfTrack()
{
	return endOfTrack;
}
