#ifndef _AUDIO_OUTPUT_H
#define _AUDIO_OUTPUT_H

#include <SoundPlayer.h>
#include <OS.h>
#include "MediaTrack.h"
#include "TrackPlayer.h"
#include "config.h"
#include "RealtimeAlloc.h"

class MediaView;

class AudioOutput : public TrackPlayer {
public :
					AudioOutput(MediaView *view, MediaTrack *track, const char *name);
					~AudioOutput();
	status_t		InitCheck() { return ((player != NULL)?B_OK:B_ERROR); };
	MediaTrack		*Track() { return track; };
	status_t		SeekToTime(bigtime_t *inout_time);
	status_t		Play();
	status_t		Stop();
	bool			IsPlaying() { return isPlaying; };
	bigtime_t		TrackTimebase();

	bigtime_t		CurrentTime() const;
	bool			EndOfTrack();
	
	status_t		SetTo(MediaTrack *track) {return B_ERROR;}; // don't allow for now

	
private :
friend class MediaView; // for debugging only !!!
friend class MVLooper;
friend void AudioPlay(void *, void *, size_t, const media_raw_audio_format &);
friend status_t AudioReader(void *arg);
	void			Lock();
	void			Unlock();

	bool			isPlaying;
	int32			frameSize;
	int32			lock_count;
	int32			channelCount;
	int8			default_data;
	uint32			frame_size;
	float			frame_rate;
	uint32			buffer_size;
	sem_id			lock_sem;
	MediaTrack		*track;
	MediaView		*view;
	BSoundPlayer	*player;
	bigtime_t		perfTime, trackTime;
	
	bool			update_trackTime;
	
	bigtime_t		dbgAuStartTime, dbgTrackTime;
	
	int64			scount; // number of samples from the start (to calc CurrentTime() for DivX :-( )
	int64			bcount; // number of bytes read
	
	bool			endOfTrack;
//#ifndef THREADED_AUDIO
	void *buff[NUM_AUDIO_BUFFERS];
	rtm_pool *p_rtpool;
	int buff_next_read;
	int buff_next_decode;
	/*int buff_to_decode;
	int buff_to_read;*/
	sem_id decode_sem, read_sem, buff_lock;
	thread_id decode_thread;
	
	int delta;
//#endif
};

#endif
