/*
BMTrack class
it's a wrapper from MediaTrack to Be's BMediaTrack
*/

#include "BMTrack.h"

//debug
#include <stdio.h>

BMTrack::BMTrack(BMediaTrack *track)
{
	the_track = track;
}
BMTrack::~BMTrack()
{
	//	delete the_track;
	// BMediaTrack::~BMediaTrack() is protected
}

status_t
BMTrack::InitCheck() const
{
	return the_track->InitCheck();
}

status_t
BMTrack::GetCodecInfo(media_codec_info *mci) const
{
	return the_track->GetCodecInfo(mci);
}

status_t
BMTrack::EncodedFormat(media_format *out_format) const
{
	return the_track->EncodedFormat(out_format);
}

status_t
BMTrack::DecodedFormat(media_format *inout_format) const
{
	return the_track->DecodedFormat(inout_format);
}

BView *
BMTrack::GetParameterView()
{
	return the_track->GetParameterView();
}

int64
BMTrack::CountFrames() const
{
	return the_track->CountFrames();
}

bigtime_t
BMTrack::Duration() const
{
	return the_track->Duration();
}

int64
BMTrack::CurrentFrame() const
{
	return the_track->CurrentFrame();
}

bigtime_t
BMTrack::CurrentTime() const
{
	return the_track->CurrentTime();
}

status_t
BMTrack::ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh = NULL)
{
	return the_track->ReadFrames(out_buffer, out_frameCount, mh);
}

status_t
BMTrack::ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh, media_decode_info *info)
{
	return the_track->ReadFrames(out_buffer, out_frameCount, mh, info);
}

status_t
BMTrack::SeekToTime(bigtime_t *inout_time, int32 flags=0)
{
	return the_track->SeekToTime(inout_time, flags);
}

status_t
BMTrack::SeekToFrame(int64 *inout_frame, int32 flags=0)
{
	return the_track->SeekToFrame(inout_frame, flags=0);
}

status_t
BMTrack::FindKeyFrameForTime(bigtime_t *inout_time, int32 flags=0) const
{
	return the_track->FindKeyFrameForTime(inout_time, flags);
}

status_t
BMTrack::FindKeyFrameForFrame(int64 *inout_frame, int32 flags=0) const
{
	return the_track->FindKeyFrameForFrame(inout_frame, flags);
}

status_t
BMTrack::ReadChunk(char **out_buffer, int32 *out_size, media_header *mh = NULL)
{
	return the_track->ReadChunk(out_buffer, out_size, mh);
}


// for convenience
media_type
BMTrack::MediaType()
{
	media_format format;
	the_track->DecodedFormat(&format);
	return format.type;
}

BMediaTrack *
BMTrack::Track()
{
	return the_track;
}
