#ifndef BM_TRACK_H
#define BM_TRACK_H
/*
BMTrack class
it's a wrapper from MediaTrack to Be's BMediaTrack
*/

#include "MediaTrack.h"
#include <MediaTrack.h>
#include <SupportDefs.h>

class BMTrack : public MediaTrack
{
public:
	BMTrack(BMediaTrack *track);
protected:
	~BMTrack();
public:
	status_t	InitCheck() const;
	status_t	GetCodecInfo(media_codec_info *mci) const;
	status_t	EncodedFormat(media_format *out_format) const;
	status_t	DecodedFormat(media_format *inout_format) const;
	BView		*GetParameterView();
	int64	CountFrames() const;
	bigtime_t	Duration() const;
	int64	CurrentFrame() const;
	bigtime_t	CurrentTime() const;
	status_t	ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh = NULL);
	status_t	ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh, media_decode_info *info);
	status_t	SeekToTime(bigtime_t *inout_time, int32 flags=0);
	status_t	SeekToFrame(int64 *inout_frame, int32 flags=0);
	status_t	FindKeyFrameForTime(bigtime_t *inout_time, int32 flags=0) const;
	status_t	FindKeyFrameForFrame(int64 *inout_frame, int32 flags=0) const;
	status_t	ReadChunk(char **out_buffer, int32 *out_size, media_header *mh = NULL);
	media_type	MediaType();
	bool		IsLive() {return false;}; // maybe not always the case
	BMediaTrack	*Track(); // in case it doesn't suffice
private:
	BMediaTrack *the_track;
};

#endif // BM_TRACK_H
