/*
DoubleBufferOverlayRenderer class
*/
#include "DoubleBufferOverlayRenderer.h"
#include "colorspaces.h"
#include "MediaView.h"
#include <alloc.h>

#include <stdio.h>

// re-allocate the overlay on each frame (like MediaPlayer, does weird things on 
// my ATI RAGE PRO...)
//#define DISPOSE_ON_EACH_FRAME

DoubleBufferOverlayRenderer::DoubleBufferOverlayRenderer()
{
	bitmap = NULL;
	view = NULL;
	bitmapBounds = NULL;
	cs_index = -1;
	buffer = NULL;
}

DoubleBufferOverlayRenderer::~DoubleBufferOverlayRenderer()
{
	if(bitmap && view)
		Dispose();
}

const char *DoubleBufferOverlayRenderer::ColorSpaceName() const
{
	if(cs_index == -1)
		return "none";
	return colspace[cs_index].name;
}

color_space DoubleBufferOverlayRenderer::ColorSpace()
{
	if(cs_index == -1)
		return B_NO_COLOR_SPACE;
	return colspace[cs_index].colspace;
}

void *DoubleBufferOverlayRenderer::Bits()
{
	if(!bitmap)
		return NULL;
//	return bitmap->Bits();

	return buffer;
}

status_t DoubleBufferOverlayRenderer::LockBits()
{
#ifdef DISPOSE_ON_EACH_FRAME
	view->Picture()->Looper()->Lock();
	view->Picture()->ClearViewOverlay();
	view->Picture()->Looper()->Unlock();
#endif
	return B_OK;
}

status_t DoubleBufferOverlayRenderer::UnlockBits()
{
#ifdef DISPOSE_ON_EACH_FRAME
	rgb_color key;
	view->Picture()->Looper()->Lock();
	view->Picture()->SetViewOverlay(bitmap,*bitmapBounds,view->VideoBounds(),&key,B_FOLLOW_ALL,
			B_OVERLAY_FILTER_HORIZONTAL|B_OVERLAY_FILTER_VERTICAL);
	view->Picture()->SetViewColor(key);
	view->Picture()->Looper()->Unlock();
#endif
	return B_OK;
}
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
void *DoubleBufferOverlayRenderer::Draw(void *buff)
{
	if(!bitmap)
		return NULL;
/*
	bitmap->LockBits();
	bitmap->SetBits(buffer, bitmap->BitsLength(), 0, ColorSpace());
	bitmap->UnlockBits();
*/
//	return bitmap->Bits();
	bitmap->LockBits();
	memcpy(bitmap->Bits(), buffer, bitmap->BitsLength());
	bitmap->UnlockBits();
	return buffer;
}
	
status_t DoubleBufferOverlayRenderer::Install(MediaView *view, media_format *format)
{
	bool found = false;
	int i=0;
	
	if(!format)
		return B_ERROR;
	
	if(format->type != B_MEDIA_RAW_VIDEO/* && format->type != B_MEDIA_ENCODED_VIDEO*/)
		return B_ERROR;

	DUMP_FORMAT(format);
	
	for(i=0; !found && i<SUPP_OVL; i++)
		if(colspace[i].colspace == format->u.raw_video.display.format)
			found = true;
	
	if(!found)
		return B_ERROR;

	i--;
	cs_index = i;
	
	found = false;
	
/*	bitmapBounds = new BRect (0.0, 
						   0.0, 
						   format->u.encoded_video.output.display.line_width - 1.0,
						   format->u.encoded_video.output.display.line_count - 1.0);
*/
	bitmapBounds = new BRect (0.0, 
						   0.0, 
						   format->u.raw_video.display.line_width - 1.0,
						   format->u.raw_video.display.line_count - 1.0);

	bitmap = new BBitmap(*bitmapBounds,B_BITMAP_WILL_OVERLAY|B_BITMAP_RESERVE_OVERLAY_CHANNEL, colspace[cs_index].colspace);
	if(!bitmap || bitmap->InitCheck() != B_OK) {
		puts("not supported.");
		if(bitmap) delete bitmap;
		bitmap = NULL;
		return B_ERROR;
	}
	puts("supported.");

	// allocate the buffer
	buffer = (char *)malloc(bitmap->BitsLength());

	this->view = view;
	if(view->Window()->LockWithTimeout(50000) == B_OK) {
		view->Picture()->Invalidate(view->Picture()->Bounds());
		view->Invalidate(view->Bounds());
		view->Flush();
		view->Window()->Unlock();
	}
	return B_OK;
}

status_t DoubleBufferOverlayRenderer::Use()
{
	if(!view)
		return B_ERROR;
	
	overlay_restrictions r;
	bitmap->GetOverlayRestrictions(&r);
	printf("Using overlay: %s (%04X)\n", colspace[cs_index].name, colspace[cs_index]);

	printf("Overlay limits:\n");
	printf("  Src horiz alignment  : %08x\n",r.source.horizontal_alignment);
	printf("  Src vert alignment   : %08x\n",r.source.vertical_alignment);
	printf("  Src width alignment  : %08x\n",r.source.width_alignment);
	printf("  Src height alignment : %08x\n",r.source.height_alignment);
	printf("  Src min/max          : (%d,%d)/(%d,%d)\n",r.source.min_width,r.source.min_height,
														r.source.max_width,r.source.max_height);
	printf("  Dst horiz alignment  : %08x\n",r.destination.horizontal_alignment);
	printf("  Dst vert alignment   : %08x\n",r.destination.vertical_alignment);
	printf("  Dst width alignment  : %08x\n",r.destination.width_alignment);
	printf("  Dst height alignment : %08x\n",r.destination.height_alignment);
	printf("  Dst min/max          : (%d,%d)/(%d,%d)\n",r.destination.min_width,r.destination.min_height,
														r.destination.max_width,r.destination.max_height);
	printf("  Min/max scaling      : (%f,%f)/(%f,%f)\n",r.min_width_scale,r.min_height_scale,
														r.max_width_scale,r.max_height_scale);
	rgb_color key;
	if(view && view->Window()!=NULL && view->Window()->LockWithTimeout(50000) == B_OK) {
		view->Picture()->SetViewOverlay(bitmap,*bitmapBounds,view->VideoBounds(),&key,B_FOLLOW_ALL,
			B_OVERLAY_FILTER_HORIZONTAL|B_OVERLAY_FILTER_VERTICAL);
		view->Picture()->SetViewColor(key);
//#ifdef USE_SUBVIEW
		view->Picture()->Invalidate(view->Picture()->Bounds());
//#endif
		view->Invalidate(view->Bounds());
		view->Flush();
		view->Window()->Unlock();
	}
	return B_OK;
}

status_t DoubleBufferOverlayRenderer::Dispose()
{
	if(!bitmap)
		return B_ERROR;

	if(view && view->Window()!=NULL && view->Window()->Lock()) {
		view->Picture()->ClearViewOverlay();
		view->Picture()->SetViewColor(B_TRANSPARENT_32_BIT);
/*		if(view->Window()->Lock()) {
			view->Invalidate(view->Bounds());
			view->Flush();
			view->Window()->Unlock();
		}*/
		view->Window()->Unlock();
	}
//	bitmap->UnlockBits();
	if(bitmap)
		delete bitmap;
	bitmap = NULL;

	if(buffer)
		free(buffer);

	return B_OK;
}

color_space DoubleBufferOverlayRenderer::NextColorSpace(int *cookie) // cookie = 0 first
{
	if(*cookie >= SUPP_OVL)
		return B_NO_COLOR_SPACE;
	return colspace[(*cookie)++].colspace;
}

BRect DoubleBufferOverlayRenderer::Bounds()
{
	if(!bitmap)
		return BRect();
	return bitmap->Bounds();
}

int32 DoubleBufferOverlayRenderer::BytesPerRow()
{
	if(!bitmap)
		return 0;
	return bitmap->BytesPerRow();
}
