#ifndef DBL_OVERLAY_RENDERER_H
#define DBL_OVERLAY_RENDERER_H
/*
DoubleBufferOverlayRenderer class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Bitmap.h>
#include <GraphicsDefs.h>
#include "VideoRenderer.h"

class DoubleBufferOverlayRenderer : public VideoRenderer
{
public:
		DoubleBufferOverlayRenderer();
	virtual	~DoubleBufferOverlayRenderer();
	status_t	InitCheck() {return B_OK;};
//	const char	*RendererName() const {return "double buffered overlay";};
	const char	*RendererName() const {return "buffered overlay";};
	const char	*ColorSpaceName() const;
	color_space	ColorSpace();
	void		*Bits();
	status_t	LockBits();
	status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	void		*Draw(void *buff);
	
	status_t	Install(MediaView *view, media_format *format);
	status_t	Use();
	status_t	Dispose();
	color_space	NextColorSpace(int *cookie); // cookie = 0 first
	BRect		Bounds();
	int32		BytesPerRow();
private:

//	colorspace	cspace;
	int			cs_index; // index in colspace[]
	BBitmap		*bitmap;
	BRect		*bitmapBounds;
	MediaView	*view;
	
	char 		*buffer;
};


#endif // DBL_OVERLAY_RENDERER_H
