#ifndef MAGIC_OVERLAY_RENDERER_H
#define MAGIC_OVERLAY_RENDERER_H
/*
MagicOverlayRenderer class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Bitmap.h>
#include <GraphicsDefs.h>
#include "VideoRenderer.h"

#define DRAWER_PRIORITY 20

#define SIZEOF sizeof

#define INT32 int32

// blit using DrawBitmap instead ot overlay
// to test the convertion code (thanks pel on beshare)
#define TEST_MAGIC_OVERLAY

class MagicOverlayRenderer : public VideoRenderer
{
public:
		MagicOverlayRenderer();
	virtual	~MagicOverlayRenderer();
	status_t	InitCheck() {return B_OK;};
	const char	*RendererName() const {return "magic overlay";};
	const char	*ColorSpaceName() const;
	color_space	ColorSpace();
	void		*Bits();
	status_t	LockBits();
	status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	void		*Draw(void *buff);
	
	status_t	Install(MediaView *view, media_format *format);
	status_t	Use();
	status_t	Dispose();
	color_space	NextColorSpace(int *cookie); // cookie = 0 first
	BRect		Bounds();
	int32		BytesPerRow();

private:
	void		SetupYCbCr422Tables();
	status_t	TryColorSpace(MediaView * view, media_format * format, color_space cs);

	int			cs_index;
	BBitmap		*drawBitmap;
	BBitmap		*decodeBitmap;
	BRect		*drawBounds;
	BRect		*decodeBounds;
	MediaView	*view;
	
	int64		droppedframes;

// overlay adjustments
	uint32 horizOffset;
	uint32 horizPadding;
	uint32 vertOffset;
	uint32 vertPadding;


	// synchronization
	static int32	DrawerThreadRGB16(void * argument);
	static int32	DrawerThreadYCbCr422(void * argument);
	thread_id convertThreadId;
	sem_id	decodeSemaphore;
	sem_id	drawSemaphore;

// lookup tables
// use one table per lookup instead of one big table
	int32		*lt_r_y;
	int32		*lt_g_y;
	int32		*lt_b_y;
	int32		*lt_r_cb;
	int32		*lt_g_cb;
	int32		*lt_b_cb;
	int32		*lt_r_cr; // same as lt_b_cb
	int32		*lt_g_cr;
	int32		*lt_b_cr;

};


#endif // MAGIC_OVERLAY_RENDERER_H
