#ifndef _MEDIA_BAR_H
#define _MEDIA_BAR_H

#include <View.h>
#include <MediaDefs.h>
#include <Entry.h>

#include <Window.h>
#include "Bitmaps.h"
#include "MediaSlider.h"
#include "TransportButton.h"
#include "VolumeButton.h"

enum media_action {
	MEDIA_PLAY,
	MEDIA_STOP,
};

const uint32	msg_Stop = '_Mst';
const uint32	msg_PlayPause = '_Mpp';
//const uint32	msg_PlayPause = '_Mpp';

const float		kMediaBarInset 	= 1.0;
const float 	kMediaBarHeight	= kMediaBarInset + kPlayButtonSize.y + kMediaBarInset;

class MediaView;

class _MediaBar_ : public BView {
public:
					_MediaBar_(BRect frame, MediaView *owner);

	void			SetTotalTime(bigtime_t totalTime);
	void			SetCurTime(bigtime_t curTime);
	void			ActionUpdate(media_action action);

	virtual void	AttachedToWindow();
	virtual void	Draw(BRect updateRect);
	virtual void	MessageReceived(BMessage *message);

private:
	friend class MediaView;
	friend class MVLooper;
	MediaView*			fOwner;
	PlayPauseButton*	fPlayPauseButton;
	VolumeButton*		fVolButton;
	_MediaSlider_*		fMediaSlider;
};




#endif
