#ifndef _MEDIA_VIEW_H
#define _MEDIA_VIEW_H

#include <Looper.h>
#include <View.h>
#include <MediaDefs.h>
#include <Entry.h>

#include <Window.h>
#include <Looper.h>
#include "MediaBar.h"
#include "TimeSource.h"
#include "VideoRenderer.h"

#include "TrackPlayer.h"
//#include "VideoOutput.h"

#include "config.h"

#ifdef USE_SUBVIEW
#include "PictureView.h"
#endif

#include "TemplateList.h"

class BMediaFile;
class MediaTrack;
class AudioOutput;
class VideoOutput;
class _MediaBar_;
class BBitmap;

// will change later (tracklist)
#define FOR_EACH_TRACKPLAYER(__i,__p) for(__i=0, __p=fAudioOutput; __i<2; __p=((__i==0)?(fVideoOutput):(NULL)), __i++)
// DO check if p!=NULL !!!

class MediaView : public BView {
public:
					MediaView(BRect			frame, 
							  const char	*name,
							  uint32		resizeMask,
							  uint32		flags = B_WILL_DRAW | B_FRAME_EVENTS);
	virtual			~MediaView();

	status_t		SetMediaSource(const char *path);

	void			MessageReceived(BMessage *message);
	void			KeyDown(const char *bytes, int32 numBytes);

	status_t		SetColorSpace(color_space depth);
	color_space		ColorSpace() const;

	status_t		Control(media_action action);
	bool			IsPlaying() const;

	bool			HasVideoTrack() const;
	bool			HasAudioTrack() const;

	virtual void	GetPreferredSize(float *width, float *height);
	virtual void	Draw(BRect updateRect);
	virtual void	DetachedFromWindow();
	virtual void	FrameResized(float width, float height);
	virtual void	MouseDown(BPoint p);
	virtual void	Pulse();
	void 			SetFullScreen(bool fs);

	MediaTrack		*VideoTrack();
	MediaTrack		*AudioTrack();

	status_t		InstallBitmap(media_format *format);
	status_t		DisposeBitmap();

	PictureView		*Picture() const {return picture;};

	float			Volume();
	BRect			VideoBounds() const;

	status_t		SetTo(MediaTrack *track) {return B_ERROR;}
	MediaTrack		*Track() {return VideoTrack();};
	
	TList<VideoRenderer> *RendererList() const {return fRenderers;};
	VideoRenderer	*CurrentRenderer() const;
	bigtime_t		CurrentTime();
	bigtime_t		Duration();
	status_t		SeekToTime(bigtime_t *inout_time);
	bool			EndOfVideoTrack();
	bool			EndOfAudioTrack();
	void			NotifyEndOfTrack(TrackPlayer *which); // used from a TrackPlayer to tell that its track has ended.
	BLooper			*looper;

	status_t		Play();
	status_t		Stop();

	void			Reset();
	//volatile 
	TimeSource		*time_source;

private:
	void			InitObject();

	status_t		SetVideoTrack(const char *path, MediaTrack *track, media_format *format);
	status_t		SetAudioTrack(const char *path, MediaTrack *track, media_format *format);

	void			DispatchMessage(BMessage *msg, BHandler *target);
	
	
//	void			MessageReceived(BMessage *message);
	
//	static void		BuildMediaFormat(BBitmap *bitmap, media_format *format);

	static int32	MediaPlayer(void *arg);


private:
	friend class _MediaSlider_;
	friend class MVLooper;
	friend class PlayerPopup;
//	friend class VolumeButton;
//	friend class VideoRenderer; // doesn't work for subclasses ???

	BMediaFile*		fMediaFile;
	MediaTrack*		fVideoTrack;
	MediaTrack*		fAudioTrack;
	AudioOutput*	fAudioOutput;
	VideoOutput*	fVideoOutput;
	_MediaBar_*		fMediaBar;
	media_format	fCurrentFormat;
	BBitmap*		fBitmap;
	color_space		fBitmapDepth;
	bigtime_t		fCurTime;
	bigtime_t		fScrubTime;
	thread_id		fPlayerThread;
	sem_id			fPlaySem;
	sem_id			fScrubSem;
	bool			fPlaying;
	bool			fScrubbing;
	bool			fSnoozing;
	void*			fAudioDumpingBuffer;
	
	bool			fFullScreen;

	TList<VideoRenderer>	*fRenderers;

	bigtime_t		audio_frame, video_frame; // time for a video frame
	
#ifdef USE_SUBVIEW
	friend class PictureView;
	PictureView			*picture;
#endif
	
	// must be implemented differently
	bigtime_t		videoOffsetTime, audioOffsetTime;
	
/* //deprecated
	enum {
		TB_SYSTEM = 0,
		TB_AUDIO,
		TB_VIDEO
	};
*/	
//	int				timeBase; // deprecated
	TimeSource		*sys_time;
	
	bool			endOfVideoTrack;

};


#endif
