
#include <Window.h>
#include <Message.h>

#include "MediaView.h"
#include "PictureView.h"
#include "messages.h"
#include "VideoOutput.h"

PictureView::PictureView(
	MediaView *parent,
	BRect frame,
	const char	*name,
	uint32		resizeMask,
	uint32		flags)
		: BView(frame, name, resizeMask, flags)
{
	this->parent = parent;
}

PictureView::~PictureView()
{
	
}

void PictureView::Draw(BRect updateRect)
{
	if((parent == NULL) || (parent->IsPlaying()) || (!parent->fVideoOutput) || (!parent->fVideoOutput->RendererUsed()))
		return;
	parent->fVideoOutput->RendererUsed()->ReDraw();
}

void PictureView::MouseDown(BPoint p)
{
	BPoint where;
	
	BWindow *window = Window();	/*To handle the MouseDown message*/
	if (!window)	/*Check for proper instantiation*/
		return;
		
	BMessage *mouseMsg = window->CurrentMessage();
	if (!mouseMsg)	/*Check for existence*/
		return;
		

	if (mouseMsg->what == B_MOUSE_DOWN) {
		mouseMsg->FindPoint("where", &where);
		ConvertToParent(&where);
		mouseMsg->ReplacePoint("where", where);
		mouseMsg->what = MSG_POPUP;
		window->PostMessage(mouseMsg);
	}// else
//		BView::MouseDown(p);

}

