#include "PopupMenu.h"
#include "draw_window.h"
#include "messages.h"
#include "stdio.h"
#include "main.h"

PlayerPopup::PlayerPopup(PlayerWindow *p) : BPopUpMenu("popup menu", false, false)
{
	pwin = p;
	pwin->fPopupMenu=true;
	BMenu *tmpm;
	BMenuItem *tmpi;
//	fMenuBar = new BMenuBar(BRect(0,0,10000,20), "menubar");
	SetFont(be_plain_font);

	tmpm = new BMenu("File");
	tmpm->SetFont(be_plain_font);
//	tmpm->SetAsyncAutoDestruct(true);
	

	tmpi = new BMenuItem("Infos", new BMessage(MSG_OPEN_INFOVIEW));
	tmpi->SetTarget(NULL, pwin);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("Open", new BMessage(B_SILENT_RELAUNCH));
	tmpi->SetTarget(NULL, be_app);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("Close", new BMessage(MSG_CLOSE_WIN)/*, 'Q'*/);
	tmpi->SetTarget(NULL, pwin);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED)/*, 'Q'*/);
	tmpi->SetTarget(NULL, be_app);
	tmpm->AddItem(tmpi);
	
//	fMenuBar->AddItem(tmpm);
	tmpi = new BMenuItem(tmpm);
	AddItem(tmpi);
	AddSeparatorItem();

	tmpm = new BMenu("View");
	tmpm->SetFont(be_plain_font);
//	tmpm->SetAsyncAutoDestruct(true);

	tmpi = new BMenuItem("Always on Top", new BMessage(MSG_TOPMOST));
	tmpi->SetTarget(NULL, pwin);
	tmpi->SetMarked((pwin->Feel() & B_FLOATING_ALL_WINDOW_FEEL) != 0);
//	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
//		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);

	tmpm->AddSeparatorItem();

	tmpi = new BMenuItem("50%", new BMessage(MSG_SETZOOM_05));
	tmpi->SetTarget(NULL, pwin);
//	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
//		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("100%", new BMessage(MSG_SETZOOM_1));
	tmpi->SetTarget(NULL, pwin);
//	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
//		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("200%", new BMessage(MSG_SETZOOM_2));
	tmpi->SetTarget(NULL, pwin);
//	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
//		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);

	tmpi = new BMenuItem("300%", new BMessage(MSG_SETZOOM_3));
	tmpi->SetTarget(NULL, pwin);
//	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
//		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);

	tmpm->AddSeparatorItem();

	tmpi = new BMenuItem("Full Screen", new BMessage(MSG_SETZOOM_FST));
	tmpi->SetTarget(NULL, pwin);
	tmpi->SetMarked(pwin->FullScreen());
	tmpm->AddItem(tmpi);

//	fMenuBar->AddItem(tmpm);
	tmpi = new BMenuItem(tmpm);
	AddItem(tmpi);

	if(pwin->drawview->HasVideoTrack()) {
		tmpm = new BMenu("Draw");
		tmpm->SetFont(be_plain_font);
//		tmpm->SetAsyncAutoDestruct(true);

//		fMenuBar->AddItem(tmpm);
		tmpi = new BMenuItem(tmpm);
		AddItem(tmpi);
	
		for(int i = 0; i < pwin->drawview->RendererList()->CountItems(); i++) {
			BMessage *m;
			m = new BMessage(MSG_USE_RENDERER);
			m->AddPointer("renderer", pwin->drawview->RendererList()->ItemAt(i));
			tmpi = new BMenuItem(pwin->drawview->RendererList()->ItemAt(i)->RendererName(), m);
			tmpi->SetTarget(NULL, pwin);
			if(pwin->drawview->RendererList()->ItemAt(i) == pwin->drawview->CurrentRenderer()) {
				tmpi->SetMarked(true);
			}
			tmpm->AddItem(tmpi);
		}
	}
/*
	tmpi = new BMenuItem("DrawBitmap()", new BMessage(MSG_SETMODE_DRAWBITMAP));
	tmpi->SetTarget(NULL, pwin);
	if(pwin->drawview->ViewMode()==VIEW_DRAW_BITMAP)
		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);
	
	tmpi = new BMenuItem("BDirectWindow()", new BMessage(MSG_SETMODE_DIRECTWIN));
	tmpi->SetTarget(NULL, pwin);
	if(pwin->drawview->ViewMode()==VIEW_DIRECT_WINDOW)
		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);
	
	tmpi = new BMenuItem("Overlay", new BMessage(MSG_SETMODE_OVERLAY));
	tmpi->SetTarget(NULL, pwin);
	if(pwin->drawview->ViewMode()==VIEW_OVERLAY)
		tmpi->SetMarked(true);
	tmpm->AddItem(tmpi);
*/
	tmpm = new BMenu("TimeRef");
	tmpm->SetFont(be_plain_font);
//	tmpm->SetAsyncAutoDestruct(true);

//	fMenuBar->AddItem(tmpm);
	tmpi = new BMenuItem(tmpm);
	AddItem(tmpi);
	
	if(pwin->drawview->HasAudioTrack()) {
		BMessage *m;
		m = new BMessage(MSG_USE_TIMEREF);
		m->AddPointer("timeref", pwin->drawview->fAudioOutput);
		tmpi = new BMenuItem("audio", m);
		tmpi->SetTarget(NULL, pwin);
		if((TimeSource *)pwin->drawview->fAudioOutput == pwin->drawview->time_source) {
			tmpi->SetMarked(true);
		}
		tmpm->AddItem(tmpi);
//		delete m; ??
	}
	if(pwin->drawview->HasVideoTrack()) {
		BMessage *m;
		m = new BMessage(MSG_USE_TIMEREF);
		m->AddPointer("timeref", pwin->drawview->fVideoOutput);
		tmpi = new BMenuItem("video", m);
		tmpi->SetTarget(NULL, pwin);
		if((TimeSource *)pwin->drawview->fVideoOutput == pwin->drawview->time_source) {
			tmpi->SetMarked(true);
		}
		tmpm->AddItem(tmpi);
//		delete m; ??
	}
	if(true) {
		BMessage *m;
		m = new BMessage(MSG_USE_TIMEREF);
		m->AddPointer("timeref", pwin->drawview->sys_time);
		tmpi = new BMenuItem("system", m);
		tmpi->SetTarget(NULL, pwin);
		if(pwin->drawview->sys_time == pwin->drawview->time_source) {
			tmpi->SetMarked(true);
		}
		tmpm->AddItem(tmpi);
//		delete m; ??
	}

	tmpm = new BMenu("Setup");
	tmpm->SetFont(be_plain_font);
//	tmpm->SetAsyncAutoDestruct(true);
//	fMenuBar->AddItem(tmpm);
	AddSeparatorItem();
	tmpi = new BMenuItem(tmpm);
	AddItem(tmpi);

	tmpi = new BMenuItem("Player", new BMessage(MSG_OPEN_PLAYER_SETTINGS));
	tmpi->SetTarget(NULL, pwin);
	tmpm->AddItem(tmpi);
	
	if(pwin->drawview->HasAudioTrack()) {
		tmpi = new BMenuItem("Audio codec", new BMessage(MSG_OPEN_AU_CODEC_SETTINGS));
		tmpi->SetTarget(NULL, pwin);
		tmpm->AddItem(tmpi);
	}

	if(pwin->drawview->HasVideoTrack()) {
		tmpi = new BMenuItem("Video codec", new BMessage(MSG_OPEN_VID_CODEC_SETTINGS));
		tmpi->SetTarget(NULL, pwin);
		tmpm->AddItem(tmpi);
	}



	tmpm = new BMenu("Hacks");
	tmpm->SetFont(be_plain_font);
//	tmpm->SetAsyncAutoDestruct(true);
//	fMenuBar->AddItem(tmpm);
//	AddSeparatorItem();
	tmpi = new BMenuItem(tmpm);
	AddItem(tmpi);

	tmpi = new BMenuItem("DivX ;-) seek", new BMessage(MSG_EN_HACK_DIVX_SEEK));
	tmpi->SetTarget(NULL, pwin);
	if(settings->enable_divx_seek_hack) {
		tmpi->SetMarked(true);
	}
	tmpm->AddItem(tmpi);

//	tmpi = new BMenuItem("DivX ;-) audio sync", new BMessage(MSG_EN_HACK_DIVX_SYNC));
//	tmpi->SetTarget(NULL, pwin);
//	if(settings->enable_divx_sync_hack) {
//		tmpi->SetMarked(true);
//	}
//	tmpm->AddItem(tmpi);
/*	
	tmpi = new BMenuItem("Video codec", new BMessage(MSG_OPEN_VID_CODEC_SETTINGS));
	tmpi->SetTarget(NULL, pwin);
	tmpm->AddItem(tmpi);
*/


	SetTargetForItems(pwin);
	
	tmpi = new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED)/*, 'A'*/);
	tmpi->SetTarget(NULL, be_app);
//	tmpi->SetTarget(NULL, this);
	
//	fMenuBar->AddItem(tmpi);
	AddItem(tmpi);
	SetAsyncAutoDestruct(true);
	

}

PlayerPopup::~PlayerPopup()
{/*
	BMenu *p;
	int i;
	for(i=0;*/
	pwin->fPopupMenu=false;
}

