/*
SystemTime class
used if we want to assert a file to the real time instead of the audio
(in case it has no audio ;) )
*/

#include <OS.h>
#include "SystemTime.h"
#include <stdio.h>

#define DUMP printf("start_time = %lld current_time = %lld\n\n", start_time, current_time)

SystemTime::SystemTime()
{
	playing = false;
	start_time = system_time();
	current_time = 0;
//	puts("SystemTime::SystemTime()");
//	DUMP;
}

SystemTime::~SystemTime()
{
//	puts("SystemTime::~SystemTime()");
//	DUMP;
}

status_t SystemTime::Play()
{
	if(playing)
		return B_OK; //B_ERROR;
//	puts("SystemTime::Play()");
	start_time = system_time() - current_time;
	playing = true;
//	DUMP;
	return B_OK;
}

status_t SystemTime::Stop()
{
	if(!playing)
		return B_OK; //B_ERROR;
//	puts("SystemTime::Stop()");
	current_time = system_time() - start_time;
	playing = false;
//	DUMP;
	return B_OK;
}

bool SystemTime::IsPlaying()
{
//	puts("SystemTime::IsPlaying()");
	return playing;
}

bigtime_t SystemTime::CurrentTime() const
{
//	puts("SystemTime::CurrentTime()");
	if(!playing)
		return current_time;
//	DUMP;
	return system_time() - start_time;
}

status_t SystemTime::SeekToTime(bigtime_t *inout_time)
{
//	puts("SystemTime::SeekToTime()");
	// is it really safe ?
	current_time = *inout_time;
	start_time = system_time() - *inout_time;
//	DUMP;
	return B_OK;
}
