#include "VideoOutput.h"
#include "MediaSlider.h"
#include "TransportButton.h"
#include "Bitmaps.h"
#include "draw_window.h"
#include "messages.h"
#include "MediaFile.h"
#include "MediaTrack.h"
#include "AudioOutput.h"
#include "colorspaces.h"


// debug
#include <SoundPlayer.h>

#include <Autolock.h>
#include <Bitmap.h>
#include <ScrollBar.h>
#include <Screen.h>
#include <Path.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <InterfaceDefs.h>
#include <WindowScreen.h>

#include "config.h"
#ifdef USE_SUBVIEW
#include "PictureView.h"
#endif





VideoOutput::VideoOutput(
	MediaTrack		*track, 
	const char	*name,
	media_format    *format,
	MediaView	*view)
		: TrackPlayer(track)
{
	float		v_rate;
	status_t	err;

	DEBUG(">VideoOutput::VideoOutput()\n");	
	InitObject();
	if(track == NULL)
		return;
	the_track = track;
	if(format->type != B_MEDIA_RAW_VIDEO && format->type != B_MEDIA_ENCODED_VIDEO)
		return;
	the_view = view;

	DEBUG("|VideoOutput::VideoOutput()\n");	

	if(!format)
		return;
	if(format!=(&fCurrentFormat))
		memcpy(&fCurrentFormat, format, sizeof(media_format));
	track->DecodedFormat(&fDecodedFormat);
	
	//InstallBitmap(format);
	if(FindRenderer() != B_OK)
		return;

	DEBUG("|VideoOutput::VideoOutput()\n");	

	v_rate = format->u.encoded_video.output.field_rate;
	video_frame = (bigtime_t)(((float)1000000LL)/v_rate);
	
	media_header mh;
	bigtime_t time = fCurTime;	
	the_track->SeekToTime(&time);

	int64 dummyNumFrames = 0;

	renderer->LockBits();
	the_track->ReadFrames((char *)renderer->Bits(), &dummyNumFrames, &mh);
	renderer->UnlockBits();

	time = fCurTime;
	the_track->SeekToTime(&time);	

	DEBUG("|VideoOutput::VideoOutput()\n");	

	fPlayerThread = spawn_thread(VideoOutput::VideoPlayer, 
									 "VideoOutput::VideoPlayer",
									 B_NORMAL_PRIORITY,
									 this);

	if (fPlayerThread < B_NO_ERROR) {
		err = fPlayerThread;
		fPlayerThread = B_ERROR;
		Reset();

		return;
	}

	fPlaySem = create_sem(0, "VideoOutput::fPlaySem");
	if (fPlaySem < B_NO_ERROR) {
		err = fPlaySem;
		fPlaySem = B_ERROR;
		Reset();

		return;
	}

	DEBUG("|VideoOutput::VideoOutput()\n");	

	err = set_thread_priority(fPlayerThread, PRIO_VIDEO_DECODE);
	
	err = resume_thread(fPlayerThread);
	
	if (err != B_NO_ERROR) {
		kill_thread(fPlayerThread);
		fPlayerThread = B_ERROR;
		Reset();

		return;
	}
	DEBUG("<VideoOutput::VideoOutput()\n");
}


VideoOutput::~VideoOutput()
{
	Stop();
	Reset();
}

MediaTrack *VideoOutput::Track()
{
	return the_track;
}


status_t VideoOutput::TryRenderer(VideoRenderer *prenderer)
{
	int cookie;
	color_space cs;
	bool found = false;
	media_format mf, old_mf;

	bool playing;
	playing=IsPlaying();
	if(playing)
		Stop();

	if(prenderer == NULL)
		return B_ERROR;
	if(renderer == prenderer)
		return B_OK;
	if(renderer)
		renderer -> Dispose();
	renderer = prenderer;
	cookie = 0;
	// first try the durrent colorspace

	printf("trying renderer: %s\n", renderer->RendererName());

//	memcpy(&mf, &fCurrentFormat, sizeof(media_raw_video_format));
//	memcpy(&old_mf, &mf, sizeof(media_raw_video_format));

	if(fCurrentFormat.type==B_MEDIA_RAW_VIDEO)
		memcpy(&(mf.u.raw_video), &(fCurrentFormat.u.raw_video), sizeof(media_raw_video_format));
	else
		memcpy(&(mf.u.raw_video), &(fCurrentFormat.u.encoded_video.output), sizeof(media_raw_video_format));
	mf.type = B_MEDIA_RAW_VIDEO;
	memcpy(&old_mf, &mf, sizeof(media_format));

	if(mf.u.raw_video.display.format != B_NO_COLOR_SPACE && (renderer -> Install(the_view, &mf) == B_OK)) {
DEBUG("############ BBitmap(BRect(%f,%f,%f,%f), %08lX)\n", renderer->Bounds().left, renderer->Bounds().top, renderer->Bounds().right, renderer->Bounds().bottom, renderer->ColorSpace());
		printf("trying default colorspace: %04X\n", mf.u.raw_video.display.format);
		BuildMediaFormat(renderer, &mf);
		the_track->DecodedFormat(&mf);
		if (old_mf.u.raw_video.display.format == mf.u.raw_video.display.format) {
			found = true;
			renderer->Use();
		} else {
			printf("wanted cspace 0x%x, but it was reset to 0x%x\n", old_mf.u.raw_video.display.format, mf.u.raw_video.display.format);
			renderer->Dispose();
		}
	}
	while(!found && ((cs=renderer->NextColorSpace(&cookie)) != B_NO_COLOR_SPACE)) {
		mf.u.raw_video.display.format=cs;
		printf("trying colorspace: %04X\n", cs);
		memcpy(&old_mf, &mf, sizeof(media_format));
		if(renderer -> Install(the_view, &mf) == B_OK) {
DEBUG("############ BBitmap(BRect(%f,%f,%f,%f), %08lX)\n", renderer->Bounds().left, renderer->Bounds().top, renderer->Bounds().right, renderer->Bounds().bottom, renderer->ColorSpace());
//DEBUG("###BMBOUNDS= BRect(%f,%f,%f,%f)\n", fBitmap->Bounds().left, fBitmap->Bounds().top, fBitmap->Bounds().right, fBitmap->Bounds().bottom);

			BuildMediaFormat(renderer, &mf);
			the_track->DecodedFormat(&mf);
			if(old_mf.u.raw_video.display.format == mf.u.raw_video.display.format) {
				found = true;
				renderer->Use();
			} else {
				printf("wanted cspace 0x%x, but it was reset to 0x%x\n", old_mf.u.raw_video.display.format, mf.u.raw_video.display.format);
				renderer->Dispose(); // Thanks to BGA for pointing me to this lacking line :)
			}

		} else {
			printf("unable to install renderer\n");
			renderer->Dispose();
		}
	}
	if(!found) {
		renderer = NULL;
		return B_ERROR;
	}

	printf("using renderer: %s\n", renderer->RendererName());

	media_header mh;

//	bigtime_t time = fCurTime;
	bigtime_t time = CurrentTime();
	the_track->SeekToTime(&time);

	int64 dummyNumFrames = 0;
	renderer->LockBits();
	the_track->ReadFrames((char *)renderer->Bits(), &dummyNumFrames, &mh);
	renderer->UnlockBits();

//	time = CurrentTime();
	the_track->SeekToTime(&time);

	bits = renderer->Bits();

	puts("restart");
	
	if(playing)
		Play();

	
	return B_OK;
}

status_t VideoOutput::FindRenderer()
{
	int32 i;
	bool found = false;
	TList<VideoRenderer> *rlist;
	bool playing;
	playing=IsPlaying();
	if(playing)
		Stop();

	rlist = the_view->RendererList();
	if(renderer)
		renderer->Dispose();
		
	for(i=0; !found && i<rlist->CountItems(); i++) {
		found = (TryRenderer(rlist->ItemAt(i))==B_OK);
	}
	if(!found) {
		puts("unable to find suitable renderer !!!");
		return B_ERROR;
	}
	if(playing)
		Play();
	return B_OK;
}

/*
status_t
VideoOutput::SetColorSpace(
	color_space	depth)
{
	BAutolock autolock(Window());

	fBitmapDepth = depth;

	return (B_NO_ERROR);
}


color_space
VideoOutput::ColorSpace() const
{
	return (fBitmapDepth);
}

*/

bool
VideoOutput::IsPlaying() const
{
	return (fPlaying);
}




void
VideoOutput::InitObject()
{
	//BScreen screen;

	the_view = NULL;
	the_track = NULL;
	ref_time = NULL;
	
	fCurTime = 0;
	fScrubTime = 0; // remove ?
	fPlayerThread = B_ERROR;
	fPlaySem = B_ERROR;
	fScrubSem = B_ERROR;
	fPlaying = false;
	fSnoozing = false;
	renderer = NULL;
	video_frame=0;
	endOfVideoTrack=false;
	bits = NULL;
}


status_t VideoOutput::InitCheck()
{
	if(!the_track)
		return B_ERROR;
	return B_OK;
}



status_t
VideoOutput::Play()
{
	puts("play1");
	if (fPlaying)
		return (B_NO_ERROR);
	puts("play2");

	fPlaying = true;
	release_sem(fPlaySem);

	return (B_NO_ERROR);
}


status_t
VideoOutput::Stop()
{
	int32 c;
	
	if (!fPlaying)
		return (B_NO_ERROR);

	acquire_sem(fPlaySem);
	fPlaying = false;
	while(B_OK==get_sem_count(fPlaySem, &c) && c>=0) snooze(5000);

	return (B_NO_ERROR);
}


void
VideoOutput::Reset()
{
	delete_sem(fPlaySem);
	fPlaySem = B_ERROR;

	delete_sem(fScrubSem);
	fScrubSem = B_ERROR;

	status_t result = B_NO_ERROR;
	wait_for_thread(fPlayerThread, &result);
	fPlayerThread = B_ERROR;

	the_track = NULL;

	if(renderer)
		renderer->Dispose(); // DON'T DELETE !!!
	renderer = NULL;
}

BRect
VideoOutput::SourceBounds() const
{
	if(!renderer)
		return BRect();
	return (renderer->Bounds());
}


void
VideoOutput::BuildMediaFormat(
	VideoRenderer	*renderer,
	media_format	*format)
{
	media_raw_video_format *rvf = &format->u.raw_video;

	format->type = B_MEDIA_RAW_VIDEO;
//	memset(format, 0, sizeof(*format));
	memcpy(rvf, &media_raw_video_format::wildcard, sizeof(media_raw_video_format));

	BRect bitmapBounds = renderer->Bounds();

	rvf->last_active = (uint32)(bitmapBounds.Height() /*- 1.0*/);
	rvf->interlace = 1;
	rvf->orientation = B_VIDEO_TOP_LEFT_RIGHT;
	rvf->pixel_width_aspect = 1;
	rvf->pixel_height_aspect = 1;//3;
	rvf->display.format = renderer->ColorSpace();
//	rvf->display.format = B_RGB16;

	rvf->display.line_width = (int32)bitmapBounds.Width() + 1;
	rvf->display.line_count = (int32)bitmapBounds.Height() + 1;
	rvf->display.bytes_per_row = renderer->BytesPerRow();
//DBG	rvf->display.bytes_per_row = 640*3;
//	DEBUG("BPR=%ld\n", bitmap->BytesPerRow());
}

bigtime_t VideoOutput::CurrentTime() const
{
	if(!the_track)
		return 0;
	return the_track->CurrentTime();
}

bool VideoOutput::EndOfTrack() const
{
	return (the_track)?(endOfVideoTrack):(false);
}

status_t VideoOutput::SeekToTime(bigtime_t *inout_time)
{
	bool playing;
	bigtime_t time;
	status_t err;
	int64 dummy;
	media_header mh;
	int tries = 10;
	
	STOP_IF_PLAYING;
	if(!the_track)
		return B_ERROR;
	time = *inout_time;
	the_track->SeekToTime(&time);
	while((time < *inout_time - 10000) && (tries--)) { 
		time = *inout_time;
		DEBUG("                   K_ITER: From v:%f (%f)\n", ((float)((bigtime_t)(the_track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(*inout_time / 1000)) / 1000));
		the_track->SeekToTime(&time, B_MEDIA_SEEK_CLOSEST_FORWARD);
		DEBUG("                   K_ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(the_track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(*inout_time / 1000)) / 1000));

//		currentFrame = seekTime / video_frame;
	}

// just display something :-)
	renderer->LockBits();
	err = the_track->ReadFrames((char*)renderer->Bits(), &dummy, &mh);
	renderer->UnlockBits();

	the_track->SeekToTime(&time);

	*inout_time = time;
	
	START_IF_PLAYING;
	return B_OK;
}



//################# NEW

int32
VideoOutput::VideoPlayer(
	void	*arg)
{
	register VideoOutput		*vo = (VideoOutput *)arg;
	MediaView		*view = vo->the_view;
	MediaTrack		*track = vo->the_track;
	BWindow			*window = view->Window();
	//BBitmap*		bitmap = view->fBitmap;
	#define bitmap view->fBitmap
	bigtime_t		totalTime = view->Duration();	
//	int64			numFrames = counterTrack->CountFrames();
	int64			numFramesToSkip = 0;
	int64			numSkippedFrames = 0;
	bool			scrubbing = false;
	bool			seekNeeded = false;
	int64			dummy;
	media_header	mh;
	bigtime_t		vStartTime, aStartTime, seekTime, snoozeTime, startTime;
	bigtime_t		curScrubbing, lastScrubbing, lastTime;
	bigtime_t		NextWinUpdate; // when using overlay, just update the window every 0.2 s

	bigtime_t video_frame = vo->video_frame;
	int tries;
	media_decode_info dec_info;
	dec_info.time_to_decode = 0;
	
	//divx hack
	int64			currentFrame;
	currentFrame = 0;

	bigtime_t		time_to_decode = 0;  // kind of mean (=(old+last)/2)
	bigtime_t		decode_begin = 0;

	curScrubbing = lastScrubbing = system_time();
	seekTime = 0LL;
	
	
	bigtime_t debugNextTimeStamp;
	debugNextTimeStamp = system_time() + 500000;

	NextWinUpdate = system_time() + 200000;

DEBUG("############ Begin MediaPlayer thread\n");

	// Main processing loop (handle stop->start->stop)
	while (acquire_sem(vo->fPlaySem) == B_OK) {
		release_sem(vo->fPlaySem);
//DEBUG("############ sem\n");
		
		startTime = system_time() - view->CurrentTime();

// mmu: the end of the stream is NOT (counterTrack->CurrentFrame() >= numFrames), since numFrame is approx
// FIXME
		// This will loop until the end of the stream
//		while (((!errNoMoreFrames && (counterTrack->CurrentFrame() < numFrames)) || scrubbing)) {
//		DEBUG("CURR FRAME: %ld\n", counterTrack->CurrentFrame());
/*puts("tag");
if(view->EndOfAudioTrack())
	puts("eoat");
if(view->EndOfVideoTrack())
	puts("eovt");
*/
		while (/*view->fPlaying && */((!vo->EndOfTrack()/* && (videoTrack->CurrentFrame() < numFrames)*/)|| scrubbing)) {

			DEBUG("CURR FRAME: %lld real=%lld\n", track->CurrentFrame(), currentFrame);
//DEBUG("############ loop\n");

//mmu		
//			seekNeeded=false;
			
			// We are in scrub mode
/*			if (acquire_sem(view->fScrubSem) == B_OK) {
				curScrubbing = system_time();

				// We are entering scrub mode
				if (!scrubbing) {
					if (audioTrack != NULL)
						audioOutput->Stop();
					scrubbing = true;
				}
				// Do a seek.
				seekNeeded = true;
				seekTime = view->fScrubTime;
			}
			// We are not scrubbing
			else if (scrubbing) {
				if (audioTrack != NULL)
					audioOutput->Play();
				scrubbing = false;
			}
*/
			//mmu
			seekNeeded=false;
			// Handle seeking
//			DEBUG("TIMES: v:%f a:%f\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(audioOutput->CurrentTime() / 1000)) / 1000));
			if (seekNeeded) {
DEBUG("############ seek to %f\n", ((float)((bigtime_t)(seekTime / 1000)) / 1000));
/*				if (track) {
					DEBUG("############ seek video...\n");

					// Seek the seekTime as close as possible
					vStartTime = seekTime;
					track->SeekToTime(&vStartTime);
					while(vStartTime < seekTime - 1000000) { 
						vStartTime = seekTime;// = audioOutput->CurrentTime();
//						audioOutput->Stop();
						DEBUG("                   K_ITER: From v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
						track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_FORWARD);
						DEBUG("                   K_ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));

						currentFrame = seekTime / video_frame;

//						snoozeTime = (track->CurrentTime() - audioOutput->CurrentTime() - 500000);
//						snoozeTime = (snoozeTime > 0)?(snoozeTime):(5000);
//						snoozeTime = (snoozeTime > 3000000)?(3000000):(snoozeTime);
//						audioOutput->Play();
					}
					snoozeTime = 20000;

					DEBUG("############ seek video... (2)\n");
					// Read frames until we get less than 50ms ahead.
					lastTime = vStartTime;
					do {
						bitmap->LockBits();
						status_t err = track->ReadFrames((char*)bitmap->Bits(), &dummy, &mh);
						bitmap->UnlockBits();
						currentFrame++;
						if (err != B_OK) break;
						vStartTime = mh.start_time;
						if ((dummy == 0) || (vStartTime <= lastTime))
							break;
						lastTime = vStartTime;
					} while (seekTime - vStartTime > 50000);
				}
				
				if (audioTrack) {
					DEBUG("############ seek audio...\n");
					// Seek the extractor as close as possible
					aStartTime = seekTime;
					audioOutput->SeekToTime(&aStartTime);
					
					// Read frames until we get less than 50ms ahead.
					lastTime = aStartTime;
					while (seekTime - aStartTime > 50000) {
						if (audioTrack->ReadFrames((char *)adBuffer, &dummy, &mh) != B_OK)
							break;
						aStartTime = mh.start_time;
						if ((dummy == 0) || (aStartTime <= lastTime))
							break;
						lastTime = aStartTime;
					}
					DEBUG("############ seek done.\n");
				}
				else startTime = system_time() - vStartTime;
				
				// Set the current time
				view->fCurTime = seekTime;	
			
				seekNeeded = false;
*/			}		
			// Handle normal playing mode
			else {
//			DEBUG("TIMES: v:%f a:%f\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(audioOutput->CurrentTime() / 1000)) / 1000));
				// Get the next video frame, if any
				if (track != NULL) {
					
					decode_begin = system_time();
					
					vo->renderer->LockBits();
					status_t err = track->ReadFrames((char*)vo->renderer->Bits(), &dummy, &mh, &dec_info);
					vo->renderer->UnlockBits();
					currentFrame++;
//					if (err != B_OK) goto do_reset;
//					if (dummy == 0)
//						goto do_reset;
					if (err != B_OK) vo->endOfVideoTrack = true;
					if (dummy == 0)
						vo->endOfVideoTrack = true;
					vStartTime = mh.start_time;
					// Drawing by DirectWindow
//					if(view->fUsingDirectWin)
//						view->DDraw();
					
					// estimation
					time_to_decode+=(system_time() - decode_begin);
					time_to_decode/=2;

				}
//			DEBUG("TIMES: v:%f a:%f\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(audioOutput->CurrentTime() / 1000)) / 1000));

				// Estimated snoozeTime
				/*mmu*/ /*
				if (audioTrack != NULL)
					startTime = audioOutput->TrackTimebase();
				if (track != NULL)
					snoozeTime = vStartTime - (system_time() - startTime);
				else
					snoozeTime = 25000;
				*/
			
			
//			printf("timeref: %08lX\n", view->time_source);

//			bigtime_t testt;
//			testt = view->CurrentTime();
//			testt = ((TimeSource *)view->time_source)->CurrentTime();
			DEBUG("vStartTime=%f       (system_time() - startTime)=%f CurrentTime()=%f\n", ((float)((bigtime_t)(vStartTime / 1000)) / 1000), ((float)((bigtime_t)((system_time() - startTime) / 1000)) / 1000), ((float)((bigtime_t)((view->CurrentTime()) / 1000)) / 1000));
//			DEBUG("vStartTime=%f       (system_time() - startTime)=%f CurrentTime()=%f\n", ((float)((bigtime_t)(vStartTime / 1000)) / 1000), ((float)((bigtime_t)((system_time() - startTime) / 1000)) / 1000), ((float)((bigtime_t)((view->CurrentTime()) / 1000)) / 1000));
				
//				if (audioTrack != NULL)
//					startTime = audioOutput->TrackTimebase();
//(system_time() - startTime)
				if (track != NULL)
					snoozeTime = vStartTime - view->CurrentTime();
				else
					snoozeTime = 25000;

				snoozeTime -= time_to_decode; // so we won't be late every time...

//				if(snoozeTime < 0)
//					snoozeTime = 5000;

				tries=10;

				if(snoozeTime < - 50 * video_frame) {
					DEBUG("                                     sync lost: seeking video\n");
					// Seek the seekTime as close as possible
					bigtime_t seekTime;
					bigtime_t lastTime;
					seekTime = view->CurrentTime() - 5000;
					vStartTime = seekTime + 1000000;
					DEBUG("                     SEEK: From v:%f to v:%f (a:%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000), ((float)((bigtime_t)(view->CurrentTime() / 1000)) / 1000));
					if(seekTime - track->CurrentTime() > 200) {
						int f;
						track->SeekToTime(&vStartTime);
						while((tries--) && vStartTime < seekTime - 10000) { // we are on the previous keyframe, we have serious problems
							vStartTime = seekTime = view->CurrentTime();
//							audioOutput->Stop();
							DEBUG("                   K_ITER: From v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
							track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_FORWARD);
						currentFrame = seekTime / video_frame;
							DEBUG("                   K_ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
//							snoozeTime = (track->CurrentTime() - audioOutput->CurrentTime() - 500000);
//							snoozeTime = (snoozeTime > 0)?(snoozeTime):(5000);
//							snoozeTime = (snoozeTime > 3000000)?(3000000):(snoozeTime);
							snoozeTime = 20000;
//							audioOutput->Play();
						}
						tries=10;
						while((tries--) && (track->CurrentTime() - view->CurrentTime() > 2*video_frame)) {
							snooze(10000);
						}
					} else
						DEBUG("                                                    soft seek\n");
					
					seekTime = view->CurrentTime() - 5000;
					vStartTime = seekTime;
					/*
					// Read frames until we get less than 50ms ahead.
					lastTime = vStartTime;
					tries=0;
					do {
						int i=0;
						status_t err;
						DEBUG("                     ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
						vo->renderer->LockBits();
						for(i=0; i<5; i++)
							err = track->ReadFrames((char*)vo->renderer->Bits(), &dummy, &mh);
						vo->renderer->UnlockBits();
						if (err != B_OK) break;
						vStartTime = mh.start_time;
						if(dummy==0)
							puts("dummy == 0");
						if(vStartTime <= lastTime)
							puts("vStartTime <= lastTime");
//						if ((dummy == 0) || (vStartTime <= lastTime))
//							break;
						lastTime = vStartTime;
//						if(i++ > 10)
//							break; // give up
					
						if(tries++<10)
							seekTime = audioOutput->CurrentTime() - 5000;
					
					} while (seekTime - vStartTime > 50000);
					*/
					DEBUG("                   SEEKED: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
				

				} else {
					while(snoozeTime < - 5 * video_frame && tries--) {
//						dec_info.time_to_decode = 0;
						int tries = 0;
						status_t err;
						numSkippedFrames++;
						DEBUG(" SKIPPING\n");
						vo->renderer->LockBits();
						err = track->ReadFrames((char*)vo->renderer->Bits(), &dummy, &mh, &dec_info);
						vo->renderer->UnlockBits();
					currentFrame++;
						if (dummy == 0)
							vo->endOfVideoTrack = true;
						vStartTime = mh.start_time;
						snoozeTime += video_frame;
					}
				}
				
DEBUG("special case %f %f\n", ((float)((bigtime_t)((track?(track->CurrentTime()):(0)) / 1000)) / 1000), ((float)((bigtime_t)((view->CurrentTime()) / 1000)) / 1000));
/*
				if (track != NULL && audioTrack != NULL \
							&& track->CurrentTime() > 500000LL \
							&& audioOutput->CurrentTime() > 500000LL \
							&& (track->CurrentTime() > audioOutput->CurrentTime()+5000LL)) {
					DEBUG("special case (%lld)\n", snoozeTime);
					snoozeTime = (track->CurrentTime()-5000LL - audioOutput->CurrentTime());
					if(snoozeTime > 500000LL)
						snoozeTime= 500000LL;
				}
				if (track != NULL && audioTrack != NULL \
							&& track->CurrentTime() < 500000LL \
							&& audioOutput->CurrentTime() < 500000LL \
							&& snoozeTime > 500000LL)
					snoozeTime > 500000LL;
				
				if (track != NULL && audioTrack != NULL \
							&& track->CurrentTime() < 500000LL \
							&& audioOutput->CurrentTime() < 500000LL \
							&& snoozeTime > 500000LL)
					snoozeTime > 500000LL;

*/
/*
				if (track != NULL && audioTrack != NULL \
							&& track->CurrentTime() > 5000LL \
							&& audioOutput->CurrentTime() > 5000LL) {
					if((track->CurrentTime() < audioOutput->CurrentTime()-50000LL) \
								&& (track->CurrentTime() > audioOutput->CurrentTime()-500000LL)) {
						status_t err;
						numSkippedFrames++;
						DEBUG(" SKIPPING\n");
						vo->renderer->LockBits();
						err = track->ReadFrames((char*)vo->renderer->Bits(), &dummy, &mh);
						vo->renderer->UnlockBits();
						vStartTime = mh.start_time;
					}
					
					if(track->CurrentTime() < audioOutput->CurrentTime()-500000LL) {
						int tries=0;
						// seek the video
						DEBUG("                                     sync lost: seeking video\n");
						// Seek the seekTime as close as possible
						bigtime_t seekTime;
						bigtime_t lastTime;
						seekTime = audioOutput->CurrentTime() - 5000;
						vStartTime = seekTime;
						DEBUG("                     SEEK: From v:%f to v:%f (a:%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000), ((float)((bigtime_t)(audioTrack->CurrentTime() / 1000)) / 1000));
						if(seekTime - track->CurrentTime() > 2000000) {
							int f;
							track->SeekToTime(&vStartTime);
							while(vStartTime < seekTime - 10000) { // we are on the previous keyframe, we have serious problems
								vStartTime = seekTime = audioOutput->CurrentTime();
								audioOutput->Stop();
								DEBUG("                   K_ITER: From v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
								track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_FORWARD);
								DEBUG("                   K_ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
//								snoozeTime = (track->CurrentTime() - audioOutput->CurrentTime() - 500000);
//								snoozeTime = (snoozeTime > 0)?(snoozeTime):(5000);
//								snoozeTime = (snoozeTime > 3000000)?(3000000):(snoozeTime);
								snoozeTime = 20000;
								audioOutput->Play();
							}
							while(track->CurrentTime() - audioOutput->CurrentTime() > 50000) {
								snooze(10000);
							}
						} else
							DEBUG("                                                    soft seek\n");
						
						seekTime = audioOutput->CurrentTime() - 5000;
						vStartTime = seekTime;
						
						// Read frames until we get less than 50ms ahead.
						lastTime = vStartTime;
						tries=0;
						do {
							int i=0;
							status_t err;
							DEBUG("                     ITER: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
							vo->renderer->LockBits();
							for(i=0; i<5; i++)
								err = track->ReadFrames((char*)vo->renderer->Bits(), &dummy, &mh);
							vo->renderer->UnlockBits();
							if (err != B_OK) break;
							vStartTime = mh.start_time;
							if(dummy==0)
								puts("dummy == 0");
							if(vStartTime <= lastTime)
								puts("vStartTime <= lastTime");
//							if ((dummy == 0) || (vStartTime <= lastTime))
//								break;
							lastTime = vStartTime;
//							if(i++ > 10)
//								break; // give up
						
							if(tries++<10)
								seekTime = audioOutput->CurrentTime() - 5000;
						
						} while (seekTime - vStartTime > 50000);
						DEBUG("                   SEEKED: To   v:%f (%f)\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
					
					}
				}
				*/
				/*
				if(audioTrack != NULL)
					startTime = audioOutput->CurrentTime() + system_time();
				if (track != NULL)
					snoozeTime = vStartTime - (system_time() - startTime);
				else
					snoozeTime = 25000;
				*/
DEBUG("############ snooze time = (%lld)\n", snoozeTime-1000);

				// Handle timing issues
				if (snoozeTime > 5000LL) {
					vo->fSnoozing = true;
					/*mmu*/
//DEBUG("############ snooze(%lld)\n", snoozeTime-1000);
				/*	if(snoozeTime>50000) {
						snooze(50000);
					} else*/
					/*!mmu*/
					//mmu
					//snooze(snoozeTime-1000);
					
					// so we don't get stick if by mistake we sleep 10 minutes
					while(snoozeTime > SNOOZE_SLICE) {
						snooze(SNOOZE_SLICE);
						snoozeTime -= SNOOZE_SLICE;
						if(acquire_sem_etc(vo->fPlaySem, 1, B_TIMEOUT, 0) != B_OK) {
//							snoozeTime = 0LL;
//							break;
							goto do_restart;
						}
						release_sem(vo->fPlaySem);
					}
					if(snoozeTime > 5000LL)
						snooze(snoozeTime);
					//!mmu
					vo->fSnoozing = false;
				}
				else if (snoozeTime < -5000) {
					numSkippedFrames++;
					numFramesToSkip++;
				}
				
				// Set the current time
				if (!scrubbing) {
					vo->fCurTime = system_time() - startTime;
					if (vo->fCurTime < seekTime)
						vo->fCurTime = seekTime;
				}				
			}
			
			// Drawing by DirectWindow
/*			if(view->fUsingDirectWin)
				view->DDraw();
*/
			// Time tracking :-)
			
//			DEBUG("----------------------------Audio: %lld %lld  Video: %lld %lld\n", view->fAudioOutput->perfTime, view->fAudioOutput->trackTime, view->fCurTime, view->fScrubTime);

//			DEBUG("---------------------------------Audio: %lld %lld  Video: %lld %lld %lld %lld %lld %lld %lld %lld\n", view->fAudioOutput->perfTime, view->fAudioOutput->trackTime, vStartTime, aStartTime, seekTime, snoozeTime, startTime, curScrubbing, lastScrubbing, lastTime);
//			DEBUG("---------------------------------Audio: %llld %llld  Video: %llld %llld %llld %lldl %llld %llld %llld %llld\n", view->fAudioOutput->perfTime, view->fAudioOutput->trackTime, vStartTime, aStartTime, seekTime, snoozeTime, startTime, curScrubbing, lastScrubbing, lastTime);

//DEBUG STUFF
if(debugNextTimeStamp < system_time()) {
//	DEBUG("############ Current frame:%Ld, total frame:%Ld\n", counterTrack->CurrentFrame(), numFrames);
//	DEBUG("---------------------------------Audio: %lld %lld  Video: %lld %lld %lld %lld %lld %lld %lld %lld\n", view->fAudioOutput->perfTime, view->fAudioOutput->trackTime, vStartTime, aStartTime, seekTime, snoozeTime, startTime, curScrubbing, lastScrubbing, lastTime);
//	DEBUG("AUDIO : %lld	%lld\n", (audioTrack->CurrentTime()), view->fAudioOutput->perfTime);
//	DEBUG("VIDEO : %lld\n", (track->CurrentTime()));
//	DEBUG("AUDIO : %f	%f\n", (float)(((int)(audioTrack->CurrentTime() / 1000)) / 1000), (float)(((int)(view->fAudioOutput->perfTime) / 1000) / 1000));
//	DEBUG("AUDIO : %f	%f\n", (float)(((bigtime_t)(audioTrack->CurrentTime() / 1000)) / 1000), (float)(((bigtime_t)((audioTrack->CurrentTime()-system_time()) / 1000)) / 1000));
/*	if(audioTrack) {
		DEBUG("AUDIO : %f	%f\n", ((float)((bigtime_t)(view->fAudioOutput->dbgAuStartTime / 1000)) / 1000), ((float)((bigtime_t)((audioTrack->CurrentTime()) / 1000)) / 1000));

		DEBUG("AUDIO : %16llX %f\n", (view->fAudioOutput->dbgAuStartTime), ((float)((bigtime_t)(audioOutput->TrackTimebase() / 1000)) / 1000));
		DEBUG("AUDIO : %f	%f\n", ((float)((bigtime_t)(view->fAudioOutput->CurrentTime()) / 1000) / 1000), ((float)((bigtime_t)(system_time() / 1000)) / 1000));

		DEBUG("AUDIO : %f	%f\n", ((float)((bigtime_t)(view->fAudioOutput->player->CurrentTime()) / 1000) / 1000), ((float)((bigtime_t)(view->fAudioOutput->player->PerformanceTime()) / 1000) / 1000));
	}
*/	if(track) {
		DEBUG("VIDEO : %f	%f\n", ((float)((bigtime_t)(track->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(vStartTime / 1000)) / 1000));
//		DEBUG("VIDEO : %f	%f\n", ((float)((bigtime_t)((track->CurrentFrame() * totalTime / numFrames)/ 1000)) / 1000), ((float)((bigtime_t)(track->CurrentFrame()*video_frame / 1000)) / 1000));
	}
		DEBUG("TIMER : %f	%f\n", ((float)((bigtime_t)(view->CurrentTime() / 1000)) / 1000), ((float)((bigtime_t)(0 / 1000)) / 1000));
	debugNextTimeStamp = system_time() + 500000;
}

			// Handle the drawing : no drawing if we need to skip a frame...
			if (numSkippedFrames > 0/* && false *//*DEBUG*/) {
//				DEBUG("### SKIPPED FRAME\n");
				numSkippedFrames--;
			} else if (true) {
//				view->fMediaBar->SetCurTime(view->fCurTime);
//				view->fMediaBar->SetCurTime(view->CurrentTime());

				// draw this frame
				if(vo->renderer) {
					//vo->bits = 
					vo->renderer->Draw(vo->renderer->Bits());
				}
				// In scrub mode, don't scrub more than 10 times a second
				if(scrubbing) {
					snoozeTime = (100000LL+lastScrubbing) - system_time();
					if (snoozeTime > 4000LL) {
						vo->fSnoozing = true;
DEBUG("############ snooze2(%lld)\n", snoozeTime-1000LL);
						snooze(snoozeTime-1000LL);
						vo->fSnoozing = false;
					}
					lastScrubbing = curScrubbing;
				}

			}
//				DEBUG("couldn't aquire lock");
			
			// Check if we are required to stop.
			if (acquire_sem_etc(vo->fPlaySem, 1, B_TIMEOUT, 0) == B_OK)
				release_sem(vo->fPlaySem);
			// The VideoOutput asked us to stop.
			else {
//				if (audioTrack != NULL)
//					audioOutput->Stop();
				goto do_restart;
			}
//DEBUG("############ Current frame:%Ld, total frame:%Ld\n", counterTrack->CurrentFrame(), numFrames);
		}		

		// If we exited the main streaming loop because we are at the end,
		// then we need to loop.
//		if (counterTrack->CurrentFrame() >= numFrames/* && false do_loop*/) {
//		if (track->CurrentFrame() >= numFrames/* && false do_loop*/) {
		if ((vo->EndOfTrack()/* && false do_loop*/)/*
						&&(acquire_sem_etc(vo->fPlaySem, 1, B_TIMEOUT, 0) == B_OK)*//*WHERE is release_sem() ??? -- ok, it's here to stop playing ... I was asleep ;) -- better use view->Stop();*/) {
		puts("exited the main");
do_reset:
		puts("exited the main(2)");
			seekNeeded = false;
			seekTime = 0LL;
			scrubbing = false;

/*			if (audioTrack != NULL) {
				puts("stopping audio...");
				audioOutput->Stop();
				aStartTime = seekTime;
				audioOutput->SeekToTime(&aStartTime);
			}
*/

			if(track != NULL) {
				puts("stopping video...");
				vo->endOfVideoTrack = false;
				vStartTime = seekTime;
				track->SeekToTime(&vStartTime);	
//				track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_FORWARD);
//				track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_BACKWARD);

				int64 dummyNumFrames = 0;
//				track->SeekToFrame(&dummyNumFrames, B_MEDIA_SEEK_CLOSEST_BACKWARD);
//				track->SeekToFrame(&dummyNumFrames, B_MEDIA_SEEK_CLOSEST_FORWARD);
				track->SeekToFrame(&dummyNumFrames);

				currentFrame = 0;
//				track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_FORWARD);
//				track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_BACKWARD);

				vo->renderer->LockBits();
				track->ReadFrames((char *)vo->renderer->Bits(), &dummyNumFrames, &mh);
				vo->renderer->UnlockBits();

//				track->SeekToTime(&vStartTime, B_MEDIA_SEEK_CLOSEST_BACKWARD);
				track->SeekToTime(&vStartTime);	
			}
			puts("taking vid play sem...");
			vo->fPlaying = false;
			acquire_sem(vo->fPlaySem);
			puts("updating picture...");
			if(vo->renderer) {
				//vo->bits = 
				vo->renderer->Draw(vo->renderer->Bits());
			}
			view->NotifyEndOfTrack(vo);
		}
do_restart:;
	}

	return (B_NO_ERROR);
}
