/*
VideoRenderer virtual class
*/

#include "VideoRenderer.h"

VideoRenderer::VideoRenderer()
{
}

const char *VideoRenderer::ColorSpaceName() const
{
	return "none";
}

color_space VideoRenderer::ColorSpace()
{
	return B_NO_COLOR_SPACE;
}

void *VideoRenderer::Bits()
{
	return NULL;
}

status_t VideoRenderer::LockBits()
{
	return B_OK;
}

status_t VideoRenderer::UnlockBits()
{
	return B_OK;
}

	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
void *VideoRenderer::Draw(void *buff)
{
	return buff;
}

	// redraw last frame
	// this is used when the window needs to be redrawn
	// of course renderers which don't render in the window
	// or use overlay doesn't need to do anything
status_t VideoRenderer::ReDraw()
{
	return B_OK;
}

	
status_t VideoRenderer::Install(MediaView *view, media_format *format)
{
	return B_ERROR;
}

status_t VideoRenderer::Use()
{
	return B_ERROR;
}

status_t VideoRenderer::Dispose()
{
	return B_OK;
}

color_space VideoRenderer::NextColorSpace(int *cookie)
{
	return B_NO_COLOR_SPACE;
}

BRect VideoRenderer::Bounds()
{
	return BRect();
}

int32 VideoRenderer::BytesPerRow()
{
	return 0;
}


