#ifndef VIDEO_RENDERER_H
#define VIDEO_RENDERER_H
/*
VideoRenderer virtual class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Errors.h>
#include <Rect.h>

class MediaView;

class VideoRenderer
{
public:
		VideoRenderer();
	virtual	~VideoRenderer() {};
	virtual status_t	InitCheck() {return B_OK;};
	virtual const char	*RendererName() const{return "default renderer";};
	virtual const char	*ColorSpaceName() const;
	virtual color_space	ColorSpace();
	virtual void		*Bits();
	virtual status_t	LockBits();
	virtual status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	virtual	void		*Draw(void *buff);
	
	// redraw last frame
	// this is used when the window needs to be redrawn
	// of course renderers which don't render in the window
	// or use overlay doesn't need to do anything
	virtual status_t	ReDraw();
	
	virtual status_t	Install(MediaView *view, media_format *format); // try one
	virtual status_t	Use(); // this one we want to use
	virtual status_t	Dispose(); // get rid of it
	virtual color_space	NextColorSpace(int *cookie); // cookie = 0 first
	virtual BRect		Bounds();
	virtual int32		BytesPerRow();

};


#endif // VIDEO_RENDERER_H
