#include <Bitmap.h>
#include <Debug.h>
#include "messages.h"
//#include <MessageFilter.h>
#include <Screen.h>
#include <Message.h>
#include <map>
#include "Bitmaps.h"
#include "VolumeButton.h"
#include "TransportButton.h"
#include "DrawingTidbits.h"
#include "MediaView.h"

#define WIN_WIDTH 18
#define WIN_HEIGHT 100

#define WIN_VOL_OFF 10
#define WIN_VOL_H (WIN_HEIGHT - 2*WIN_VOL_OFF)
#define SLIDER_MARGIN 3
#define THUMB_W 6

//const rgb_color	kWhite = {255, 255, 255, 255};
//const rgb_color	kBlack = {0, 0, 0, 255};
const rgb_color	kSliderBackgroundColor = {173, 223, 165, 255};
const rgb_color	kSliderInsetDarkColor = {121, 157, 116, 255};
const rgb_color	kSliderInsetLightColor = {206, 236, 201, 255};
const rgb_color	kThumbBackgroundColor = {255, 0, 0, 255};
const rgb_color	kThumbDarkColor = {181, 0, 0, 255};
const rgb_color	kThumbLightColor = {255, 154, 156, 255};


class VolumeView : public BView
{
public:
	VolumeView(VolumeButton *b, BRect frame);
	virtual ~VolumeView();
	virtual void MouseDown(BPoint point);
	virtual void MouseMoved(BPoint point, uint32 transit, const BMessage *message);
 	virtual void MouseUp(BPoint point);
	void Draw(BRect updateRect);
	void Exit();
	float ToVolume(BPoint point);
private:
	VolumeButton *butt;
	float current_volume;
	bool sliding;
};

VolumeView::VolumeView(VolumeButton *b, BRect frame)
	: BView(frame, "vol", B_FOLLOW_ALL_SIDES, B_WILL_DRAW|B_FRAME_EVENTS)
{
	butt = b;
	sliding = false;
	current_volume = 0;
	if(b)
		current_volume = b->Volume();
}

VolumeView::~VolumeView()
{
	Exit();
}

void VolumeView::MouseDown(BPoint where)
{
	SetMouseEventMask(B_POINTER_EVENTS, B_LOCK_WINDOW_FOCUS);

	sliding = true;
}

void VolumeView::MouseMoved(BPoint point, uint32 transit, const BMessage *message)
{
//	if(!sliding)
//		return;
	current_volume = ToVolume(point);
	if(butt)
		butt->SetVolume(current_volume);
	Invalidate(Bounds());
	if(transit == B_EXITED_VIEW)
		Exit();
}
void VolumeView::MouseUp(BPoint point)
{
//	if(!sliding)
//		return;
	current_volume = ToVolume(point);
	Exit();
}

void VolumeView::Draw(BRect updateRect)
{
	BRect r = Bounds();
	BRect bounds = r;
	rgb_color viewColor = ViewColor();
	rgb_color dark = tint_color(viewColor, B_DARKEN_1_TINT);

	SetLowColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	FillRect(r, B_SOLID_LOW);
	BeginLineArray(6);

	AddLine(bounds.LeftBottom(), bounds.LeftTop(), kWhite);
	AddLine(bounds.LeftTop(), bounds.RightTop(), kWhite);
	AddLine(bounds.RightTop(), bounds.RightBottom(), kBlack);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), kBlack);

	bounds.InsetBy(-1.0, -1.0);

	AddLine(bounds.RightTop(), bounds.RightBottom(), dark);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), dark);
	EndLineArray();		

	r.left+=SLIDER_MARGIN-1;
	r.right-=SLIDER_MARGIN;
	r.top+=(int)(WIN_VOL_OFF-(THUMB_W/2)-1);
	r.bottom-=(int)(WIN_VOL_OFF-(THUMB_W/2)-1);
	bounds.SetLeftTop(r.LeftTop());
	bounds.SetRightBottom(r.RightBottom());
	
	SetLowColor(kSliderBackgroundColor);
	FillRect(r, B_SOLID_LOW);
	
	BeginLineArray(6);
	AddLine(bounds.LeftBottom(), bounds.LeftTop(), dark);
	AddLine(bounds.LeftTop(), bounds.RightTop(), dark);
	AddLine(bounds.RightTop(), bounds.RightBottom(), kWhite);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), kWhite);

	bounds.InsetBy(1.0, 1.0);

	AddLine(bounds.LeftBottom(), bounds.LeftTop(), kBlack);
	AddLine(bounds.LeftTop(), bounds.RightTop(), kBlack);
	EndLineArray();

	// update thumb

	r = Bounds();

	r.left+=SLIDER_MARGIN-1+1;
	r.right-=SLIDER_MARGIN+1;
	r.top+=(int)(WIN_VOL_OFF+(1-current_volume)*WIN_VOL_H-(THUMB_W/2));
	r.bottom-=WIN_VOL_OFF+WIN_VOL_H;
	r.bottom+=(int)((1-current_volume)*WIN_VOL_H+(THUMB_W/2));
	
	bounds = r;
	
	SetHighColor(kThumbBackgroundColor);
	FillRect(r, B_SOLID_HIGH);
	SetHighColor(kBlack);
	StrokeRect(r, B_SOLID_HIGH);
	r.InsetBy(1.0, 1.0);

	BeginLineArray(4);
	AddLine(r.RightTop(), r.RightBottom(), kThumbDarkColor);
	AddLine(r.RightBottom(), r.LeftBottom(), kThumbDarkColor);
	AddLine(r.LeftBottom(), r.LeftTop(), kThumbLightColor);
	AddLine(r.LeftTop(), r.RightTop(), kThumbLightColor);
	EndLineArray();	
//	r.InsetBy(1.0, 1.0);
/*
	BeginLineArray(6);

	AddLine(bounds.LeftBottom(), bounds.LeftTop(), kWhite);
	AddLine(bounds.LeftTop(), bounds.RightTop(), kWhite);
	AddLine(bounds.RightTop(), bounds.RightBottom(), kBlack);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), kBlack);

	bounds.InsetBy(-1.0, -1.0);

	AddLine(bounds.RightTop(), bounds.RightBottom(), dark);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), dark);
	EndLineArray();		
*/
}

float VolumeView::ToVolume(BPoint point)
{
	float v;
//	ConvertToScreen(&point);
/*
	v = (float)((Window()->Bounds().bottom - point.y)/WIN_HEIGHT);
	v = (v<0)?(0):((v>1)?(1):(v));
	*/
	v = (float)(1-((point.y-WIN_VOL_OFF)/WIN_VOL_H));
	if(point.y<WIN_VOL_OFF)
		v = 1;
	if(point.y>(WIN_VOL_H+WIN_VOL_OFF))
		v = 0;
//	printf("SetVolume = %f\n", v);
	return v;
}

void VolumeView::Exit()
{
	if(butt) {
		butt->SetVolume(current_volume);
		butt->volWindow = NULL;
	}
	sliding = false;
//	Window()->Quit();
	Window()->PostMessage(B_QUIT_REQUESTED);
	butt = NULL;
	return;
}

//#######################################################

VolumeButton::VolumeButton(BRect frame, const char *name,
	const unsigned char *normalBits, const unsigned char *pressedBits,
	const unsigned char *disabledBits, const unsigned char *mutedBits,
	BMessage *invokeMessage, bigtime_t period = 0, uint32 key = 0, uint32 modifiers = 0, uint32 resizeFlags = B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM)
//	BMessage *invokeMessage, uint32 key, uint32 modifiers, uint32 resizeFlags)
	:	BControl(frame, name, "", invokeMessage, resizeFlags, B_WILL_DRAW/* | B_NAVIGABLE*/),
/*	:	TransportButton(frame, name, normalBits, pressedBits,
			disabledBits, invokeMessage, 0,
			0, 0, 0, key, modifiers, resizeFlags),*/
		normalBits(normalBits),
		pressedBits(pressedBits),
		disabledBits(disabledBits),
		mutedBits(mutedBits),
		state(VolumeButton::kDisabled),
		lastModeMask(0),
		volume(0),
		muted(false)
{
	BRect bmrect(0, 0, kSpeakerIconBitmapWidth-1, kSpeakerIconBitmapHeight-1);

	volWindow = NULL;

	normalBitmap = new BBitmap(bmrect, B_COLOR_8_BIT);
	normalBitmap->SetBits(normalBits, (normalBitmap->Bounds().Width()+1)*(normalBitmap->Bounds().Height()+1), 0, B_COLOR_8_BIT);

	pressedBitmap = new BBitmap(bmrect, B_COLOR_8_BIT);
	pressedBitmap->SetBits(pressedBits, (pressedBitmap->Bounds().Width()+1)*(pressedBitmap->Bounds().Height()+1), 0, B_COLOR_8_BIT);

	disabledBitmap = new BBitmap(bmrect, B_COLOR_8_BIT);
	disabledBitmap->SetBits(disabledBits, (disabledBitmap->Bounds().Width()+1)*(disabledBitmap->Bounds().Height()+1), 0, B_COLOR_8_BIT);

	mutedBitmap = new BBitmap(bmrect, B_COLOR_8_BIT);
	mutedBitmap->SetBits(mutedBits, (mutedBitmap->Bounds().Width()+1)*(mutedBitmap->Bounds().Height()+1), 0, B_COLOR_8_BIT);

	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	bitmap = normalBitmap;
//	SetBits(disabledBits);
	SetVolume(0.75);
	SetState(kNoisy);
	SetEnabled(true);
//	SetViewColor(0,0,0);
}

VolumeButton::~VolumeButton()
{
	if(normalBitmap) delete normalBitmap;
	normalBitmap = NULL;
	if(pressedBitmap) delete pressedBitmap;
	pressedBitmap = NULL;
	if(disabledBitmap) delete disabledBitmap;
	disabledBitmap = NULL;
	if(mutedBitmap) delete mutedBitmap;
	mutedBitmap = NULL;
	if(volWindow) volWindow->PostMessage(B_QUIT_REQUESTED);
	volWindow = NULL;
}

void 
VolumeButton::AttachedToWindow()
{
	_inherited::AttachedToWindow();
	
	// transparent to reduce flicker
	if(Parent())
		ReplaceTransparentColor(normalBitmap, Parent()->ViewColor());
	if(Parent())
		ReplaceTransparentColor(pressedBitmap, Parent()->ViewColor());
	if(Parent())
		ReplaceTransparentColor(disabledBitmap, Parent()->ViewColor());
	if(Parent())
		ReplaceTransparentColor(mutedBitmap, Parent()->ViewColor());
	if(Parent())
		SetViewColor(Parent()->ViewColor());
	else
		SetViewColor(B_TRANSPARENT_COLOR);
}

void 
VolumeButton::DetachedFromWindow()
{
	_inherited::DetachedFromWindow();
}

void 
VolumeButton::WindowActivated(bool state)
{
	if (state)
		return;
//	if(volWindow) volWindow->PostMessage(B_QUIT_REQUESTED);
//	volWindow = NULL;
	_inherited::WindowActivated(state);
}

void VolumeButton::SetBits(const unsigned char *bits)
{
	bitmap->SetBits(bits, (bitmap->Bounds().Width()+1)*(bitmap->Bounds().Height()+1), 0, B_COLOR_8_BIT);
	if(Parent())
		ReplaceTransparentColor(bitmap, Parent()->ViewColor());
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	if(Parent())
		SetViewColor(Parent()->ViewColor());
		
	if(Parent())
		SetLowColor(Parent()->ViewColor());
		
}

void VolumeButton::SetState(VolState s)
{
	BWindow *w;
	const unsigned char *bits;
	switch(s) {
		case kDisabled:
			bitmap = disabledBitmap;
			break;
		case kPressed:
			bitmap = pressedBitmap;
			break;
		case kMuted:
			bitmap = mutedBitmap;
			break;
		case kNoisy:
			bitmap = normalBitmap;
			break;
		default:	
			bitmap = normalBitmap;
			break;
	}
	if((w=Window()) && w->Lock()) {
		Invalidate(Bounds());
		w->Unlock();
	}
//	SetBits(bits);
}

void 
VolumeButton::SetEnabled(bool on)
{
	SetState(on?(kNoisy):(kDisabled));
	_inherited::SetEnabled(on);
}

void 
VolumeButton::Draw(BRect r)
{
	if(Parent())
		SetLowColor(Parent()->ViewColor());
	else
		SetLowColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	FillRect(r, B_SOLID_LOW);

	DrawBitmap(bitmap, BPoint(0,(Bounds().bottom-kSpeakerIconBitmapHeight+2)/2));
}

void 
VolumeButton::MouseDown(BPoint p)
{
	if (!IsEnabled())
		return;
	if(volWindow)
		return;
	ConvertToScreen(&p);
	p+=(BPoint(-5,-5));
	VolumeView *v;
	BRect frame(0, 0, WIN_WIDTH-1, WIN_HEIGHT-1);
	v = new VolumeView(this, frame);
//	frame.OffsetBy(p);
	frame = Window()->Frame();
	frame.left = frame.right - WIN_WIDTH + 1;
	frame.top = frame.bottom - WIN_HEIGHT + 1;
	frame.OffsetBy(0,WIN_VOL_H*(Volume()));
//	volWindow = new BWindow(BRect(frame), "volume", B_NO_BORDER_WINDOW_LOOK, (window_feel)(B_MODAL_SUBSET_WINDOW_FEEL|B_FLOATING_SUBSET_WINDOW_FEEL), B_NOT_MOVABLE|B_NOT_ZOOMABLE|B_NOT_MINIMIZABLE|B_NOT_RESIZABLE|B_ASYNCHRONOUS_CONTROLS, B_CURRENT_WORKSPACE);
	volWindow = new BWindow(BRect(frame), "volume", B_NO_BORDER_WINDOW_LOOK, (window_feel)(B_FLOATING_ALL_WINDOW_FEEL), B_NOT_MOVABLE|B_NOT_ZOOMABLE|B_NOT_MINIMIZABLE|B_NOT_RESIZABLE|B_ASYNCHRONOUS_CONTROLS, B_CURRENT_WORKSPACE);
//	volWindow = new BWindow(BRect(frame), "volume", (window_type)0x0401, B_NOT_MOVABLE|B_NOT_ZOOMABLE|B_NOT_MINIMIZABLE|B_NOT_RESIZABLE|B_ASYNCHRONOUS_CONTROLS, B_CURRENT_WORKSPACE);
	volWindow->AddChild(v);
	volWindow->Show();
//	if(Window() && (Window()->Feel() & (B_FLOATING_ALL_WINDOW_FEEL)))
//		volWindow->SetFeel((window_feel)(/*volWindow->Feel() | */B_FLOATING_ALL_WINDOW_FEEL | B_MODAL_ALL_WINDOW_FEEL));
//	if(Window())
//		volWindow->AddToSubset(Window());
	if(Window())
		Window()->SendBehind(volWindow);
//	v->	SetMouseEventMask(B_POINTER_EVENTS, B_LOCK_WINDOW_FOCUS);

	
/*
	ASSERT(Window()->Flags() & B_ASYNCHRONOUS_CONTROLS);
	SetTracking(true);
	SetMouseEventMask(B_POINTER_EVENTS, B_LOCK_WINDOW_FOCUS);
	MouseStartPressing();
*/
}

void 
VolumeButton::MouseMoved(BPoint point, uint32 code, const BMessage *)
{
/*	if (IsTracking() && Bounds().Contains(point) != Value()) {
		if (!Value())
			MouseStartPressing();
		else
			MouseCancelPressing();
	}*/
}

void 
VolumeButton::MouseUp(BPoint point)
{
/*	if (IsTracking()) {
		if (Bounds().Contains(point))
			MouseDonePressing();
		else
			MouseCancelPressing();
		SetTracking(false);
	}*/
}

float VolumeButton::Volume()
{
	return volume;
/*	MediaView *v;
	v = (MediaView *)Parent();
	if(!v)
		return volume;
	return v->Volume();*/
}


void VolumeButton::SetVolume(float vol)
{
	volume = vol;
	BMessage *msg;
	if(IsEnabled()) {
		if(vol>=0.01)
			SetState(kNoisy);
		else
			SetState(kMuted);
	} else
		SetState(kDisabled);
	
	msg = new BMessage(MSG_SET_VOL);
	msg->AddFloat("to", vol);
	Window()->PostMessage(msg);
}

void VolumeButton::VolumeUp()
{
	float vol;
	vol = Volume();
	vol += 0.1;
	vol = (vol>1.0)?(1.0):(vol);
	SetVolume(vol);
}

void VolumeButton::VolumeDown()
{
	float vol;
	vol = Volume();
	vol -= 0.1;
	vol = (vol<0.0)?(0.0):(vol);
	if(vol<0.05)
		vol = 0.0;
	SetVolume(vol);
}

