#ifndef __VOL_MEDIA_BUTTON__
#define __VOL_MEDIA_BUTTON__

//#include "TransportButton"
#include <GraphicsDefs.h>
#include <Control.h>
#include <Window.h>
#include <View.h>

class BMessage;
class BBitmap;

#define VOL_AMOUNT (0.1)

class VolumeButton : public BControl {
public:
	VolumeButton(BRect frame, const char *name,
		const unsigned char *normalBits,
		const unsigned char *pressedBits,
		const unsigned char *disabledBits,
		const unsigned char *mutedBits,
		BMessage *invokeMessage,			// done pressing over button
//		BMessage *startPressingMessage = 0, // just clicked button
//		BMessage *pressingMessage = 0, 		// periodical still pressing
//		BMessage *donePressing = 0, 		// tracked out of button/didn't invoke
		bigtime_t period = 0,				// pressing message period
		uint32 key = 0,						// optional shortcut key
		uint32 modifiers = 0,				// optional shortcut key modifier
		uint32 resizeFlags = B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	
	virtual ~VolumeButton();
	
	virtual void SetEnabled(bool);
//	void SetMuted(bool muted);
	enum VolState {
		kDisabled,
		kPressed,
		kMuted,
		kNoisy,
	};
	
	void SetState(VolState s);
	void VolumeUp();
	void VolumeDown();
	void SetVolume(float vol); // 
	float Volume();
	
protected:
	friend class VolumeView;
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void Draw(BRect);
	virtual void MouseDown(BPoint point);
	virtual	void MouseMoved(BPoint point, uint32 transit, const BMessage *message);
	virtual	void MouseUp(BPoint point);
	virtual	void WindowActivated(bool);

	void SetBits(const unsigned char *bits);

private:
	const unsigned char *normalBits;
	const unsigned char *pressedBits;
	const unsigned char *disabledBits;
	const unsigned char *mutedBits;
	
	enum {
		kPlayingMask = 0x4,
		kPausedMask = 0x8
	};
	
	VolState state;
//	bigtime_t lastPauseBlinkTime;
	uint32 lastModeMask;
	
	float volume;
	bool muted;
	BBitmap *normalBitmap;
	BBitmap *pressedBitmap;
	BBitmap *disabledBitmap;
	BBitmap *mutedBitmap;
	BBitmap *bitmap;
	
	BWindow *volWindow;
	
	typedef BControl _inherited;
};

#endif
