/*

	
*/

#ifndef PLAYER_WINDOW_H
#define PLAYER_WINDOW_H

#include <Window.h>
#include "config.h"
#include <Menu.h>
#include <PopUpMenu.h>
#include <MenuBar.h>
#include <DirectWindow.h>
#include <Locker.h>
#include "MediaView.h"

#ifndef USE_DIRECT_WINDOW
class PlayerWindow : public BWindow {
#else
class PlayerWindow : public BDirectWindow {
#endif
public:
					PlayerWindow(BRect frame, const char *path); 
					~PlayerWindow();
	void			DirectConnected(direct_buffer_info *info);
	void			MessageReceived(BMessage *message);
	void			Zoom(BPoint origin, float width, float height);
	void			SetScale(int scale);
	bool			FullScreen();
	void			SetFullScreen(bool fs);
	void			DoPopupMenu();
	
	
	// Boolean flag to indicate when the display resolution has changed
	bool			m_displaychanged;

	bool connected;
	bool connection_disabled;
	BLocker *direct_lock;
	direct_buffer_info m_db_info;
//	uint32 m_current_workspace;
	BMenuBar	*fMenuBar;
	bool			fPopupMenu;
	MediaView	*drawview;
private:
	bool			fFullScreen;
	char *dw_mask; // the clipping mask for direct window
};


#endif //PLAYER_WINDOW_H
