/*
  A simple program that puts up a window with a BView in it so
  you can draw things.

  Dominic Giampaolo
  dbg@be.com
	
*/

#include "main.h"
#include "draw_window.h"
#include <FilePanel.h>
#include <Path.h>
#include <stdio.h>
#include <Alert.h>

int32 PlayerApp::sNumWindows = 0;

PlayerSettings	*settings;

PlayerApp::PlayerApp()
	: BApplication("application/x-vnd.mmu.MediaPlayer")
{
	fOpenPanel = NULL;
	settings = new PlayerSettings;
}


PlayerApp::~PlayerApp()
{
	if(fOpenPanel) delete (fOpenPanel);
	if(settings) delete settings;
}


void
PlayerApp::OpenOpenPanel()
{
	if (fOpenPanel != NULL)
		return;

	fOpenPanel = new BFilePanel();
	fOpenPanel->Window()->SetTitle("Select a media file to open:");
	fOpenPanel->Show();
}


void
PlayerApp::ReadyToRun()
{
	if (sNumWindows > 0)
		return;

	OpenOpenPanel();	
}


void
PlayerApp::ArgvReceived(
	int32	argc,
	char	**argv)
{
	for (int32 i = 1; i < argc; i++) {
		sNumWindows++;
		(new PlayerWindow(BRect(100.0, 100.0, 400.0, 400.0), argv[i]))->Show();
	}
}


void
PlayerApp::MessageReceived(
	BMessage	*message)
{
	switch (message->what) {
		case B_SILENT_RELAUNCH:
			OpenOpenPanel();
			break;

		case B_CANCEL:
			if (fOpenPanel != NULL) {
				delete (fOpenPanel);
				fOpenPanel = NULL;
				
				if (sNumWindows < 1)
					PostMessage(B_QUIT_REQUESTED);
			}
			break;

		case msg_WindowClosed:
			if (--sNumWindows < 1) {
				if (fOpenPanel == NULL)
					PostMessage(B_QUIT_REQUESTED);
				else
					sNumWindows = 0;
			}
			break;

		default:
			break;
	}
}


void
PlayerApp::RefsReceived(
	BMessage	*message)
{
	int32	count = 0;
	uint32	type = 0;
	message->GetInfo("refs", &type, &count);

	for (int32 i = 0; i < count; i++) {
		entry_ref	ref;

		if (message->FindRef("refs", i, &ref) == B_NO_ERROR) {
			BEntry entry(&ref);

			if (entry.InitCheck() == B_NO_ERROR) {
				BPath path;
				entry.GetPath(&path);

				sNumWindows++;
				(new PlayerWindow(BRect(100.0, 100.0, 400.0, 400.0), path.Path()))->Show();
			}
		}
	}
}

void PlayerApp::AboutRequested()
{
	BAlert *alert = new BAlert("title", "NiftyPlayer, (c) 2001, mmu_man\nBeOS is not dead !", "Ok", NULL, NULL,
		B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_INFO_ALERT);
	alert->SetShortcut(0, B_ENTER);
	int32 button_index = alert->Go();
}


int
main(int argc, char **argv)
{
	status_t  res;

	PlayerApp *app = new PlayerApp();
	app->Run();
	delete (app);
			
	return (B_NO_ERROR);
}
