#include "settings.h"
#include <File.h>
#include <alloc.h>

#include <stdio.h>

PlayerSettings::PlayerSettings() : BMessage(NPLAY_SETTINGS_MSG)
{
	char *pmsg;
	size_t fsz;
	
	puts("::PlayerSettings()");
	enable_overlay = false;
	enable_direct_win = false;
	enable_full_screen = false;
	enable_divx_seek_hack = false;
	enable_divx_sync_hack = false;
	need_save = false;
	
	BFile f(NPLAY_SETTING_FILE, B_READ_ONLY);
	if(f.InitCheck()!=B_OK) {
		SetDefaults();
		return;
	}
	if(B_OK!=f.GetSize((off_t *)&fsz)) {
		SetDefaults();
		return;
	}
	if(!(pmsg = (char *)malloc(fsz))) {
		SetDefaults();
		return;
	}
	if(B_OK!=f.Read(pmsg, fsz)) {
		free(pmsg);
		SetDefaults();
		return;
	}
	if(B_OK!=Unflatten(pmsg)) {
		free(pmsg);
		SetDefaults();
		return;
	}
	free(pmsg);
	
}

PlayerSettings::~PlayerSettings()	
{
	puts("::~PlayerSettings()");
	if(need_save)
		SaveNow();
}

void PlayerSettings::SaveNow()
{
	puts("PlayerSettings::SaveNow()");

	size_t fsz = FlattenedSize();
	char *pmsg;
	BFile f(NPLAY_SETTING_FILE, B_WRITE_ONLY|B_CREATE_FILE|B_ERASE_FILE);
	if(f.InitCheck()!=B_OK) {
		return;
	}
	if(!(pmsg = (char *)malloc(fsz))) {
		return;
	}

	if(B_OK!=Flatten(pmsg, fsz)) {
		free(pmsg);
		return;
	}
	if(B_OK!=f.Write(pmsg, fsz)) {
		free(pmsg);
		return;
	}
	
}

void PlayerSettings::SetDefaults()
{
	enable_overlay = false;
	enable_direct_win = false;
	enable_full_screen = false;
	enable_divx_seek_hack = false;
	enable_divx_sync_hack = false;

	AddBool(S_EN_OVERLAY, false);
	AddBool(S_EN_DIRECTWIN, false);
	AddBool(S_EN_FULLSCR, false);
}



void PlayerSettings::EnableOverlay(bool en)
{
	need_save = true;
	enable_overlay = en;
	ReplaceBool(S_EN_OVERLAY, en);
}

void PlayerSettings::EnableDirectWin(bool en)
{
	need_save = true;
	enable_direct_win = en;
	ReplaceBool(S_EN_DIRECTWIN, en);
}

void PlayerSettings::EnableFullScreen(bool en)
{
	need_save = true;
	enable_full_screen = en;
	ReplaceBool(S_EN_FULLSCR, en);
}


