#ifndef SETTINGS_H
#define SETTINGS_H

#include <Message.h>

#define NPLAY_SETTING_FILE "/boot/home/config/nplay.settings"

#define NPLAY_SETTINGS_MSG 'NPSM'

#define S_EN_OVERLAY "en_overlay"
#define S_EN_DIRECTWIN "en_directwin"
#define S_EN_FULLSCR "en_fullscr"

class PlayerSettings : public BMessage
{
	public:
		PlayerSettings();
		virtual ~PlayerSettings();
		void SaveNow();
		void SetDefaults();
		void EnableOverlay(bool en);
		void EnableDirectWin(bool en);
		void EnableFullScreen(bool en);

		// quick access
		
		// do we enable neat features ?
		bool enable_overlay;
		bool enable_direct_win;
		bool enable_full_screen;
		bool enable_divx_seek_hack;
		bool enable_divx_sync_hack;
		
	private:
		// has the settings changed and need to be saved ?
		bool need_save;
};

#endif //SETTINGS_H
