#ifndef DBLBUFF_RENDERER_H
#define DBLBUFF_RENDERER_H
/*
DoubleBufferRenderer class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Bitmap.h>
#include <GraphicsDefs.h>
#include <OS.h>
#include "VideoRenderer.h"

#define BM_DECODE 0
#define BM_DRAW 1

class DoubleBufferRenderer : public VideoRenderer
{
public:
		DoubleBufferRenderer();
	virtual	~DoubleBufferRenderer();
	status_t	InitCheck() {return B_OK;};
	const char	*RendererName() const {return "double buffered";};
	const char	*ColorSpaceName() const;
	color_space	ColorSpace();
	void		*Bits();
	status_t	LockBits();
	status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	void		*Draw(void *buff);
	
	// redraw last frame
	status_t	ReDraw();

	status_t	Install(MediaView *view, media_format *format);
	status_t	Use();
	status_t	Dispose();
	color_space	NextColorSpace(int *cookie); // cookie = 0 first
	BRect		Bounds();
	int32		BytesPerRow();
private:
	static int32	DrawerThread(void *arg);
	thread_id	drawer;
	sem_id		decode_sem, draw_sem;
	int			cs_index;
//	int			avail; // the bitmap available for decoding
//	int		to_draw; // the bitmap to draw
	BBitmap		*bitmap[2];
	long		bm_sz;
	BRect		*bitmapBounds;
	MediaView	*view;
	
	int64		droppedframes;
};


#endif // DBLBUFF_RENDERER_H
