#ifndef DRAWBITMAP_RENDERER_H
#define DRAWBITMAP_RENDERER_H
/*
DrawBitmapRenderer class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Bitmap.h>
#include <GraphicsDefs.h>
#include "VideoRenderer.h"

class DrawBitmapRenderer : public VideoRenderer
{
public:
		DrawBitmapRenderer();
	virtual	~DrawBitmapRenderer();
	status_t	InitCheck() {return B_OK;};
	const char	*RendererName() const {return "draw bitmap";};
	const char	*ColorSpaceName() const;
	color_space	ColorSpace();
	void		*Bits();
	status_t	LockBits();
	status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	void		*Draw(void *buff);
	
	// redraw last frame
	status_t	ReDraw();

	status_t	Install(MediaView *view, media_format *format);
	status_t	Use();
	status_t	Dispose();
	color_space	NextColorSpace(int *cookie); // cookie = 0 first
	BRect		Bounds();
	int32		BytesPerRow();
private:
	int			cs_index;
	BBitmap		*bitmap;
	BRect		*bitmapBounds;
	MediaView	*view;
};


#endif // DRAWBITMAP_RENDERER_H
