#include "MediaView.h"
#include "MediaSlider.h"
#include "TransportButton.h"
#include "Bitmaps.h"
#include "draw_window.h"

#include "MediaFile.h"
#include "MediaTrack.h"
#include "AudioOutput.h"

#include <Autolock.h>
#include <Bitmap.h>
#include <ScrollBar.h>
#include <Screen.h>
#include <Path.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>

#include "config.h"


_MediaBar_::_MediaBar_(
	BRect		frame,
	MediaView	*owner)
		: BView(frame, B_EMPTY_STRING, B_FOLLOW_BOTTOM | B_FOLLOW_LEFT_RIGHT, B_WILL_DRAW)
{
	fOwner = owner;

	BRect buttonRect, volRect;

	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

//	buttonRect.SetLeftTop(BPoint(kMediaBarInset, kMediaBarInset + 1.0));
	buttonRect.SetLeftTop(BPoint(kMediaBarInset, kMediaBarInset));
	buttonRect.SetRightBottom(buttonRect.LeftTop() + kPlayButtonSize);
	
	fPlayPauseButton = new PlayPauseButton(buttonRect,
										   B_EMPTY_STRING,
										   kPlayButtonBitmapBits, 
										   kPressedPlayButtonBitmapBits, 
										   kDisabledPlayButtonBitmapBits,
										   kPlayingPlayButtonBitmapBits, 
										   kPressedPlayingPlayButtonBitmapBits,
										   kPausedPlayButtonBitmapBits, 
										   kPressedPausedPlayButtonBitmapBits,
										   new BMessage(msg_PlayPause), 
										   ' ', 
										   0, 
										   B_FOLLOW_LEFT | B_FOLLOW_BOTTOM);
	AddChild(fPlayPauseButton);
	fPlayPauseButton->SetPaused();


	BRect sliderRect = Bounds();
	sliderRect.left = buttonRect.right;
	sliderRect.InsetBy(kMediaBarInset * 4, kMediaBarInset);
	sliderRect.right = /*volRect.left*/sliderRect.right - kSpeakerIconBitmapWidth;

	fMediaSlider = new _MediaSlider_(sliderRect, fOwner);
	AddChild(fMediaSlider);

	volRect.SetRightBottom(Bounds().RightBottom());
	volRect.right-=kMediaBarInset;
	volRect.bottom-=(2+kMediaBarInset);
//	volRect = Bounds();
//	volRect.right = frame.right - frame.left;
//	volRect.SetLeftTop(volRect.RightBottom() - kVolButtonSize);
	volRect.top+=kMediaBarInset;
	volRect.left=volRect.right - kVolButtonSize.x;
	fVolButton = new VolumeButton(volRect,
										   "vol",
										   kSpeakerNoisyIconBits, 
										   kSpeakerIconBits, 
										   kSpeakerIconBits,
										   kSpeakerMutedIconBits, 
										   new BMessage('vol_'), 
										   0,
										   's', 
										   0, 
										   B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);

	AddChild(fVolButton);
	fVolButton->SetState(VolumeButton::kNoisy);

}




void
_MediaBar_::SetTotalTime(
	bigtime_t	totalTime)
{
	fMediaSlider->SetTotalTime(totalTime);
}


void
_MediaBar_::SetCurTime(
	bigtime_t	curTime)
{
	fMediaSlider->SetCurTime(curTime);
}


void
_MediaBar_::ActionUpdate(
	media_action	action)
{
	switch (action) {
		case MEDIA_PLAY:
			fPlayPauseButton->SetPlaying();
			break;

		case MEDIA_STOP:
			fPlayPauseButton->SetPaused();
			break;

		default:
			break;
	}
}


void
_MediaBar_::AttachedToWindow()
{
	fPlayPauseButton->SetTarget(this);
}


void
_MediaBar_::Draw(
	BRect	updateRect)
{
	BRect		bounds = Bounds();
	rgb_color	viewColor = ViewColor();
	rgb_color	light = {255, 255, 255, 255};
	rgb_color	dark = tint_color(viewColor, B_DARKEN_3_TINT);

	BeginLineArray(4);
	AddLine(bounds.RightTop(), bounds.RightBottom(), dark);
	AddLine(bounds.RightBottom(), bounds.LeftBottom(), dark);
	AddLine(bounds.LeftBottom(), bounds.LeftTop(), light);
	AddLine(bounds.LeftTop(), bounds.RightTop(), light);
	EndLineArray();
}


void
_MediaBar_::MessageReceived(
	BMessage	*message)
{
	switch (message->what) {
		case msg_PlayPause:
			fOwner->Control((fOwner->IsPlaying()) ? MEDIA_STOP : MEDIA_PLAY);
			break;

		default:
			BView::MessageReceived(message);
			break;
	}
}

