#ifndef MEDIA_TRACK_H
#define MEDIA_TRACK_H
/*
MediaTrack class
mimics Be's BMediaTrack to ease creating BMTrack class (and coz it's nicely done)
*/

//#include "TimeSource.h"
#include <MediaTrack.h>
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <MediaFormats.h>
#include <View.h>

/*
#ifndef media_seek_type // from Be's MediaTrack.h
enum media_seek_type {
	B_MEDIA_SEEK_CLOSEST_FORWARD = 1,
	B_MEDIA_SEEK_CLOSEST_BACKWARD = 2,
	B_MEDIA_SEEK_DIRECTION_MASK = 3
};
#endif
*/

// the subtitles from a separate file
#define MEDIA_SUBTITLE B_MEDIA_FIRST_USER_TYPE+10

class MediaTrack// : public TimeSource
{
public:
	MediaTrack();
//protected:
	virtual ~MediaTrack();
public:
	virtual status_t	InitCheck() const;
	virtual status_t	GetCodecInfo(media_codec_info *mci) const;
	virtual status_t	EncodedFormat(media_format *out_format) const;
	virtual status_t	DecodedFormat(media_format *inout_format) const;
	virtual BView		*GetParameterView();
	virtual int64		CountFrames() const;
	virtual bigtime_t	Duration() const;
	virtual int64		CurrentFrame() const;
	virtual bigtime_t	CurrentTime() const;
	virtual status_t	ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh = NULL);
	virtual status_t	ReadFrames(void *out_buffer, int64 *out_frameCount, media_header *mh, media_decode_info *info);
//	virtual status_t	ReplaceFrames(const void *in_buffer, int64 *io_frameCount, const media_header *mh); // it's a player for now ;)
	virtual status_t	SeekToTime(bigtime_t *inout_time, int32 flags=0);
	virtual status_t	SeekToFrame(int64 *inout_frame, int32 flags=0);
	virtual status_t	FindKeyFrameForTime(bigtime_t *inout_time, int32 flags=0) const;
	virtual status_t	FindKeyFrameForFrame(int64 *inout_frame, int32 flags=0) const;
	virtual status_t	ReadChunk(char **out_buffer, int32 *out_size, media_header *mh = NULL);
	virtual media_type	MediaType();
	virtual bool		IsLive();
};
#endif // MEDIA_TRACK_H
