#ifndef OVERLAY_RENDERER_H
#define OVERLAY_RENDERER_H
/*
OverlayRenderer class
*/
#include <SupportDefs.h>
#include <MediaDefs.h>
#include <Bitmap.h>
#include <GraphicsDefs.h>
#include "VideoRenderer.h"

#define OVERLAY_LOCKS_BITS

#define OFFSET_PRIORITY 20

class OverlayRenderer : public VideoRenderer
{
public:
		OverlayRenderer();
	virtual	~OverlayRenderer();
	status_t	InitCheck() {return B_OK;};
	const char	*RendererName() const {return "overlay";};
	const char	*ColorSpaceName() const;
	color_space	ColorSpace();
	void		*Bits();
	status_t	LockBits();
	status_t	UnlockBits();
	
	// render the frame in buff, the next buffer to write to is returned (can be the same)
	// should block until the buffer returned is ready to be fulled
	void		*Draw(void *buff);
	
	status_t	Install(MediaView *view, media_format *format);
	status_t	Use();
	status_t	Dispose();
	color_space	NextColorSpace(int *cookie); // cookie = 0 first
	BRect		Bounds();
	int32		BytesPerRow();
private:
	status_t	TryColorSpace(MediaView * view, media_format * format, color_space cs);

//	colorspace	cspace;
	int			cs_index; // index in colspace[]
	BBitmap		*drawBitmap;
	BBitmap		*decodeBitmap;
	BRect		*drawBounds;
	BRect		*decodeBounds;
	MediaView	*view;
	
	// overlay adjustments
	uint32 horizOffset;
	uint32 horizPadding;
	uint32 vertOffset;
	uint32 vertPadding;
	
	// synchronization
	static int32	offset(void * argument);
	thread_id offsetThreadId;
	sem_id	decodeSemaphore;
	sem_id	drawSemaphore;
	
};


#endif // OVERLAY_RENDERER_H
