#ifndef SYSTEM_TIME_SOURCE_H
#define SYSTEM_TIME_SOURCE_H
/*
SystemTime class
used if we want to assert a file to the real time instead of the audio
(in case it has no audio ;) )
*/

#include "TimeSource.h"

class SystemTime : public TimeSource
{
public:
		SystemTime();
		~SystemTime();
	status_t	Play();
	status_t	Stop();
	bool		IsPlaying();
	bigtime_t	CurrentTime() const;
	status_t	SeekToTime(bigtime_t *inout_time);
private:
	bigtime_t	start_time; // stores the virtual time of the beginning of the track
	bigtime_t	current_time; // the time in the track (used when pausing)
	bool	playing;
};


#endif // SYSTEM_TIME_SOURCE_H
