#ifndef TRACK_PLAYER_H
#define TRACK_PLAYER_H
/*
TrackPlayer virtual class
*/

#include <SupportDefs.h>
#include "TimeSource.h"
#include "MediaTrack.h"

class TrackPlayer : public TimeSource
{
public:
		TrackPlayer(MediaTrack *track) {the_track = track;};
	virtual	~TrackPlayer() {};
	virtual status_t	InitCheck() const {return B_OK;};
	
	// change the track to play
	//(ie, for audio, change the channel
	// -> support for multi-language)
	virtual status_t	SetTo(MediaTrack *track) {/*return B_ERROR;*/the_track = track; return B_OK;};
	
	virtual MediaTrack	*Track() {return the_track;};
	virtual status_t	Play();
	virtual status_t	Stop();
	virtual bool		IsPlaying() const {return false;};
	virtual bigtime_t	CurrentTime() const {return the_track->CurrentTime();};
	virtual status_t	SeekToTime(bigtime_t *inout_time) {return the_track->SeekToTime(inout_time);};
	virtual bool		EndOfTrack() {return false;};
	virtual int64		DroppedFrames() {return 0;};
	virtual status_t	SetRefTimeSource(TimeSource *source) {ref_time = source; return B_OK;};
	virtual bigtime_t	Lag() const {return ref_time->CurrentTime() - CurrentTime();};
protected:
	MediaTrack		*the_track;
	TimeSource		*ref_time;
};


#endif // TRACK_PLAYER_H
