#ifndef VIDEO_OUTPUT_H
#define VIDEO_OUTPUT_H
/*
VideoOutput class
*/

#include "TrackPlayer.h"
#include "VideoRenderer.h"
#include "MediaTrack.h"
#include "MediaView.h"

#define STOP_IF_PLAYING ({playing = IsPlaying(); if(playing) Stop();})
#define START_IF_PLAYING ({if(playing) Play();})

class VideoOutput : public TrackPlayer
{
public:
		VideoOutput(MediaTrack *track, const char *name, media_format *format, MediaView *the_view);
		~VideoOutput();
	status_t	InitCheck();
	
	MediaTrack	*Track();
	status_t	Play();
	status_t	Stop();
	bool		IsPlaying() const;
	bigtime_t	CurrentTime() const;
	status_t	SeekToTime(bigtime_t *inout_time);
	bool		EndOfTrack() const;
	int64		DroppedFrames() const;
	status_t	SetRefTimeSource(TimeSource *source) {ref_time = source; return B_OK;};
	bigtime_t	Lag() const{ return ref_time->CurrentTime() - CurrentTime();};
	status_t	SetTo(MediaTrack *track) {return B_ERROR;}; // don't allow for now


	status_t	TryRenderer(VideoRenderer *renderer); // try this
	status_t	FindRenderer(); // find one yourself
	
	VideoRenderer	*RendererUsed() const {return renderer;};


	BRect			SourceBounds() const;

	static void		BuildMediaFormat(VideoRenderer *renderer, media_format *format);

	static int32	VideoPlayer(void *arg);

private:

	void			InitObject();
	void			Reset();
	
private:
friend class VideoRenderer;

	MediaView		*the_view;
	MediaTrack		*the_track;
	TimeSource		*ref_time;
	media_format	fCurrentFormat; // encoded
	media_format	fDecodedFormat;
//	BBitmap*		fBitmap;
//	color_space		fBitmapDepth;
//	BRect			*bitmapBounds;
	bigtime_t		fCurTime;
	bigtime_t		fScrubTime; // remove ?
	thread_id		fPlayerThread;
	sem_id			fPlaySem;
	sem_id			fScrubSem;
	bool			fPlaying;
	bool			fSnoozing;
	

	void			*bits;
	VideoRenderer	*renderer;

	bigtime_t		video_frame; // time for a video frame
	
	bool			endOfVideoTrack;



};


#endif // VIDEO_OUTPUT_H
