/*
	
	
*/
#include "Screen.h"
#include "draw_window.h"
#include <MenuItem.h>
#include "main.h"
#include "MediaView.h"
#include <Path.h>
#include "messages.h"
#include "MediaTrack.h"
//#include <MediaTrack.h>
#include "PopupMenu.h"

//DBG
#include <stdio.h>
#include <string.h>

PlayerWindow::PlayerWindow(
	BRect		frame, 
	const char	*path)
#ifndef USE_DIRECT_WINDOW
		: BWindow(frame, "Draw", B_TITLED_WINDOW, 0)
#else
		: BDirectWindow(frame, "Draw", B_TITLED_WINDOW, 0)
#endif
{
	SetTitle(strdup(BPath(path).Leaf()));

	
	connected = false;
	connection_disabled = false;
	m_displaychanged = false;
	fFullScreen=false;
	fPopupMenu = false;
	direct_lock = new BLocker("direct_lock");
	
	BRect bounds(0.0,0.0,Bounds().Width()+1.0,Bounds().Height()+1.0);
	drawview = new MediaView(bounds, "drawview", B_FOLLOW_ALL|B_PULSE_NEEDED);
	AddChild(drawview);

	//drawview->SetColorSpace(B_CMAP8);
	drawview->SetMediaSource(path);
	
	float w = 0.0;
	float h = 0.0;
	drawview->GetPreferredSize(&w, &h);	

	SetSizeLimits(80.0, 30000.0, (drawview->HasVideoTrack()) ? 80.0 : h, (drawview->HasVideoTrack()) ? 30000.0 : h);
	
//	SetZoomLimits(w, h);
	ResizeTo(w, h);

//	SetPulseRate(15000000);
	SetPulseRate(300000);
	drawview->MakeFocus(true);
	drawview->Control(MEDIA_PLAY);
}


PlayerWindow::~PlayerWindow()
{
	connected = false;
	connection_disabled=true;
	direct_lock->Unlock();
	delete direct_lock;
	drawview->Reset();
	be_app->PostMessage(msg_WindowClosed);
}

// try to be quick here, we don't want to lock the app_server ;-)
void PlayerWindow::DirectConnected(direct_buffer_info *info)
{
	if (!connected && connection_disabled) return;
	direct_lock->Lock();
	switch (info->buffer_state & B_DIRECT_MODE_MASK)
	{
	case B_DIRECT_START :
//		puts("B_DIRECT_START");
//		dw_mask = malloc();
		connected = true;
		memcpy(&m_db_info, info, sizeof(direct_buffer_info));
		m_displaychanged = true;
		break;
		
	case B_DIRECT_STOP :
//		puts("B_DIRECT_STOP");
		m_displaychanged = true;
		connected = false;
		break;
		
	case B_DIRECT_MODIFY :
//		puts("B_DIRECT_MODIFY");
		memcpy(&m_db_info, info, sizeof(direct_buffer_info));
		m_displaychanged = true;
		break;
	}
	
	// calculate dw_mask
	switch (info->buffer_state & B_DIRECT_MODE_MASK)
	{
	case B_DIRECT_START :
	case B_DIRECT_MODIFY :
		break;
	}
	
	direct_lock->Unlock();

}

void PlayerWindow::MessageReceived(BMessage *message)
{
	switch (message->what) {
		case MSG_POPUP:
			{
				/*Variables for storing the button pressed / modifying key*/
				uint32 	buttons = 0;
				uint32  modifiers = 0;
				BPoint where(10,10);
				/*Get the button pressed*/
				message->FindInt32("buttons", (int32 *) &buttons);
				/*Get modifier key (if any)*/
				message->FindInt32("modifiers", (int32 *) &modifiers);

				message->FindPoint("where", &where);
			
				/*Now perform action*/
	
				switch(buttons) {
					case B_PRIMARY_MOUSE_BUTTON:
						// pause
						if(FullScreen())
							SetFullScreen(false);
						else {
							message->what = B_MOUSE_DOWN;
#ifdef USE_DIRECT_WINDOW
							return BDirectWindow::MessageReceived(message);
#else
							return BWindow::MessageReceived(message);
#endif
						}
						break;
					case B_SECONDARY_MOUSE_BUTTON: 
					{
						ConvertToScreen(&where);
						if(fPopupMenu)
							break;
						//menu will delete itself (see constructor of ConfigMenu),
						//so all we're concerned about is calling Go() asynchronously
						//ConfigMenu *menu = new ConfigMenu(this, _useMag);
						PlayerPopup *p = new PlayerPopup(this);
						where.x-=1;
						where.y-=1;
						p->Go(where, true, true, BRect(0,0,-1,-1)/*ConvertToScreen(Bounds())*/, true); 
						p=NULL;
						//delete p;
						break;
					}
				}
			}
			break;
		case MSG_SETZOOM_05:
			SetFullScreen(false);
			SetScale(0);
			break;
		case MSG_SETZOOM_1:
			SetFullScreen(false);
			SetScale(1);
			break;
		case MSG_SETZOOM_2:
			SetFullScreen(false);
			SetScale(2);
			break;
		case MSG_SETZOOM_3:
			SetFullScreen(false);
			SetScale(3);
			break;
		case MSG_SETZOOM_FS:
			SetFullScreen(true);
			break;
		case MSG_SETZOOM_FST:
			SetFullScreen(!FullScreen());
			break;
		case MSG_TOPMOST:
			SetFeel((window_feel)((Feel() & (~B_FLOATING_ALL_WINDOW_FEEL)) | (Feel() & (B_FLOATING_ALL_WINDOW_FEEL))?(0):(B_FLOATING_ALL_WINDOW_FEEL)));
			break;
		case MSG_OPEN_PLAYER_SETTINGS:
			
			break;
		case MSG_OPEN_AU_CODEC_SETTINGS:
			{
				int i;
				BWindow *p;
				BView *v;
				bool exist=false;
				if(!drawview->HasAudioTrack())
					break;
				for(i=0; p=be_app->WindowAt(i); i++)
					if(!strcmp(p->Title(), "Audio Codec Settings"))
						exist=true;
				if(exist)
					break;
				v = drawview->AudioTrack()->GetParameterView();
				if(v==NULL) {
					puts("codec has no settings");
					break;
				}
				BRect frame(v->Bounds());
				frame.OffsetBy(Frame().right, Frame().top/*+10*/);

				p = new BWindow(frame, "Audio Codec Settings", B_FLOATING_WINDOW, B_NOT_ZOOMABLE|B_NOT_RESIZABLE);
				p->AddChild(v);
				p->Show();
			}
			break;
		case MSG_OPEN_VID_CODEC_SETTINGS:
			{
				int i;
				BWindow *p;
				BView *v;
				bool exist=false;
				if(!drawview->HasVideoTrack())
					break;
				for(i=0; p=be_app->WindowAt(i); i++)
					if(!strcmp(p->Title(), "Video Codec Settings"))
						exist=true;
				if(exist)
					break;
				v = drawview->VideoTrack()->GetParameterView();
				if(v==NULL) {
					puts("codec has no settings");
					break;
				}
				BRect frame(v->Bounds());
				frame.OffsetBy(Frame().right, Frame().top+10);

				p = new BWindow(frame, "Video Codec Settings", B_FLOATING_WINDOW, B_NOT_ZOOMABLE|B_NOT_RESIZABLE);
				p->AddChild(v);
				p->Show();
			}
			break;
		case MSG_OPEN:
			puts("open");
		case MSG_SET_VOL:
		case MSG_STOP:
		case MSG_PLAY:
		case MSG_PAUSE:
		case MSG_VOL_UP:
		case MSG_VOL_DOWN:
		case MSG_SEEK:
		case MSG_USE_RENDERER:
		case MSG_USE_TIMEREF:
		case MSG_EN_HACK_DIVX_SEEK:
		case MSG_EN_HACK_DIVX_SYNC:
			drawview->looper->PostMessage(message);
			break;
		case MSG_CLOSE_WIN:
			Quit();
			break;
		default:
//			message->PrintToStream();
#ifdef USE_DIRECT_WINDOW
			BDirectWindow::MessageReceived(message);
#else
			BWindow::MessageReceived(message);
#endif
			break;
	}
}


void PlayerWindow::Zoom(BPoint origin, float width, float height)
{
	puts("Zoom()");
	SetFullScreen(!FullScreen());
}

bool PlayerWindow::FullScreen()
{
	return fFullScreen;
}

void PlayerWindow::SetScale(int scale)
{
	static float wh=0.0;
	static float ww=0.0;
	drawview->GetPreferredSize(&ww, &wh);
	if(!FullScreen()) wh-=kMediaBarHeight;
	if(scale==0) {
		wh*=0.5;
		ww*=0.5;
	} else if(scale<5) {
		wh*=scale;
		ww*=scale;
	}
	if(!FullScreen()) wh+=kMediaBarHeight;
//	if(scale==5) // other rez
	ResizeTo(ww, wh);	
}

void PlayerWindow::SetFullScreen(bool fs)
{
	static float wx=0.0;
	static float wy=0.0;
	static float ww=0.0;
	static float wh=0.0;
	
	float w = 0.0;
	float h = 0.0;
	drawview->SetFullScreen(fs);	
	if(fs) {
		if(!FullScreen()) {
			wx = Frame().left;
			wy = Frame().top;
			ww = Frame().right-Frame().left;
			wh = Frame().bottom-Frame().top;
		}
		BScreen s;
		w=s.Frame().right/*+1*/-s.Frame().left;
		h=s.Frame().bottom/*+1*/-s.Frame().top;
		MoveTo(s.Frame().left, s.Frame().top);
		SetZoomLimits(w, h);
		ResizeTo(w, h);
	} else {
		
		if(wx==0.0) wx = 80;
		if(wy==0.0) wy = 80;
		if(ww==0.0 || wh==0.0)
			drawview->GetPreferredSize(&ww, &wh);
//	SetZoomLimits(w, h);
		ResizeTo(ww, wh);
		if(FullScreen())
			MoveTo(wx, wy);
	}
	fFullScreen = fs;
}


