#ifndef CSCONV_H
#define CSCONV_H

// some defs/eqs from:
// http://www.nevrax.org/docs/doxygen/nel/jccolor_c-source.html
// and http://www.eng2.uconn.edu/~zhangl/convert.htm

// we work on 8 bit values
#define MAXJSAMPLE 255
#define MAXSAMPLE MAXJSAMPLE
#define CENTERJSAMPLE 128

#define SCALEBITS 16

#define CBCR_OFFSET ((INT32) CENTERJSAMPLE << SCALEBITS)
#define ONE_HALF ((INT32) 1 << (SCALEBITS-1))
#define FIX(x) ((INT32) ((x) * (1L<<SCALEBITS) + 0.5))
/*
#define R_Y_OFF 0
#define G_Y_OFF (1*(MAXJSAMPLE+1))
#define B_Y_OFF (2*(MAXJSAMPLE+1))
#define R_CB_OFF (3*(MAXJSAMPLE+1))
#define G_CB_OFF (4*(MAXJSAMPLE+1))
#define B_CB_OFF (5*(MAXJSAMPLE+1))
#define R_CR_OFF B_CB_OFF
#define G_CR_OFF (6*(MAXJSAMPLE+1))
#define B_CR_OFF (7*(MAXJSAMPLE+1))
#define TABLE_SIZE (8*(MAXJSAMPLE+1))
*/
#define TABLE_SIZE (MAXJSAMPLE+1)

// Y: 16 to 235
#define Y_SPAN 216
#define Y_OFFSET 16

// the other ones are closer to Be's overlay specs in GraphicsDefs.h (loss/saturation points)
//#define NEVRAX_EQS

// with this it doesn't mean the luma between 2 pixels and use the luma of the first
// (less CPU)
#define RGBYCC_NO_MEAN

#endif //CSCONV_H
