#include "TCPConnection.h"
#include "TCPListener.h"

TCPConnection::TCPConnection( int32 socket, TCPListener *threadManager )
{
	// Assign proxy serial number
	static int32 nextPSN = 0;
	psn = nextPSN;
	nextPSN++;
	
	this->clientSocket = socket;
	this->threadManager = threadManager;
}

TCPConnection::~TCPConnection( void )
{
	
}

void TCPConnection::Quit( void )
{
	Shutdown( CONNECTION_TERMINATED );
}

int32 TCPConnection::GetPSN( void )
{
	return psn;
}

void TCPConnection::Shutdown( status_t error )
{
	threadManager->DeleteConnection( this );
}