/******************************************************************************
//
//	File:		AdminCon.h
//
//	Description: Handles the Admin Connection
// 		
// 		
//
//	Copyright 1998, Joe Kloss
//
*******************************************************************************/

#ifndef ADMIN_CON_H
#define ADMIN_CON_H

#include "TCPConnection.h"
#include "benaphore.h"

extern class ProxyAdmin;

class AdminConnection : public TCPConnection
{
	public:
		AdminConnection( int32 socket, ProxyAdmin *threadManager, const BMessenger *messenger );
		~AdminConnection( void );
		virtual status_t Run( void );
		
	protected:
		virtual void Shutdown( status_t error ); // Called when connection can't continue
		static int32 thread_entry_point( void *arg );
		int32 ThreadLoop( void );
		
		status_t HandleGet( BPositionIO *reply, char *request );
		status_t HandlePost( BPositionIO *reply, const char *request );
		status_t HandleHead( BPositionIO *reply, const char *request );
		status_t MakeDefaultReply( BPositionIO *reply );
		void WriteHeader( BPositionIO *reply, int32 statusCode, size_t bodySize, bool refresh = false );
		size_t WriteReplyBody( BPositionIO *msgBody );
		bool Authenticate( BPositionIO *reply, const char *request );
	
	protected:
		thread_id 		conThread;
		bool			running;
		Benaphore		*lock;
		BMessenger		*messenger;
		ProxyAdmin		*pAdmin;
};

#endif
