#include <Archivable.h>

#ifndef _COMPONENT_LISTENER_H_
#define _COMPONENT_LISTENER_H_

class ComponentListener {
private:
	ComponentListener* next;
public:
	ComponentListener();
	
	static	void InformRenamed(BArchivable* comp, char* oldName, char* newName);
	static	void InformAdded(BArchivable* comp);
	static	void InformDeleted(BArchivable* comp);
	
	virtual void Renamed(BArchivable* comp, char* oldName, char* newName) = 0;
	virtual void Added(BArchivable* comp) = 0;
	virtual void Deleted(BArchivable* comp) = 0;
};

#endif
