#include <ClassInfo.h>
#include <Window.h>
#include <View.h>
#include <Message.h>
#include <Rect.h>
#include <stdio.h>

#include "FrameProperty.h"

/* FramePropertyEnumerator */

FramePropertyEnumerator* framePropertyEnumerator = new FramePropertyEnumerator();

bool FramePropertyEnumerator::CanHandle(BArchivable* object) {
	if(object)
		return is_kind_of(object, BView) /*| is_kind_of(object, BWindow)*/;
	else
		return false;
}

void FramePropertyEnumerator::EnumerateProperties(BArchivable* object, BMessage* message) {
	BRect r;
	
	if(message->FindRect("_frame", &r)==B_OK) {
		message->RemoveName("_frame");
		
		message->AddInt32(PROP_TOP, r.top);
		message->AddInt32(PROP_LEFT, r.left);
		message->AddInt32(PROP_WIDTH, r.right-r.left);
		message->AddInt32(PROP_HEIGHT, r.bottom-r.top);
	}
}


/* FramePropertyEditor */

CPropertyEditor* framePropertyEditor = RegisterPropertyEditor(new FramePropertyEditor());

bool FramePropertyEditor::CanHandle(BArchivable* object, char* name, int32 type) {
	if(object)
		return (is_kind_of(object, BView) /*| is_kind_of(object, BWindow)*/) && 
		       (type==B_INT32_TYPE) && 
			   (strcmp(PROP_TOP, name)==0 ||
				strcmp(PROP_LEFT, name)==0 ||
				strcmp(PROP_WIDTH, name)==0 ||
				strcmp(PROP_HEIGHT, name)==0);
	else
		return false;
}

void FramePropertyEditor::SetAsString(BMessage* message, CProperty* property, char* buf) {
	BRect r;
	char* name = property->Name();
	int value;
	if(message->FindRect("_frame", &r)==B_OK) {
		sscanf(buf, "%d", &value);
			
		float w = r.right - r.left;
		float h = r.bottom - r.top;
/*
		if(is_kind_of(property->Handler(), BWindow)) {
			BWindow* win = (BWindow*)property->Handler();
			
			win->Lock();
			if(strcmp(PROP_TOP, name)==0) {
				win->MoveTo(r.left, value);
			} else 
			if(strcmp(PROP_LEFT, name)==0) {
				win->MoveTo(value, r.top);
			} else
			if(strcmp(PROP_WIDTH, name)==0) {
				win->ResizeTo(value, h);
			} else
			if(strcmp(PROP_HEIGHT, name)==0) {
				win->ResizeTo(w, value);
			}
			win->Unlock();
		} else */{
			if(strcmp(PROP_TOP, name)==0) {
				r.top = value;
				r.bottom = value + h;
			} else 
			if(strcmp(PROP_LEFT, name)==0) {
				r.left = value;
				r.right = value + w;
			} else
			if(strcmp(PROP_WIDTH, name)==0) {
				r.right = r.left + value;
			} else
			if(strcmp(PROP_HEIGHT, name)==0) {
				r.bottom = r.top + value;
			}
			
			message->ReplaceRect("_frame", r);
		}
	}
}

