#include <stdio.h>

#ifndef _INFO_STORE_H_
#define _INFO_STORE_H_

class CInfoNode;

class CValueNode {
private:
	CInfoNode*	node;
	CValueNode* next;
	char* name;
	char* value;
	
	CValueNode(CInfoNode* aNode, char* aName, char* aValue);
	~CValueNode();
	
	friend class CInfoNode;
};

class CInfoNode {
private:
	char		name[256];
	
	CInfoNode*	parent;
	CInfoNode*	children;
	CValueNode*	values;
	CInfoNode*	next;
	
	void	Add(CInfoNode* item);
	void	Remove(CInfoNode* item);
	CValueNode*	FindValue(char* aName);	
	
	void	Init();
	void	Parse(char* buf, FILE* file);
public:
	CInfoNode(CInfoNode* aParent, char* aName);
	CInfoNode(FILE* file);
	
	~CInfoNode();
	
	void		SaveToStream(FILE* file);
	
	CInfoNode*	Find(char* aName);
	void		DeleteChildren();
	void		Clear();
		
	char*		Name();
	void		SetName(char* aName);
	
	CInfoNode*	Parent();
	CInfoNode*	FirstChild();
	CInfoNode*	Next();

	bool		HasChildren();
	
	char*		Value(char* aName);
	void		SetValue(char* aName, char* aValue);
	
	friend class CValueNode;
};

class CInfoManager { 
public:
	static CInfoNode* FindInfo(void* aItem);
	static void SetInfo(void* aItem, CInfoNode* aInfo);
	static void RemoveInfo(void* aItem);
};
#endif
